/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowableArtifact
implements Externalizable {
    private Throwable throwable;

    public ThrowableArtifact(Throwable throwable) {
        this.throwable = throwable;
    }

    public ThrowableArtifact() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Stack<MockThrowable> stack = new Stack<MockThrowable>();
        for (Throwable cause = this.throwable; cause != null; cause = cause.getCause()) {
            stack.add(new MockThrowable(cause));
        }
        out.writeObject(stack);
        try {
            out.writeObject(this.throwable);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Stack stack = (Stack)in.readObject();
        try {
            this.throwable = (Throwable)in.readObject();
        }
        catch (Exception e) {
            this.throwable = this.createMockThrowable(stack);
        }
    }

    private Throwable createMockThrowable(Stack<MockThrowable> stack) {
        Throwable throwable = stack.pop();
        while (!stack.isEmpty()) {
            throwable = stack.pop().initCause(throwable);
        }
        return new RuntimeException("The exception sent could not be serialized or deserialized.  This is a mock recreation:\n" + throwable, throwable);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String toString() {
        return this.throwable.toString();
    }

    private static class MockThrowable
    extends Throwable {
        private final String classType;

        public MockThrowable(Throwable t) {
            this(t.getMessage(), t.getClass().getName(), t.getStackTrace());
        }

        public MockThrowable(String message, String classType, StackTraceElement[] stackTrace) {
            super(message);
            this.classType = classType;
            this.setStackTrace(stackTrace);
        }

        public String toString() {
            String s = this.classType;
            String message = this.getLocalizedMessage();
            return message != null ? s + ": " + message : s;
        }
    }
}

