/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ProtocolMetaData {
    private static final String OEJB = "OEJP";
    private String id;
    private int major;
    private int minor;

    public ProtocolMetaData() {
    }

    public ProtocolMetaData(String version) {
        this.init("OEJP/" + version);
    }

    private void init(String spec) {
        assert (spec.matches("^OEJP/[0-9]\\.[0-9]$")) : "Protocol version spec must follow format [ \"OEJB\" \"/\" 1*DIGIT \".\" 1*DIGIT ]";
        char[] chars = new char[8];
        spec.getChars(0, chars.length, chars, 0);
        this.id = new String(chars, 0, 4);
        this.major = Integer.parseInt(new String(chars, 5, 1));
        this.minor = Integer.parseInt(new String(chars, 7, 1));
    }

    public String getId() {
        return this.id;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getVersion() {
        return this.major + "." + this.minor;
    }

    public String getSpec() {
        return this.id + "/" + this.major + "." + this.minor;
    }

    public void writeExternal(OutputStream out) throws IOException {
        out.write(this.getSpec().getBytes("UTF-8"));
    }

    public void readExternal(InputStream in) throws IOException {
        byte[] spec = new byte[8];
        for (int i = 0; i < spec.length; ++i) {
            spec[i] = (byte)in.read();
            if (spec[i] != -1) continue;
            throw new EOFException("Unable to read protocol version.  Reached the end of the stream.");
        }
        this.init(new String(spec, "UTF-8"));
    }
}

