/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.openejb.client.ClusterableRequest;

public class JNDIRequest
implements ClusterableRequest {
    private transient int requestMethod = -1;
    private transient String requestString;
    private transient String moduleId;
    private transient int serverHash;

    public JNDIRequest() {
    }

    public JNDIRequest(int requestMethod, String requestString) {
        this.requestMethod = requestMethod;
        this.requestString = requestString;
    }

    public byte getRequestType() {
        return 1;
    }

    public int getRequestMethod() {
        return this.requestMethod;
    }

    public String getRequestString() {
        return this.requestString;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public void setRequestMethod(int requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setRequestString(String requestString) {
        this.requestString = requestString;
    }

    public void setServerHash(int serverHash) {
        this.serverHash = serverHash;
    }

    public int getServerHash() {
        return this.serverHash;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        this.requestMethod = in.readByte();
        this.requestString = in.readUTF();
        this.moduleId = (String)in.readObject();
        this.serverHash = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeByte((byte)this.requestMethod);
        out.writeUTF(this.requestString);
        out.writeObject(this.moduleId);
        out.writeInt(this.serverHash);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        switch (this.requestMethod) {
            case 27: {
                sb.append("JNDI_LOOKUP:");
                break;
            }
            case 28: {
                sb.append("JNDI_LIST:");
                break;
            }
            case 29: {
                sb.append("JNDI_LIST_BINDINGS:");
            }
        }
        sb.append(this.moduleId).append(":");
        sb.append(this.requestString);
        return sb.toString();
    }
}

