/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


package javax.resource.spi.work;

import javax.resource.spi.RetryableException;

/**
 * @version $Rev: 920245 $ $Date: 2010-03-08 04:25:34 -0500 (Mon, 08 Mar 2010) $
 * @since 1.6
 */
public class RetryableWorkRejectedException extends WorkRejectedException implements RetryableException {

    private static final long serialVersionUID=8198870267352154108L;

    public RetryableWorkRejectedException() {
    }

    public RetryableWorkRejectedException(String message) {
        super(message);
    }

    public RetryableWorkRejectedException(Throwable cause) {
        super(cause);
    }

    public RetryableWorkRejectedException(String message, Throwable cause) {
        super(message, cause);
    }

    public RetryableWorkRejectedException(String message, String errorCode) {
        super(message, errorCode);
    }
}
