/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


package javax.servlet;

import javax.servlet.annotation.MultipartConfig;

/**
 * @version $Rev: 831066 $ $Date: 2009-10-29 15:19:48 -0400 (Thu, 29 Oct 2009) $
 * @since 3.0
 */
public class MultipartConfigElement {
    private final int fileSizeThreshold;
    private final String location;
    private final long maxFileSize;
    private final long maxRequestSize;

    public MultipartConfigElement(String location) {
        this.location = location == null ? "" : location;
        fileSizeThreshold = 0;
        maxFileSize = -1L;
        maxRequestSize = -1L;
    }

    public MultipartConfigElement(MultipartConfig config) {
        location = config.location();
        fileSizeThreshold = config.fileSizeThreshold();
        maxFileSize = config.maxFileSize();
        maxRequestSize = config.maxRequestSize();
    }

    public MultipartConfigElement(String location, long maxFileSize, long maxRequestSize, int fileSizeThreshold) {
        this.fileSizeThreshold = fileSizeThreshold;
        this.location = location;
        this.maxFileSize = maxFileSize;
        this.maxRequestSize = maxRequestSize;
    }

    public int getFileSizeThreshold() {
        return fileSizeThreshold;
    }

    public String getLocation() {
        return location;
    }

    public long getMaxFileSize() {
        return maxFileSize;
    }

    public long getMaxRequestSize() {
        return maxRequestSize;
    }
}
