/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MultiStatus
implements DavConstants,
XmlSerializable {
    private Map responses = new LinkedHashMap();
    private String responseDescription;

    public void addResourceProperties(DavResource resource, DavPropertyNameSet propNameSet, int propFindType, int depth) {
        this.addResponse(new MultiStatusResponse(resource, propNameSet, propFindType));
        if (depth > 0 && resource.isCollection()) {
            DavResourceIterator iter = resource.getMembers();
            while (iter.hasNext()) {
                this.addResourceProperties(iter.nextResource(), propNameSet, propFindType, depth - 1);
            }
        }
    }

    public void addResourceProperties(DavResource resource, DavPropertyNameSet propNameSet, int depth) {
        this.addResourceProperties(resource, propNameSet, 0, depth);
    }

    public void addResourceStatus(DavResource resource, int status, int depth) {
        this.addResponse(new MultiStatusResponse(resource.getHref(), status));
        if (depth > 0 && resource.isCollection()) {
            DavResourceIterator iter = resource.getMembers();
            while (iter.hasNext()) {
                this.addResourceStatus(iter.nextResource(), status, depth - 1);
            }
        }
    }

    public void addResponse(MultiStatusResponse response) {
        this.responses.put(response.getHref(), response);
    }

    public MultiStatusResponse[] getResponses() {
        return this.responses.values().toArray(new MultiStatusResponse[this.responses.size()]);
    }

    public void setResponseDescription(String responseDescription) {
        this.responseDescription = responseDescription;
    }

    public String getResponseDescription() {
        return this.responseDescription;
    }

    public Element toXml(Document document) {
        Element multistatus = DomUtil.createElement((Document)document, (String)"multistatus", (Namespace)NAMESPACE);
        Iterator it = this.responses.values().iterator();
        while (it.hasNext()) {
            multistatus.appendChild(((MultiStatusResponse)it.next()).toXml(document));
        }
        if (this.responseDescription != null) {
            Element respDesc = DomUtil.createElement((Document)document, (String)"responsedescription", (Namespace)NAMESPACE, (String)this.responseDescription);
            multistatus.appendChild(respDesc);
        }
        return multistatus;
    }

    public static MultiStatus createFromXml(Element multistatusElement) {
        if (!DomUtil.matches((Node)multistatusElement, (String)"multistatus", (Namespace)NAMESPACE)) {
            throw new IllegalArgumentException("DAV:multistatus element expected.");
        }
        MultiStatus multistatus = new MultiStatus();
        ElementIterator it = DomUtil.getChildren((Element)multistatusElement, (String)"response", (Namespace)NAMESPACE);
        while (it.hasNext()) {
            Element respElem = it.nextElement();
            MultiStatusResponse response = MultiStatusResponse.createFromXml((Element)respElem);
            multistatus.addResponse(response);
        }
        multistatus.setResponseDescription(DomUtil.getChildText((Element)multistatusElement, (String)"responsedescription", (Namespace)NAMESPACE));
        return multistatus;
    }
}

