/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.PermissionModeUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.ssh.interactive.InteractiveUserInfo;
import org.apache.maven.wagon.providers.ssh.interactive.NullInteractiveUserInfo;
import org.apache.maven.wagon.providers.ssh.interactive.UserInfoUIKeyboardInteractiveProxy;
import org.apache.maven.wagon.providers.ssh.knownhost.KnownHostsProvider;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractSshWagon
extends AbstractWagon
implements CommandExecutor {
    public static final int DEFAULT_SSH_PORT = 22;
    public static final int SOCKS5_PROXY_PORT = 1080;
    protected Session session;
    public static final String EXEC_CHANNEL = "exec";
    private static final int LINE_BUFFER_SIZE = 8192;
    private static final byte LF = 10;
    private KnownHostsProvider knownHostsProvider;
    private InteractiveUserInfo interactiveUserInfo;
    private UIKeyboardInteractive uIKeyboardInteractive;

    public void openConnection() throws AuthenticationException {
        File privateKey;
        if (this.authenticationInfo == null) {
            this.authenticationInfo = new AuthenticationInfo();
        }
        if (this.authenticationInfo.getUserName() == null) {
            this.authenticationInfo.setUserName(System.getProperty("user.name"));
        }
        JSch sch = new JSch();
        int port = this.getRepository().getPort();
        if (port == -1) {
            port = 22;
        }
        String host = this.getRepository().getHost();
        try {
            this.session = sch.getSession(this.authenticationInfo.getUserName(), host, port);
        }
        catch (JSchException e) {
            this.fireSessionError((Exception)((Object)e));
            throw new AuthenticationException("Cannot connect. Reason: " + e.getMessage(), (Throwable)e);
        }
        if (this.authenticationInfo.getPassword() == null && (privateKey = this.authenticationInfo.getPrivateKey() != null ? new File(this.authenticationInfo.getPrivateKey()) : this.findPrivateKey()).exists()) {
            if (this.authenticationInfo.getPassphrase() == null) {
                this.authenticationInfo.setPassphrase("");
            }
            this.fireSessionDebug("Using private key: " + privateKey);
            try {
                sch.addIdentity(privateKey.getAbsolutePath(), this.authenticationInfo.getPassphrase());
            }
            catch (JSchException e) {
                this.fireSessionError((Exception)((Object)e));
                throw new AuthenticationException("Cannot connect. Reason: " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.proxyInfo != null && this.proxyInfo.getHost() != null) {
            ProxySOCKS5 proxy;
            int proxyPort = this.proxyInfo.getPort();
            if (proxyPort == 1080) {
                proxy = new ProxySOCKS5(this.proxyInfo.getHost());
                proxy.setUserPasswd(this.proxyInfo.getUserName(), this.proxyInfo.getPassword());
            } else {
                proxy = new ProxyHTTP(this.proxyInfo.getHost(), proxyPort);
                ((ProxyHTTP)proxy).setUserPasswd(this.proxyInfo.getUserName(), this.proxyInfo.getPassword());
            }
            this.session.setProxy((Proxy)proxy);
        } else {
            this.session.setProxy(null);
        }
        Properties config = new Properties();
        config.setProperty("BatchMode", this.interactive ? "no" : "yes");
        if (!this.interactive) {
            this.interactiveUserInfo = new NullInteractiveUserInfo();
            this.uIKeyboardInteractive = null;
        }
        Object ui = new WagonUserInfo(this.authenticationInfo, this.interactiveUserInfo);
        if (this.uIKeyboardInteractive != null) {
            ui = new UserInfoUIKeyboardInteractiveProxy((UserInfo)ui, this.uIKeyboardInteractive);
        }
        if (this.knownHostsProvider != null) {
            try {
                this.knownHostsProvider.addConfiguration(config);
                this.knownHostsProvider.addKnownHosts(sch, (UserInfo)ui);
            }
            catch (JSchException e) {
                this.fireSessionError((Exception)((Object)e));
            }
        }
        this.session.setConfig(config);
        this.session.setUserInfo((UserInfo)ui);
        try {
            this.session.connect();
            if (this.knownHostsProvider != null) {
                this.knownHostsProvider.storeKnownHosts(sch);
            }
        }
        catch (JSchException e) {
            this.fireSessionError((Exception)((Object)e));
            throw new AuthenticationException("Cannot connect. Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    private File findPrivateKey() {
        File privateKey;
        String privateKeyDirectory = System.getProperty("wagon.privateKeyDirectory");
        if (privateKeyDirectory == null) {
            privateKeyDirectory = System.getProperty("user.home");
        }
        if (!(privateKey = new File(privateKeyDirectory, ".ssh/id_dsa")).exists()) {
            privateKey = new File(privateKeyDirectory, ".ssh/id_rsa");
        }
        return privateKey;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeCommand(String command) throws CommandExecutionException {
        OutputStream out;
        InputStream err;
        InputStream in;
        ChannelExec channel;
        block10: {
            channel = null;
            in = null;
            err = null;
            out = null;
            try {
                this.fireTransferDebug("Executing command: " + command);
                channel = (ChannelExec)this.session.openChannel(EXEC_CHANNEL);
                channel.setCommand(command + "\n");
                out = channel.getOutputStream();
                in = channel.getInputStream();
                err = channel.getErrStream();
                channel.connect();
                BufferedReader r = new BufferedReader(new InputStreamReader(err));
                ArrayList<String> output = null;
                while (true) {
                    String line;
                    if ((line = r.readLine()) == null) {
                        if (output != null) {
                            break;
                        }
                        break block10;
                    }
                    if (output == null) {
                        output = new ArrayList<String>();
                    }
                    if (line.startsWith("Could not chdir to home directory") || line.endsWith("ttyname: Operation not supported")) continue;
                    output.add(line);
                }
                if (!output.isEmpty()) {
                    throw new CommandExecutionException("Exit code: " + channel.getExitStatus() + " - " + StringUtils.join(output.iterator(), (String)"\n"));
                }
            }
            catch (JSchException e) {
                try {
                    throw new CommandExecutionException("Cannot execute remote command: " + command, (Throwable)e);
                    catch (IOException e2) {
                        throw new CommandExecutionException("Cannot execute remote command: " + command, (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(out);
                    IOUtil.close(in);
                    IOUtil.close(err);
                    if (channel == null) throw throwable;
                    channel.disconnect();
                    throw throwable;
                }
            }
        }
        IOUtil.close((OutputStream)out);
        IOUtil.close((InputStream)in);
        IOUtil.close((InputStream)err);
        if (channel == null) return;
        channel.disconnect();
    }

    protected String readLine(InputStream in) throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            if (sb.length() > 8192) {
                throw new IOException("Remote server sent a too long line");
            }
            int c = in.read();
            if (c < 0) {
                throw new IOException("Remote connection terminated unexpectedly.");
            }
            if (c == 10) break;
            sb.append((char)c);
        }
        return sb.toString();
    }

    protected static void sendEom(OutputStream out) throws IOException {
        out.write(0);
        out.flush();
    }

    public void closeConnection() {
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }

    protected void handleGetException(Resource resource, Exception e, File destination) throws TransferFailedException, ResourceDoesNotExistException {
        boolean deleted;
        this.fireTransferError(resource, e, 5);
        if (destination.exists() && !(deleted = destination.delete())) {
            destination.deleteOnExit();
        }
        String msg = "Error occured while downloading '" + resource + "' from the remote repository:" + this.getRepository();
        throw new TransferFailedException(msg, (Throwable)e);
    }

    public final KnownHostsProvider getKnownHostsProvider() {
        return this.knownHostsProvider;
    }

    public final void setKnownHostsProvider(KnownHostsProvider knownHostsProvider) {
        if (knownHostsProvider == null) {
            throw new IllegalArgumentException("knownHostsProvider can't be null");
        }
        this.knownHostsProvider = knownHostsProvider;
    }

    public InteractiveUserInfo getInteractiveUserInfo() {
        return this.interactiveUserInfo;
    }

    public void setInteractiveUserInfo(InteractiveUserInfo interactiveUserInfo) {
        if (interactiveUserInfo == null) {
            throw new IllegalArgumentException("interactiveUserInfo can't be null");
        }
        this.interactiveUserInfo = interactiveUserInfo;
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        File zipFile;
        String basedir = this.getRepository().getBasedir();
        destinationDirectory = StringUtils.replace((String)destinationDirectory, (String)"\\", (String)"/");
        String path = AbstractWagon.getPath((String)basedir, (String)destinationDirectory);
        try {
            String dirPerms;
            if (this.getRepository().getPermissions() != null && (dirPerms = this.getRepository().getPermissions().getDirectoryMode()) != null) {
                String umaskCmd = "umask " + PermissionModeUtils.getUserMaskFor((String)dirPerms);
                this.executeCommand(umaskCmd);
            }
            String mkdirCmd = "mkdir -p " + path;
            this.executeCommand(mkdirCmd);
        }
        catch (CommandExecutionException e) {
            throw new TransferFailedException("Error performing commands for file transfer", (Throwable)e);
        }
        try {
            zipFile = File.createTempFile("wagon", ".zip");
            zipFile.deleteOnExit();
            List files = FileUtils.getFileNames((File)sourceDirectory, (String)"**/**", (String)"", (boolean)false);
            this.createZip(files, zipFile, sourceDirectory);
        }
        catch (IOException e) {
            throw new TransferFailedException("Unable to create ZIP archive of directory", (Throwable)e);
        }
        this.put(zipFile, AbstractWagon.getPath((String)destinationDirectory, (String)zipFile.getName()));
        try {
            this.executeCommand("cd " + path + "; unzip -q -o " + zipFile.getName() + "; rm -f " + zipFile.getName());
            zipFile.delete();
            RepositoryPermissions permissions = this.getRepository().getPermissions();
            if (permissions != null && permissions.getGroup() != null) {
                this.executeCommand("chgrp -Rf " + permissions.getGroup() + " " + path);
            }
            if (permissions != null && permissions.getFileMode() != null) {
                this.executeCommand("chmod -Rf " + permissions.getFileMode() + " " + path);
            }
        }
        catch (CommandExecutionException e) {
            throw new TransferFailedException("Error performing commands for file transfer", (Throwable)e);
        }
    }

    public boolean supportsDirectoryCopy() {
        return true;
    }

    public abstract /* synthetic */ void put(File var1, String var2) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException;

    public abstract /* synthetic */ boolean getIfNewer(String var1, File var2, long var3) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException;

    public abstract /* synthetic */ void get(String var1, File var2) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException;

    private static class WagonUserInfo
    implements UserInfo {
        private final InteractiveUserInfo userInfo;
        private String password;
        private String passphrase;

        WagonUserInfo(AuthenticationInfo authInfo, InteractiveUserInfo userInfo) {
            this.userInfo = userInfo;
            this.password = authInfo.getPassword();
            this.passphrase = authInfo.getPassphrase();
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean promptPassphrase(String arg0) {
            if (this.passphrase == null && this.userInfo != null) {
                this.passphrase = this.userInfo.promptPassphrase(arg0);
            }
            return this.passphrase != null;
        }

        public boolean promptPassword(String arg0) {
            if (this.password == null && this.userInfo != null) {
                this.password = this.userInfo.promptPassword(arg0);
            }
            return this.password != null;
        }

        public boolean promptYesNo(String arg0) {
            if (this.userInfo != null) {
                return this.userInfo.promptYesNo(arg0);
            }
            return false;
        }

        public void showMessage(String message) {
            if (this.userInfo != null) {
                this.userInfo.showMessage(message);
            }
        }
    }
}

