/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Queue;
import org.apache.maven.surefire.common.junit4.JUnit4Reflector;
import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.common.junit4.Notifier;
import org.apache.maven.surefire.junitcore.FilteringRequest;
import org.apache.maven.surefire.junitcore.JUnitCoreParameters;
import org.apache.maven.surefire.junitcore.pc.ParallelComputer;
import org.apache.maven.surefire.junitcore.pc.ParallelComputerBuilder;
import org.apache.maven.surefire.report.ConsoleStream;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.TestsToRun;
import org.junit.Ignore;
import org.junit.runner.Computer;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.StoppedByUserException;

final class JUnitCoreWrapper {
    private final Notifier notifier;
    private final JUnitCoreParameters jUnitCoreParameters;
    private final ConsoleStream consoleStream;

    JUnitCoreWrapper(Notifier notifier, JUnitCoreParameters jUnitCoreParameters, ConsoleStream consoleStream) {
        this.notifier = notifier;
        this.jUnitCoreParameters = jUnitCoreParameters;
        this.consoleStream = consoleStream;
    }

    void execute(TestsToRun testsToRun, Filter filter) throws TestSetFailedException {
        this.execute(testsToRun, true, Collections.<RunListener>emptyList(), filter);
    }

    void execute(TestsToRun testsToRun, Collection<RunListener> listeners, Filter filter) throws TestSetFailedException {
        this.execute(testsToRun, false, listeners, filter);
    }

    private void execute(TestsToRun testsToRun, boolean useIterated, Collection<RunListener> listeners, Filter filter) throws TestSetFailedException {
        if (testsToRun.allowEagerReading()) {
            this.executeEager(testsToRun, filter, listeners);
        } else {
            this.executeLazy(testsToRun, useIterated, filter, listeners);
        }
    }

    private JUnitCore createJUnitCore(Notifier notifier, Collection<RunListener> listeners) {
        JUnitCore junitCore = new JUnitCore();
        notifier.addListeners(listeners);
        return junitCore;
    }

    private void executeEager(TestsToRun testsToRun, Filter filter, Collection<RunListener> listeners) throws TestSetFailedException {
        JUnitCore junitCore = this.createJUnitCore(this.notifier, listeners);
        Class[] tests = testsToRun.getLocatedClasses();
        Computer computer = this.createComputer();
        this.createRequestAndRun(filter, computer, junitCore.withReportedTests(tests), tests);
    }

    private void executeLazy(TestsToRun testsToRun, boolean useIterated, Filter filter, Collection<RunListener> listeners) throws TestSetFailedException {
        Iterator it;
        JUnitCore junitCore = this.createJUnitCore(this.notifier, listeners);
        Iterator iterator = it = useIterated ? testsToRun.iterated() : testsToRun.iterator();
        while (it.hasNext()) {
            Class clazz = (Class)it.next();
            Computer computer = this.createComputer();
            this.createRequestAndRun(filter, computer, junitCore.withReportedTests(clazz), clazz);
        }
    }

    private void createRequestAndRun(Filter filter, Computer computer, JUnitCore junitCore, Class<?> ... classesToRun) throws TestSetFailedException {
        String timeoutMessage;
        Request req = Request.classes((Computer)computer, (Class[])classesToRun);
        if (filter != null && (req = new FilteringRequest(req, filter)).getRunner() == null) {
            return;
        }
        Result run = junitCore.run(req.getRunner());
        JUnit4RunListener.rethrowAnyTestMechanismFailures(run);
        if (computer instanceof ParallelComputer && (timeoutMessage = ((ParallelComputer)computer).describeElapsedTimeout()).length() != 0) {
            throw new TestSetFailedException(timeoutMessage);
        }
    }

    private Computer createComputer() {
        return this.jUnitCoreParameters.isNoThreading() ? Computer.serial() : new ParallelComputerBuilder(this.consoleStream, this.jUnitCoreParameters).buildComputer();
    }

    private final class JUnitCore
    extends org.apache.maven.surefire.junitcore.JUnitCore {
        JUnitCore() {
            super(JUnitCoreWrapper.this.notifier);
        }

        JUnitCore withReportedTests(Class<?> ... tests) {
            Queue<String> stoppedTests = JUnitCoreWrapper.this.notifier.getRemainingTestClasses();
            if (stoppedTests != null) {
                for (Class<?> test : tests) {
                    stoppedTests.add(test.getName());
                }
            }
            return this;
        }

        @Override
        protected void afterException(Throwable e) throws TestSetFailedException {
            if (JUnitCoreWrapper.this.notifier.isFailFast() && e instanceof StoppedByUserException) {
                Queue<String> stoppedTests = JUnitCoreWrapper.this.notifier.getRemainingTestClasses();
                if (stoppedTests != null) {
                    String clazz;
                    String reason = e.getClass().getName();
                    Ignore reasonForSkippedTest = JUnit4Reflector.createIgnored(reason);
                    while ((clazz = stoppedTests.poll()) != null) {
                        Description skippedTest = JUnit4Reflector.createDescription(clazz, new Annotation[]{reasonForSkippedTest});
                        JUnitCoreWrapper.this.notifier.fireTestIgnored(skippedTest);
                    }
                }
            } else {
                super.afterException(e);
            }
        }

        @Override
        protected void afterFinished() {
            Queue<String> stoppedTests = JUnitCoreWrapper.this.notifier.getRemainingTestClasses();
            if (stoppedTests != null) {
                stoppedTests.clear();
            }
        }
    }
}

