/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit;

import java.util.Iterator;
import org.apache.maven.surefire.common.junit3.JUnit3Reflector;
import org.apache.maven.surefire.common.junit3.JUnit3TestChecker;
import org.apache.maven.surefire.junit.JUnitTestSet;
import org.apache.maven.surefire.junit.PojoAndJUnit3Checker;
import org.apache.maven.surefire.junit.PojoTestSet;
import org.apache.maven.surefire.junit.SurefireTestSet;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ConsoleOutputCapture;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.ReflectionUtils;
import org.apache.maven.surefire.util.RunOrderCalculator;
import org.apache.maven.surefire.util.ScanResult;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnit3Provider
extends AbstractProvider {
    private final ClassLoader testClassLoader;
    private final PojoAndJUnit3Checker testChecker;
    private final JUnit3TestChecker jUnit3TestChecker;
    private final JUnit3Reflector reflector;
    private final ProviderParameters providerParameters;
    private final RunOrderCalculator runOrderCalculator;
    private TestsToRun testsToRun;
    private final ScanResult scanResult;

    public JUnit3Provider(ProviderParameters booterParameters) {
        this.providerParameters = booterParameters;
        this.testClassLoader = booterParameters.getTestClassLoader();
        this.scanResult = booterParameters.getScanResult();
        this.runOrderCalculator = booterParameters.getRunOrderCalculator();
        this.reflector = new JUnit3Reflector(this.testClassLoader);
        this.jUnit3TestChecker = new JUnit3TestChecker(this.testClassLoader);
        this.testChecker = new PojoAndJUnit3Checker(this.jUnit3TestChecker);
    }

    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException {
        if (this.testsToRun == null) {
            this.testsToRun = forkTestSet instanceof TestsToRun ? (TestsToRun)forkTestSet : (forkTestSet instanceof Class ? TestsToRun.fromClass((Class)((Class)forkTestSet)) : this.scanClassPath());
        }
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        RunListener reporter = reporterFactory.createReporter();
        ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)((ConsoleOutputReceiver)reporter));
        String smClassName = System.getProperty("surefire.security.manager");
        if (smClassName != null) {
            SecurityManager securityManager = (SecurityManager)ReflectionUtils.instantiate((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)smClassName);
            System.setSecurityManager(securityManager);
        }
        for (Class clazz : this.testsToRun) {
            SurefireTestSet surefireTestSet = this.createTestSet(clazz);
            this.executeTestSet(surefireTestSet, reporter, this.testClassLoader);
        }
        return reporterFactory.close();
    }

    private SurefireTestSet createTestSet(Class<?> clazz) throws TestSetFailedException {
        return this.reflector.isJUnit3Available() && this.jUnit3TestChecker.accept(clazz) ? new JUnitTestSet(clazz, this.reflector) : new PojoTestSet(clazz);
    }

    private void executeTestSet(SurefireTestSet testSet, RunListener reporter, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        SimpleReportEntry report = new SimpleReportEntry(((Object)((Object)this)).getClass().getName(), testSet.getName());
        reporter.testSetStarting((ReportEntry)report);
        testSet.execute(reporter, classLoader);
        reporter.testSetCompleted((ReportEntry)report);
    }

    private TestsToRun scanClassPath() {
        TestsToRun testsToRun = this.scanResult.applyFilter((ScannerFilter)this.testChecker, this.testClassLoader);
        return this.runOrderCalculator.orderTestClasses(testsToRun);
    }

    public Iterator getSuites() {
        this.testsToRun = this.scanClassPath();
        return this.testsToRun.iterator();
    }
}

