/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.analyzer.ClassAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ClassesPatterns;
import org.apache.maven.shared.dependency.analyzer.DependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.DependencyUsage;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzerException;

@Named
@Singleton
public class DefaultProjectDependencyAnalyzer
implements ProjectDependencyAnalyzer {
    @Inject
    private ClassAnalyzer classAnalyzer;
    @Inject
    private DependencyAnalyzer dependencyAnalyzer;

    @Override
    public ProjectDependencyAnalysis analyze(MavenProject project, Collection<String> excludedClasses) throws ProjectDependencyAnalyzerException {
        try {
            ClassesPatterns excludedClassesPatterns = new ClassesPatterns(excludedClasses);
            Map<Artifact, Set<String>> artifactClassMap = this.buildArtifactClassMap(project, excludedClassesPatterns);
            Set<DependencyUsage> mainDependencyClasses = this.buildMainDependencyClasses(project, excludedClassesPatterns);
            Set<DependencyUsage> testDependencyClasses = this.buildTestDependencyClasses(project, excludedClassesPatterns);
            HashSet<DependencyUsage> dependencyClasses = new HashSet<DependencyUsage>();
            dependencyClasses.addAll(mainDependencyClasses);
            dependencyClasses.addAll(testDependencyClasses);
            Set<DependencyUsage> testOnlyDependencyClasses = DefaultProjectDependencyAnalyzer.buildTestOnlyDependencyClasses(mainDependencyClasses, testDependencyClasses);
            Map<Artifact, Set<DependencyUsage>> usedArtifacts = DefaultProjectDependencyAnalyzer.buildUsedArtifacts(artifactClassMap, dependencyClasses);
            Set<Artifact> mainUsedArtifacts = DefaultProjectDependencyAnalyzer.buildUsedArtifacts(artifactClassMap, mainDependencyClasses).keySet();
            Set<Artifact> testArtifacts = DefaultProjectDependencyAnalyzer.buildUsedArtifacts(artifactClassMap, testOnlyDependencyClasses).keySet();
            Set<Artifact> testOnlyArtifacts = DefaultProjectDependencyAnalyzer.removeAll(testArtifacts, mainUsedArtifacts);
            Set<Artifact> declaredArtifacts = DefaultProjectDependencyAnalyzer.buildDeclaredArtifacts(project);
            LinkedHashSet<Artifact> usedDeclaredArtifacts = new LinkedHashSet<Artifact>(declaredArtifacts);
            usedDeclaredArtifacts.retainAll(usedArtifacts.keySet());
            LinkedHashMap<Artifact, Set<DependencyUsage>> usedDeclaredArtifactsWithClasses = new LinkedHashMap<Artifact, Set<DependencyUsage>>();
            for (Artifact a : usedDeclaredArtifacts) {
                usedDeclaredArtifactsWithClasses.put(a, usedArtifacts.get(a));
            }
            LinkedHashMap<Artifact, Set<DependencyUsage>> usedUndeclaredArtifactsWithClasses = new LinkedHashMap<Artifact, Set<DependencyUsage>>(usedArtifacts);
            Set<Artifact> usedUndeclaredArtifacts = DefaultProjectDependencyAnalyzer.removeAll(usedUndeclaredArtifactsWithClasses.keySet(), declaredArtifacts);
            usedUndeclaredArtifactsWithClasses.keySet().retainAll(usedUndeclaredArtifacts);
            Set<Artifact> unusedDeclaredArtifacts = new LinkedHashSet<Artifact>(declaredArtifacts);
            unusedDeclaredArtifacts = DefaultProjectDependencyAnalyzer.removeAll(unusedDeclaredArtifacts, usedArtifacts.keySet());
            Set<Artifact> testArtifactsWithNonTestScope = DefaultProjectDependencyAnalyzer.getTestArtifactsWithNonTestScope(testOnlyArtifacts);
            return new ProjectDependencyAnalysis(usedDeclaredArtifactsWithClasses, usedUndeclaredArtifactsWithClasses, unusedDeclaredArtifacts, testArtifactsWithNonTestScope);
        }
        catch (IOException exception) {
            throw new ProjectDependencyAnalyzerException("Cannot analyze dependencies", exception);
        }
    }

    private static Set<Artifact> removeAll(Set<Artifact> start, Set<Artifact> remove) {
        LinkedHashSet<Artifact> results = new LinkedHashSet<Artifact>(start.size());
        for (Artifact artifact : start) {
            boolean found = false;
            for (Artifact artifact2 : remove) {
                if (!artifact.getDependencyConflictId().equals(artifact2.getDependencyConflictId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            results.add(artifact);
        }
        return results;
    }

    private static Set<Artifact> getTestArtifactsWithNonTestScope(Set<Artifact> testOnlyArtifacts) {
        LinkedHashSet<Artifact> nonTestScopeArtifacts = new LinkedHashSet<Artifact>();
        for (Artifact artifact : testOnlyArtifacts) {
            if (!artifact.getScope().equals("compile")) continue;
            nonTestScopeArtifacts.add(artifact);
        }
        return nonTestScopeArtifacts;
    }

    protected Map<Artifact, Set<String>> buildArtifactClassMap(MavenProject project, ClassesPatterns excludedClasses) throws IOException {
        LinkedHashMap<Artifact, Set<String>> artifactClassMap = new LinkedHashMap<Artifact, Set<String>>();
        Set dependencyArtifacts = project.getArtifacts();
        for (Artifact artifact : dependencyArtifacts) {
            File file = artifact.getFile();
            if (file != null && file.getName().endsWith(".jar")) {
                JarFile jarFile = new JarFile(file);
                try {
                    Enumeration<JarEntry> jarEntries = jarFile.entries();
                    HashSet<String> classes = new HashSet<String>();
                    while (jarEntries.hasMoreElements()) {
                        String entry = jarEntries.nextElement().getName();
                        if (!entry.endsWith(".class")) continue;
                        String className = entry.replace('/', '.');
                        if (excludedClasses.isMatch(className = className.substring(0, className.length() - ".class".length()))) continue;
                        classes.add(className);
                    }
                    artifactClassMap.put(artifact, classes);
                    continue;
                }
                finally {
                    jarFile.close();
                    continue;
                }
            }
            if (file == null || !file.isDirectory()) continue;
            URL url = file.toURI().toURL();
            Set<String> classes = this.classAnalyzer.analyze(url, excludedClasses);
            artifactClassMap.put(artifact, classes);
        }
        return artifactClassMap;
    }

    private static Set<DependencyUsage> buildTestOnlyDependencyClasses(Set<DependencyUsage> mainDependencyClasses, Set<DependencyUsage> testDependencyClasses) {
        HashSet<DependencyUsage> testOnlyDependencyClasses = new HashSet<DependencyUsage>(testDependencyClasses);
        Set mainDepClassNames = mainDependencyClasses.stream().map(DependencyUsage::getDependencyClass).collect(Collectors.toSet());
        testOnlyDependencyClasses.removeIf(u -> mainDepClassNames.contains(u.getDependencyClass()));
        return testOnlyDependencyClasses;
    }

    private Set<DependencyUsage> buildMainDependencyClasses(MavenProject project, ClassesPatterns excludedClasses) throws IOException {
        String outputDirectory = project.getBuild().getOutputDirectory();
        return this.buildDependencyClasses(outputDirectory, excludedClasses);
    }

    private Set<DependencyUsage> buildTestDependencyClasses(MavenProject project, ClassesPatterns excludedClasses) throws IOException {
        String testOutputDirectory = project.getBuild().getTestOutputDirectory();
        return this.buildDependencyClasses(testOutputDirectory, excludedClasses);
    }

    private Set<DependencyUsage> buildDependencyClasses(String path, ClassesPatterns excludedClasses) throws IOException {
        URL url = new File(path).toURI().toURL();
        return this.dependencyAnalyzer.analyzeUsages(url, excludedClasses);
    }

    private static Set<Artifact> buildDeclaredArtifacts(MavenProject project) {
        Set<Artifact> declaredArtifacts = project.getDependencyArtifacts();
        if (declaredArtifacts == null) {
            declaredArtifacts = Collections.emptySet();
        }
        return declaredArtifacts;
    }

    private static Map<Artifact, Set<DependencyUsage>> buildUsedArtifacts(Map<Artifact, Set<String>> artifactClassMap, Set<DependencyUsage> dependencyClasses) {
        HashMap<Artifact, Set<DependencyUsage>> usedArtifacts = new HashMap<Artifact, Set<DependencyUsage>>();
        for (DependencyUsage classUsage : dependencyClasses) {
            Artifact artifact = DefaultProjectDependencyAnalyzer.findArtifactForClassName(artifactClassMap, classUsage.getDependencyClass());
            if (artifact == null || DefaultProjectDependencyAnalyzer.includedInJDK(artifact)) continue;
            HashSet<DependencyUsage> classesFromArtifact = (HashSet<DependencyUsage>)usedArtifacts.get(artifact);
            if (classesFromArtifact == null) {
                classesFromArtifact = new HashSet<DependencyUsage>();
                usedArtifacts.put(artifact, classesFromArtifact);
            }
            classesFromArtifact.add(classUsage);
        }
        return usedArtifacts;
    }

    private static boolean includedInJDK(Artifact artifact) {
        return "xml-apis".equals(artifact.getGroupId()) ? "xml-apis".equals(artifact.getArtifactId()) : "xerces".equals(artifact.getGroupId()) && "xmlParserAPIs".equals(artifact.getArtifactId());
    }

    private static Artifact findArtifactForClassName(Map<Artifact, Set<String>> artifactClassMap, String className) {
        for (Map.Entry<Artifact, Set<String>> entry : artifactClassMap.entrySet()) {
            if (!entry.getValue().contains(className)) continue;
            return entry.getKey();
        }
        return null;
    }
}

