/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckoutProjectFromScm
extends AbstractReleasePhase {
    private ScmRepositoryConfigurator scmRepositoryConfigurator;

    @Override
    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        CheckOutScmResult scmResult;
        File checkoutDirectory;
        ScmProvider provider;
        ScmRepository repository;
        ReleaseResult result = new ReleaseResult();
        this.logInfo(result, "Checking out the project to perform the release ...");
        if (releaseDescriptor.isLocalCheckout()) {
            String providerPart = releaseDescriptor.getScmSourceUrl().substring(0, releaseDescriptor.getScmSourceUrl().indexOf(58, 4));
            releaseDescriptor.setScmSourceUrl(providerPart + ":file://" + releaseDescriptor.getWorkingDirectory());
            this.getLogger().info("Performing a LOCAL checkout from " + releaseDescriptor.getScmSourceUrl());
        }
        try {
            repository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, releaseEnvironment.getSettings());
            provider = this.scmRepositoryConfigurator.getRepositoryProvider(repository);
        }
        catch (ScmRepositoryException e) {
            result.setResultCode(1);
            this.logError(result, e.getMessage());
            throw new ReleaseScmRepositoryException(e.getMessage(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            result.setResultCode(1);
            this.logError(result, e.getMessage());
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), e);
        }
        MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
        if (StringUtils.isEmpty((String)releaseDescriptor.getCheckoutDirectory())) {
            checkoutDirectory = new File(rootProject.getFile().getParentFile(), "target/checkout");
            releaseDescriptor.setCheckoutDirectory(checkoutDirectory.getAbsolutePath());
        } else {
            checkoutDirectory = new File(releaseDescriptor.getCheckoutDirectory());
        }
        if (checkoutDirectory.exists()) {
            try {
                FileUtils.deleteDirectory((File)checkoutDirectory);
            }
            catch (IOException e) {
                result.setResultCode(1);
                this.logError(result, e.getMessage());
                throw new ReleaseExecutionException("Unable to remove old checkout directory: " + e.getMessage(), e);
            }
        }
        checkoutDirectory.mkdirs();
        try {
            scmResult = provider.checkOut(repository, new ScmFileSet(checkoutDirectory), (ScmVersion)new ScmTag(releaseDescriptor.getScmReleaseLabel()));
        }
        catch (ScmException e) {
            result.setResultCode(1);
            this.logError(result, e.getMessage());
            throw new ReleaseExecutionException("An error is occurred in the checkout process: " + e.getMessage(), e);
        }
        String scmRelativePathProjectDirectory = scmResult.getRelativePathProjectDirectory();
        if (StringUtils.isEmpty((String)scmRelativePathProjectDirectory)) {
            String basedir;
            try {
                basedir = ReleaseUtil.getCommonBasedir(reactorProjects);
            }
            catch (IOException e) {
                throw new ReleaseExecutionException("Exception occurred while calculating common basedir: " + e.getMessage(), e);
            }
            String rootProjectBasedir = rootProject.getBasedir().getAbsolutePath();
            try {
                if (ReleaseUtil.isSymlink(rootProject.getBasedir())) {
                    rootProjectBasedir = rootProject.getBasedir().getCanonicalPath();
                }
            }
            catch (IOException e) {
                throw new ReleaseExecutionException(e.getMessage(), e);
            }
            if (rootProjectBasedir.length() > basedir.length()) {
                scmRelativePathProjectDirectory = rootProjectBasedir.substring(basedir.length() + 1);
            }
        }
        releaseDescriptor.setScmRelativePathProjectDirectory(scmRelativePathProjectDirectory);
        if (!scmResult.isSuccess()) {
            result.setResultCode(1);
            this.logError(result, scmResult.getProviderMessage());
            throw new ReleaseScmCommandException("Unable to checkout from SCM", (ScmResult)scmResult);
        }
        result.setResultCode(0);
        return result;
    }

    @Override
    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.simulate(releaseDescriptor, releaseEnvironment, reactorProjects);
    }
}

