/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.AbstractCompatibilityTransformer;

public class SisuIndexResourceTransformer
extends AbstractCompatibilityTransformer {
    private static final String SISU_INDEX_PATH = "META-INF/sisu/javax.inject.Named";
    private final ArrayList<String> indexEntries = new ArrayList();
    private long time = Long.MIN_VALUE;

    @Override
    public boolean canTransformResource(String resource) {
        return resource.equals(SISU_INDEX_PATH);
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators, long time) throws IOException {
        Scanner scanner = new Scanner(is, StandardCharsets.UTF_8.name());
        while (scanner.hasNextLine()) {
            String relContent = scanner.nextLine();
            for (Relocator relocator : relocators) {
                if (!relocator.canRelocateClass(relContent)) continue;
                relContent = relocator.applyToSourceContent(relContent);
            }
            this.indexEntries.add(relContent);
        }
        if (time > this.time) {
            this.time = time;
        }
    }

    @Override
    public boolean hasTransformedResource() {
        return !this.indexEntries.isEmpty();
    }

    @Override
    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        JarEntry jarEntry = new JarEntry(SISU_INDEX_PATH);
        jarEntry.setTime(this.time);
        jos.putNextEntry(jarEntry);
        IOUtils.writeLines(this.indexEntries, (String)"\n", (OutputStream)jos, (Charset)StandardCharsets.UTF_8);
        jos.flush();
        this.indexEntries.clear();
    }
}

