/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.gpg;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.gpg.AbstractGpgMojo;
import org.apache.maven.plugins.gpg.AbstractGpgSigner;
import org.apache.maven.plugins.gpg.SigningBundle;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.SelectorUtils;

@Mojo(name="sign", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class GpgSignAttachedMojo
extends AbstractGpgMojo {
    private static final String[] DEFAULT_EXCLUDES = new String[]{"**/*.md5", "**/*.sha1", "**/*.sha256", "**/*.sha512", "**/*.asc"};
    @Parameter(property="gpg.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private String[] excludes;
    @Parameter(defaultValue="${project.build.directory}/gpg", alias="outputDirectory")
    private File ascDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        if (this.excludes == null || this.excludes.length == 0) {
            this.excludes = DEFAULT_EXCLUDES;
        }
        String[] newExcludes = new String[this.excludes.length];
        for (int i = 0; i < this.excludes.length; ++i) {
            String pattern = this.excludes[i].trim().replace('/', File.separatorChar).replace('\\', File.separatorChar);
            if (pattern.endsWith(File.separator)) {
                pattern = pattern + "**";
            }
            newExcludes[i] = pattern;
        }
        this.excludes = newExcludes;
        AbstractGpgSigner signer = this.newSigner(this.project);
        signer.setOutputDirectory(this.ascDirectory);
        signer.setBuildDirectory(new File(this.project.getBuild().getDirectory()));
        signer.setBaseDirectory(this.project.getBasedir());
        ArrayList<SigningBundle> signingBundles = new ArrayList<SigningBundle>();
        if (!"pom".equals(this.project.getPackaging())) {
            Artifact artifact = this.project.getArtifact();
            File file = artifact.getFile();
            if (file != null && file.isFile()) {
                this.getLog().debug((CharSequence)("Generating signature for " + file));
                File projectArtifactSignature = signer.generateSignatureForArtifact(file);
                if (projectArtifactSignature != null) {
                    signingBundles.add(new SigningBundle(artifact.getArtifactHandler().getExtension(), projectArtifactSignature));
                }
            } else {
                if (this.project.getAttachedArtifacts().isEmpty()) {
                    throw new MojoFailureException("The project artifact has not been assembled yet. Please do not invoke this goal before the lifecycle phase \"package\".");
                }
                this.getLog().debug((CharSequence)"Main artifact not assembled, skipping signature generation");
            }
        }
        File pomToSign = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".pom");
        try {
            FileUtils.copyFile((File)this.project.getFile(), (File)pomToSign);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying POM for signing.", (Exception)e);
        }
        this.getLog().debug((CharSequence)("Generating signature for " + pomToSign));
        File pomSignature = signer.generateSignatureForArtifact(pomToSign);
        if (pomSignature != null) {
            signingBundles.add(new SigningBundle("pom", pomSignature));
        }
        for (Object o : this.project.getAttachedArtifacts()) {
            Artifact artifact = (Artifact)o;
            File file = artifact.getFile();
            if (this.isExcluded(artifact)) {
                this.getLog().debug((CharSequence)("Skipping generation of signature for excluded " + file));
                continue;
            }
            this.getLog().debug((CharSequence)("Generating signature for " + file));
            File signature = signer.generateSignatureForArtifact(file);
            if (signature == null) continue;
            signingBundles.add(new SigningBundle(artifact.getArtifactHandler().getExtension(), artifact.getClassifier(), signature));
        }
        for (SigningBundle bundle : signingBundles) {
            this.projectHelper.attachArtifact(this.project, bundle.getExtension() + ".asc", bundle.getClassifier(), bundle.getSignature());
        }
    }

    protected boolean isExcluded(Artifact artifact) {
        Path projectBasePath = this.project.getBasedir().toPath();
        Path artifactPath = artifact.getFile().toPath();
        String relativeArtifactPath = projectBasePath.relativize(artifactPath).toString();
        for (String exclude : this.excludes) {
            if (!SelectorUtils.matchPath((String)exclude, (String)relativeArtifactPath)) continue;
            return true;
        }
        return false;
    }
}

