/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.builder.impl;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.MavenTools;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.builder.PomArtifactResolver;
import org.apache.maven.project.builder.PomClassicDomainModel;
import org.apache.maven.project.builder.PomClassicDomainModelFactory;
import org.apache.maven.project.builder.PomClassicTransformer;
import org.apache.maven.project.builder.PomTransformer;
import org.apache.maven.project.builder.ProjectBuilder;
import org.apache.maven.shared.model.DomainModel;
import org.apache.maven.shared.model.InterpolatorProperty;
import org.apache.maven.shared.model.ModelEventListener;
import org.apache.maven.shared.model.ModelTransformer;
import org.apache.maven.shared.model.ModelTransformerContext;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ProjectBuilder.class)
public class DefaultProjectBuilder
implements ProjectBuilder,
LogEnabled {
    @Requirement
    private ArtifactFactory artifactFactory;
    @Requirement
    private MavenTools mavenTools;
    @Requirement
    List<ModelEventListener> listeners;
    private Logger logger;
    private static final String MAVEN_MODEL_VERSION = "4.0.0";
    private MavenXpp3Reader modelReader = new MavenXpp3Reader();
    private Model superModel;

    @Override
    public PomClassicDomainModel buildModel(File pom, Collection<InterpolatorProperty> interpolatorProperties, PomArtifactResolver resolver) throws IOException {
        return this.buildModel(pom, null, interpolatorProperties, resolver);
    }

    public PomClassicDomainModel buildModel(File pom, List<Model> mixins, Collection<InterpolatorProperty> interpolatorProperties, PomArtifactResolver resolver) throws IOException {
        if (pom == null) {
            throw new IllegalArgumentException("pom: null");
        }
        if (resolver == null) {
            throw new IllegalArgumentException("resolver: null");
        }
        if (mixins == null) {
            mixins = new ArrayList<Model>();
            mixins.add(this.getSuperModel());
        } else {
            mixins = new ArrayList<Model>(mixins);
            Collections.reverse(mixins);
        }
        ArrayList<Object> properties = interpolatorProperties == null ? new ArrayList() : new ArrayList<InterpolatorProperty>(interpolatorProperties);
        PomClassicDomainModel domainModel = new PomClassicDomainModel(pom);
        domainModel.setProjectDirectory(pom.getParentFile());
        ArrayList<PomClassicDomainModel> domainModels = new ArrayList<PomClassicDomainModel>();
        domainModels.add(domainModel);
        File parentFile = null;
        int lineageCount = 0;
        if (domainModel.getModel().getParent() != null) {
            List<DomainModel> mavenParents = this.isParentLocal(domainModel.getModel().getParent(), pom.getParentFile()) ? this.getDomainModelParentsFromLocalPath(domainModel, resolver, pom.getParentFile()) : this.getDomainModelParentsFromRepository(domainModel, resolver);
            if (mavenParents.size() > 0) {
                PomClassicDomainModel dm = (PomClassicDomainModel)mavenParents.get(0);
                parentFile = dm.getFile();
                domainModel.setParentFile(parentFile);
                lineageCount = mavenParents.size();
            }
            domainModels.addAll(mavenParents);
        }
        for (Model model : mixins) {
            domainModels.add(new PomClassicDomainModel(model));
        }
        PomClassicTransformer transformer = new PomClassicTransformer(new PomClassicDomainModelFactory());
        ModelTransformerContext ctx = new ModelTransformerContext(PomTransformer.MODEL_CONTAINER_INFOS);
        PomClassicDomainModel transformedDomainModel = (PomClassicDomainModel)ctx.transform(domainModels, (ModelTransformer)transformer, (ModelTransformer)transformer, (Collection)Collections.EMPTY_LIST, properties, this.listeners);
        transformedDomainModel.setLineageCount(lineageCount + 1);
        transformedDomainModel.setParentFile(parentFile);
        return transformedDomainModel;
    }

    @Override
    public MavenProject buildFromLocalPath(File pom, List<Model> mixins, Collection<InterpolatorProperty> interpolatorProperties, PomArtifactResolver resolver, ProjectBuilderConfiguration projectBuilderConfiguration) throws IOException {
        PomClassicDomainModel domainModel = this.buildModel(pom, mixins, interpolatorProperties, resolver);
        try {
            MavenProject mavenProject = new MavenProject(domainModel.getModel(), this.artifactFactory, this.mavenTools, null, projectBuilderConfiguration);
            mavenProject.setParentFile(domainModel.getParentFile());
            return mavenProject;
        }
        catch (InvalidRepositoryException e) {
            throw new IOException(e.getMessage());
        }
    }

    private boolean isParentLocal(Parent parent, File projectDirectory) {
        try {
            File f = new File(projectDirectory, parent.getRelativePath()).getCanonicalFile();
            if (f.isDirectory()) {
                f = new File(f, "pom.xml");
            }
            return f.isFile();
        }
        catch (IOException e) {
            return false;
        }
    }

    private List<DomainModel> getDomainModelParentsFromRepository(PomClassicDomainModel domainModel, PomArtifactResolver artifactResolver) throws IOException {
        ArrayList<DomainModel> domainModels = new ArrayList<DomainModel>();
        Parent parent = domainModel.getModel().getParent();
        if (parent == null) {
            return domainModels;
        }
        Artifact artifactParent = this.artifactFactory.createParentArtifact(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
        artifactResolver.resolve(artifactParent);
        PomClassicDomainModel parentDomainModel = new PomClassicDomainModel(artifactParent.getFile());
        if (!parentDomainModel.matchesParent(domainModel.getModel().getParent())) {
            this.logger.debug("Parent pom ids do not match: Parent File = " + artifactParent.getFile().getAbsolutePath() + ": Child ID = " + domainModel.getModel().getId());
            return domainModels;
        }
        domainModels.add((DomainModel)parentDomainModel);
        domainModels.addAll(this.getDomainModelParentsFromRepository(parentDomainModel, artifactResolver));
        return domainModels;
    }

    private List<DomainModel> getDomainModelParentsFromLocalPath(PomClassicDomainModel domainModel, PomArtifactResolver artifactResolver, File projectDirectory) throws IOException {
        ArrayList<DomainModel> domainModels = new ArrayList<DomainModel>();
        Parent parent = domainModel.getModel().getParent();
        if (parent == null) {
            return domainModels;
        }
        Model model = domainModel.getModel();
        File parentFile = new File(projectDirectory, model.getParent().getRelativePath()).getCanonicalFile();
        if (parentFile.isDirectory()) {
            parentFile = new File(parentFile.getAbsolutePath(), "pom.xml");
        }
        if (!parentFile.isFile()) {
            throw new IOException("File does not exist: File = " + parentFile.getAbsolutePath());
        }
        PomClassicDomainModel parentDomainModel = new PomClassicDomainModel(parentFile);
        parentDomainModel.setProjectDirectory(parentFile.getParentFile());
        if (!parentDomainModel.matchesParent(domainModel.getModel().getParent())) {
            this.logger.debug("Parent pom ids do not match: Parent File = " + parentFile.getAbsolutePath() + ", Parent ID = " + parentDomainModel.getId() + ", Child ID = " + domainModel.getId() + ", Expected Parent ID = " + domainModel.getModel().getParent().getId());
            List<DomainModel> parentDomainModels = this.getDomainModelParentsFromRepository(domainModel, artifactResolver);
            if (parentDomainModels.size() == 0) {
                throw new IOException("Unable to find parent pom on local path or repo: " + domainModel.getModel().getParent().getId());
            }
            domainModels.addAll(parentDomainModels);
            return domainModels;
        }
        domainModels.add((DomainModel)parentDomainModel);
        if (parentDomainModel.getModel().getParent() != null) {
            if (this.isParentLocal(parentDomainModel.getModel().getParent(), parentFile.getParentFile())) {
                domainModels.addAll(this.getDomainModelParentsFromLocalPath(parentDomainModel, artifactResolver, parentFile.getParentFile()));
            } else {
                domainModels.addAll(this.getDomainModelParentsFromRepository(parentDomainModel, artifactResolver));
            }
        }
        return domainModels;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Model getSuperModel() {
        if (this.superModel != null) {
            return this.superModel;
        }
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((URL)this.getClass().getClassLoader().getResource("org/apache/maven/project/pom-4.0.0.xml"));
            this.superModel = this.modelReader.read((Reader)reader, true);
        }
        catch (Exception exception) {
            IOUtil.close(reader);
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return this.superModel;
    }
}

