/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultRepositoryRequest;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.DebugResolutionListener;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.artifact.resolver.WarningResolutionListener;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.repository.DefaultLocalRepositoryMaintainerEvent;
import org.apache.maven.repository.LocalRepositoryMaintainer;
import org.apache.maven.repository.LocalRepositoryMaintainerEvent;
import org.apache.maven.repository.legacy.TransferListenerAdapter;
import org.apache.maven.repository.legacy.WagonManager;
import org.apache.maven.repository.legacy.metadata.DefaultMetadataResolutionRequest;
import org.apache.maven.repository.legacy.metadata.MetadataResolutionRequest;
import org.apache.maven.repository.legacy.resolver.conflict.ConflictResolver;
import org.apache.maven.repository.legacy.resolver.transform.ArtifactTransformationManager;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ArtifactResolver.class)
public class DefaultArtifactResolver
implements ArtifactResolver {
    @Requirement
    private Logger logger;
    @Requirement
    private WagonManager wagonManager;
    @Requirement
    private ArtifactTransformationManager transformationManager;
    @Requirement
    protected ArtifactFactory artifactFactory;
    @Requirement
    private ArtifactCollector artifactCollector;
    @Requirement
    private ResolutionErrorHandler resolutionErrorHandler;
    @Requirement
    private ArtifactMetadataSource source;
    @Requirement
    private PlexusContainer container;
    @Requirement(optional=true)
    private LocalRepositoryMaintainer localRepositoryMaintainer;
    @Requirement
    private LegacySupport legacySupport;
    private final Executor executor;

    public DefaultArtifactResolver() {
        int threads = Integer.getInteger("maven.artifact.threads", 5);
        this.executor = threads <= 1 ? new Executor(){

            public void execute(Runnable command) {
                command.run();
            }
        } : new ThreadPoolExecutor(threads, threads, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    protected void finalize() throws Throwable {
        if (this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdown();
        }
    }

    private void injectSession(RepositoryRequest request) {
        MavenSession session = this.legacySupport.getSession();
        if (session != null) {
            request.setOffline(session.isOffline());
            request.setTransferListener(session.getRequest().getTransferListener());
        }
    }

    private void injectSession(ArtifactResolutionRequest request) {
        MavenSession session = this.legacySupport.getSession();
        if (session != null) {
            request.setOffline(session.isOffline());
            request.setServers(session.getRequest().getServers());
            request.setMirrors(session.getRequest().getMirrors());
            request.setProxies(session.getRequest().getProxies());
            request.setTransferListener(session.getRequest().getTransferListener());
        }
    }

    @Override
    public void resolve(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, TransferListener resolutionListener) throws ArtifactResolutionException, ArtifactNotFoundException {
        DefaultRepositoryRequest request = new DefaultRepositoryRequest();
        this.injectSession((RepositoryRequest)request);
        request.setLocalRepository(localRepository);
        request.setRemoteRepositories(remoteRepositories);
        this.resolve(artifact, (RepositoryRequest)request, resolutionListener, false);
    }

    @Override
    public void resolveAlways(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        DefaultRepositoryRequest request = new DefaultRepositoryRequest();
        this.injectSession((RepositoryRequest)request);
        request.setLocalRepository(localRepository);
        request.setRemoteRepositories(remoteRepositories);
        this.resolve(artifact, (RepositoryRequest)request, null, true);
    }

    private void resolve(Artifact artifact, RepositoryRequest request, TransferListener downloadMonitor, boolean force) throws ArtifactResolutionException, ArtifactNotFoundException {
        if (artifact == null) {
            return;
        }
        if ("system".equals(artifact.getScope())) {
            File systemFile = artifact.getFile();
            if (systemFile == null) {
                throw new ArtifactNotFoundException("System artifact: " + artifact + " has no file attached", artifact);
            }
            if (!systemFile.exists()) {
                throw new ArtifactNotFoundException("System artifact: " + artifact + " not found in path: " + systemFile, artifact);
            }
            if (!systemFile.isFile()) {
                throw new ArtifactNotFoundException("System artifact: " + artifact + " is not a file: " + systemFile, artifact);
            }
            artifact.setResolved(true);
            return;
        }
        ArtifactRepository localRepository = request.getLocalRepository();
        List remoteRepositories = request.getRemoteRepositories();
        if (!artifact.isResolved()) {
            if ((artifact = localRepository.find(artifact)).isResolved()) {
                return;
            }
            this.transformationManager.transformForResolve(artifact, request);
            File destination = artifact.getFile();
            if (!request.isOffline() && (force || !destination.exists() || this.isMutable(artifact))) {
                try {
                    if (artifact.getRepository() != null) {
                        this.wagonManager.getArtifact(artifact, artifact.getRepository(), downloadMonitor, request.isForceUpdate());
                    } else {
                        this.wagonManager.getArtifact(artifact, remoteRepositories, downloadMonitor, request.isForceUpdate());
                    }
                    if (this.localRepositoryMaintainer != null) {
                        DefaultLocalRepositoryMaintainerEvent event = new DefaultLocalRepositoryMaintainerEvent(localRepository, artifact, null);
                        this.localRepositoryMaintainer.artifactDownloaded((LocalRepositoryMaintainerEvent)event);
                    }
                }
                catch (ResourceDoesNotExistException e) {
                    throw new ArtifactNotFoundException(e.getMessage(), artifact, remoteRepositories, (Throwable)e);
                }
                catch (TransferFailedException e) {
                    throw new ArtifactResolutionException(e.getMessage(), artifact, remoteRepositories, (Throwable)e);
                }
            }
            if (!destination.exists()) {
                if (request.isOffline()) {
                    throw new ArtifactResolutionException("The repository system is offline and the requested artifact is not locally available at " + destination, artifact, remoteRepositories);
                }
                throw new ArtifactResolutionException("Failed to resolve artifact, possibly due to a repository list that is not appropriately equipped for this artifact's metadata.", artifact, remoteRepositories);
            }
            artifact.setResolved(true);
            if (artifact.isSnapshot() && this.isTimestamped(artifact)) {
                String version = artifact.getVersion();
                artifact.selectVersion(artifact.getBaseVersion());
                File copy = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
                if (!copy.exists() || copy.lastModified() != destination.lastModified() || copy.length() != destination.length()) {
                    try {
                        FileUtils.copyFile((File)destination, (File)copy);
                        copy.setLastModified(destination.lastModified());
                    }
                    catch (IOException e) {
                        throw new ArtifactResolutionException("Unable to copy resolved artifact for local use: " + e.getMessage(), artifact, remoteRepositories, (Throwable)e);
                    }
                }
                artifact.setFile(copy);
                artifact.selectVersion(version);
            }
        }
    }

    private boolean isMutable(Artifact artifact) {
        return artifact.isSnapshot() && !this.isTimestamped(artifact) && !this.isLocalCopy(artifact);
    }

    private boolean isTimestamped(Artifact artifact) {
        return !artifact.getBaseVersion().equals(artifact.getVersion());
    }

    private boolean isLocalCopy(Artifact artifact) {
        boolean localCopy = false;
        for (ArtifactMetadata m : artifact.getMetadataList()) {
            Snapshot snapshot;
            Versioning versioning;
            SnapshotArtifactRepositoryMetadata snapshotMetadata;
            Metadata metadata;
            if (!(m instanceof SnapshotArtifactRepositoryMetadata) || (metadata = (snapshotMetadata = (SnapshotArtifactRepositoryMetadata)m).getMetadata()) == null || (versioning = metadata.getVersioning()) == null || (snapshot = versioning.getSnapshot()) == null) continue;
            localCopy = snapshot.isLocalCopy();
        }
        return localCopy;
    }

    @Override
    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, Collections.EMPTY_MAP, localRepository, remoteRepositories, source, filter);
    }

    @Override
    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, null);
    }

    @Override
    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, filter, null);
    }

    @Override
    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource source) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, localRepository, remoteRepositories, source, null);
    }

    @Override
    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource source, List<ResolutionListener> listeners) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, Collections.EMPTY_MAP, localRepository, remoteRepositories, source, null, listeners);
    }

    @Override
    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List<ResolutionListener> listeners) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, filter, listeners, null);
    }

    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List<ResolutionListener> listeners, List<ConflictResolver> conflictResolvers) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(originatingArtifact).setResolveRoot(false).setArtifactDependencies(artifacts).setManagedVersionMap(managedVersions).setLocalRepository(localRepository).setRemoteRepositories(remoteRepositories).setCollectionFilter(filter).setListeners(listeners);
        this.injectSession(request);
        return this.resolveWithExceptions(request);
    }

    public ArtifactResolutionResult resolveWithExceptions(ArtifactResolutionRequest request) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArtifactResolutionResult result = this.resolve(request);
        this.resolutionErrorHandler.throwErrors(request, result);
        return result;
    }

    @Override
    public ArtifactResolutionResult resolve(ArtifactResolutionRequest request) {
        Artifact rootArtifact = request.getArtifact();
        LinkedHashSet artifacts = request.getArtifactDependencies();
        Map managedVersions = request.getManagedVersionMap();
        ArrayList<ResolutionListener> listeners = request.getListeners();
        ArtifactFilter collectionFilter = request.getCollectionFilter();
        ArtifactFilter resolutionFilter = request.getResolutionFilter();
        TransferListener transferListener = TransferListenerAdapter.newAdapter(request.getTransferListener());
        if (this.source == null) {
            try {
                this.source = (ArtifactMetadataSource)this.container.lookup(ArtifactMetadataSource.class);
            }
            catch (ComponentLookupException e) {
                // empty catch block
            }
        }
        if (listeners == null) {
            listeners = new ArrayList<ResolutionListener>();
            if (this.logger.isDebugEnabled()) {
                listeners.add(new DebugResolutionListener(this.logger));
            }
            listeners.add(new WarningResolutionListener(this.logger));
        }
        ArtifactResolutionResult result = new ArtifactResolutionResult();
        if (request.isResolveRoot()) {
            try {
                this.resolve(rootArtifact, (RepositoryRequest)request, transferListener, false);
            }
            catch (ArtifactResolutionException e) {
                result.addErrorArtifactException(e);
                return result;
            }
            catch (ArtifactNotFoundException e) {
                result.addMissingArtifact(request.getArtifact());
                return result;
            }
        }
        ArtifactResolutionRequest collectionRequest = request;
        if (request.isResolveTransitively()) {
            DefaultMetadataResolutionRequest metadataRequest = new DefaultMetadataResolutionRequest(request);
            metadataRequest.setArtifact(rootArtifact);
            metadataRequest.setResolveManagedVersions(managedVersions == null);
            try {
                ResolutionGroup resolutionGroup = this.source.retrieve((MetadataResolutionRequest)metadataRequest);
                if (managedVersions == null) {
                    managedVersions = resolutionGroup.getManagedVersions();
                }
                Set directArtifacts = resolutionGroup.getArtifacts();
                if (artifacts == null || artifacts.isEmpty()) {
                    artifacts = directArtifacts;
                } else {
                    ArrayList allArtifacts = new ArrayList();
                    allArtifacts.addAll(artifacts);
                    allArtifacts.addAll(directArtifacts);
                    LinkedHashMap<String, Artifact> mergedArtifacts = new LinkedHashMap<String, Artifact>();
                    for (Artifact artifact : allArtifacts) {
                        String conflictId = artifact.getDependencyConflictId();
                        if (mergedArtifacts.containsKey(conflictId)) continue;
                        mergedArtifacts.put(conflictId, artifact);
                    }
                    artifacts = new LinkedHashSet(mergedArtifacts.values());
                }
                collectionRequest = new ArtifactResolutionRequest((RepositoryRequest)request);
                collectionRequest.setServers(request.getServers());
                collectionRequest.setMirrors(request.getMirrors());
                collectionRequest.setProxies(request.getProxies());
                collectionRequest.setRemoteRepositories(resolutionGroup.getResolutionRepositories());
            }
            catch (ArtifactMetadataRetrievalException e) {
                ArtifactResolutionException are = new ArtifactResolutionException("Unable to get dependency information for " + rootArtifact.getId() + ": " + e.getMessage(), rootArtifact, metadataRequest.getRemoteRepositories(), (Throwable)e);
                result.addMetadataResolutionException(are);
                return result;
            }
        }
        if (artifacts == null || artifacts.isEmpty()) {
            if (request.isResolveRoot()) {
                result.addArtifact(rootArtifact);
            }
            return result;
        }
        result = this.artifactCollector.collect((Set<Artifact>)artifacts, rootArtifact, managedVersions, collectionRequest, this.source, collectionFilter, listeners, null);
        if (result.hasMetadataResolutionExceptions() || result.hasVersionRangeViolations() || result.hasCircularDependencyExceptions()) {
            return result;
        }
        if (result.getArtifactResolutionNodes() != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            CountDownLatch latch = new CountDownLatch(result.getArtifactResolutionNodes().size());
            for (ResolutionNode node : result.getArtifactResolutionNodes()) {
                Artifact artifact = node.getArtifact();
                if (resolutionFilter == null || resolutionFilter.include(artifact)) {
                    ArtifactResolutionRequest childRequest = new ArtifactResolutionRequest((RepositoryRequest)request);
                    childRequest.setRemoteRepositories(node.getRemoteRepositories());
                    this.executor.execute(new ResolveTask(classLoader, latch, artifact, transferListener, childRequest, result));
                    continue;
                }
                latch.countDown();
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                result.addErrorArtifactException(new ArtifactResolutionException("Resolution interrupted", rootArtifact, (Throwable)e));
            }
        }
        if (request.isResolveRoot()) {
            LinkedHashSet<Artifact> allArtifacts = new LinkedHashSet<Artifact>();
            allArtifacts.add(rootArtifact);
            allArtifacts.addAll(result.getArtifacts());
            result.setArtifacts(allArtifacts);
        }
        return result;
    }

    @Override
    public void resolve(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        this.resolve(artifact, remoteRepositories, localRepository, null);
    }

    private class ResolveTask
    implements Runnable {
        private final ClassLoader classLoader;
        private final CountDownLatch latch;
        private final Artifact artifact;
        private final TransferListener transferListener;
        private final ArtifactResolutionRequest request;
        private final ArtifactResolutionResult result;

        public ResolveTask(ClassLoader classLoader, CountDownLatch latch, Artifact artifact, TransferListener transferListener, ArtifactResolutionRequest request, ArtifactResolutionResult result) {
            this.classLoader = classLoader;
            this.latch = latch;
            this.artifact = artifact;
            this.transferListener = transferListener;
            this.request = request;
            this.result = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                DefaultArtifactResolver.this.resolve(this.artifact, (RepositoryRequest)this.request, this.transferListener, false);
            }
            catch (ArtifactNotFoundException anfe) {
                ArtifactResolutionResult artifactResolutionResult = this.result;
                synchronized (artifactResolutionResult) {
                    this.result.addMissingArtifact(this.artifact);
                }
            }
            catch (ArtifactResolutionException e) {
                ArtifactResolutionResult artifactResolutionResult = this.result;
                synchronized (artifactResolutionResult) {
                    this.result.addErrorArtifactException(e);
                }
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

