package org.apache.maven.repository;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


/**
 *
 *
 * @author Oleg Gusakov
 * @version $Id: MavenArtifactMetadata.java 789541 2009-06-30 03:04:34Z jvanzyl $
 *
 */
public class MavenArtifactMetadata
{
    public static final String DEFAULT_TYPE = "jar";

    String groupId;
    String artifactId;
    String version;
    String classifier;
    String type;
    String scope;
    
    transient Object datum;

    public String getGroupId()
    {
        return groupId;
    }

    public void setGroupId( String groupId )
    {
        this.groupId = groupId;
    }

    public String getArtifactId()
    {
        return artifactId;
    }

    public void setArtifactId( String artifactId )
    {
        this.artifactId = artifactId;
    }

    public String getVersion()
    {
        return version;
    }

    public void setVersion( String version )
    {
        this.version = version;
    }

    public String getClassifier()
    {
        return classifier;
    }

    public void setClassifier( String classifier )
    {
        this.classifier = classifier;
    }

    public String getType()
    {
        return type;
    }

    public void setType( String type )
    {
        this.type = type;
    }

    public Object getDatum()
    {
        return datum;
    }

    public void setDatum( Object datum )
    {
        this.datum = datum;
    }

    public String getScope()
    {
        return scope;
    }

    public void setScope( String scope )
    {
        this.scope = scope;
    }
    
    @Override
    public String toString()
    {
        return getGroupId()+":"+getArtifactId()+":"+getVersion()
                +":" + (getClassifier() == null ? "" : getClassifier() )
                +":" + (getType() == null ? DEFAULT_TYPE : getType() )
        ;
    }
    
}
