/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.siterenderer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.Doxia;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.parser.manager.ParserNotFoundException;
import org.apache.maven.doxia.parser.module.ParserModule;
import org.apache.maven.doxia.parser.module.ParserModuleManager;
import org.apache.maven.doxia.parser.module.ParserModuleNotFoundException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.skin.SkinModel;
import org.apache.maven.doxia.site.skin.io.xpp3.SkinXpp3Reader;
import org.apache.maven.doxia.siterenderer.DocumentContent;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.DoxiaDocumentRenderer;
import org.apache.maven.doxia.siterenderer.ExtraDoxiaModuleReference;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.RenderingContext;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.doxia.util.XmlValidator;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.tools.ToolManager;
import org.apache.velocity.tools.config.ConfigurationUtils;
import org.apache.velocity.tools.config.EasyFactoryConfiguration;
import org.apache.velocity.tools.config.FactoryConfiguration;
import org.apache.velocity.tools.generic.AlternatorTool;
import org.apache.velocity.tools.generic.ClassTool;
import org.apache.velocity.tools.generic.ComparisonDateTool;
import org.apache.velocity.tools.generic.ContextTool;
import org.apache.velocity.tools.generic.ConversionTool;
import org.apache.velocity.tools.generic.DisplayTool;
import org.apache.velocity.tools.generic.EscapeTool;
import org.apache.velocity.tools.generic.FieldTool;
import org.apache.velocity.tools.generic.LinkTool;
import org.apache.velocity.tools.generic.LoopTool;
import org.apache.velocity.tools.generic.MathTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.apache.velocity.tools.generic.RenderTool;
import org.apache.velocity.tools.generic.ResourceTool;
import org.apache.velocity.tools.generic.SortTool;
import org.apache.velocity.tools.generic.XmlTool;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultSiteRenderer
implements Renderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSiteRenderer.class);
    @Inject
    private VelocityComponent velocity;
    @Inject
    private ParserModuleManager parserModuleManager;
    @Inject
    private Doxia doxia;
    @Inject
    private PlexusContainer plexus;
    private static final String SKIN_TEMPLATE_LOCATION = "META-INF/maven/site.vm";
    private static final String TOOLS_LOCATION = "META-INF/maven/site-tools.xml";
    private static final String DOXIA_SITE_RENDERER_VERSION = DefaultSiteRenderer.getSiteRendererVersion();

    public Map<String, DocumentRenderer> locateDocumentFiles(SiteRenderingContext siteRenderingContext) throws IOException, RendererException {
        return this.locateDocumentFiles(siteRenderingContext, false);
    }

    @Override
    public Map<String, DocumentRenderer> locateDocumentFiles(SiteRenderingContext siteRenderingContext, boolean editable) throws IOException, RendererException {
        LinkedHashMap<String, DocumentRenderer> files = new LinkedHashMap<String, DocumentRenderer>();
        Map<String, String> moduleExcludes = siteRenderingContext.getModuleExcludes();
        for (File siteDirectory : siteRenderingContext.getSiteDirectories()) {
            if (!siteDirectory.exists()) continue;
            Collection modules = this.parserModuleManager.getParserModules();
            for (ParserModule module : modules) {
                File moduleBasedir = new File(siteDirectory, module.getSourceDirectory());
                String excludes = moduleExcludes == null ? null : moduleExcludes.get(module.getParserId());
                this.addModuleFiles(siteRenderingContext.getRootDirectory(), moduleBasedir, module, excludes, files, editable);
            }
        }
        for (ExtraDoxiaModuleReference module : siteRenderingContext.getModules()) {
            try {
                ParserModule parserModule = this.parserModuleManager.getParserModule(module.getParserId());
                String excludes = moduleExcludes == null ? null : moduleExcludes.get(module.getParserId());
                this.addModuleFiles(siteRenderingContext.getRootDirectory(), module.getBasedir(), parserModule, excludes, files, editable);
            }
            catch (ParserModuleNotFoundException e) {
                throw new RendererException("Unable to find module", e);
            }
        }
        return files;
    }

    private List<String> filterExtensionIgnoreCase(List<String> fileNames, String extension) {
        LinkedList<String> filtered = new LinkedList<String>(fileNames);
        Iterator it = filtered.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (DefaultSiteRenderer.endsWithIgnoreCase(name, extension)) continue;
            it.remove();
        }
        return filtered;
    }

    private void addModuleFiles(File rootDir, File moduleBasedir, ParserModule module, String excludes, Map<String, DocumentRenderer> files, boolean editable) throws IOException, RendererException {
        if (!moduleBasedir.exists() || ArrayUtils.isEmpty((Object[])module.getExtensions())) {
            return;
        }
        String moduleRelativePath = PathTool.getRelativeFilePath((String)rootDir.getAbsolutePath(), (String)moduleBasedir.getAbsolutePath());
        List allFiles = FileUtils.getFileNames((File)moduleBasedir, (String)"**/*.*", (String)excludes, (boolean)false);
        for (String extension : module.getExtensions()) {
            String fullExtension = "." + extension;
            List<String> docs = this.filterExtensionIgnoreCase(allFiles, fullExtension);
            List<String> velocityFiles = this.filterExtensionIgnoreCase(allFiles, fullExtension + ".vm");
            docs.addAll(velocityFiles);
            for (String doc : docs) {
                RenderingContext context = new RenderingContext(moduleBasedir, moduleRelativePath, doc, module.getParserId(), extension, editable);
                if (DefaultSiteRenderer.endsWithIgnoreCase(doc, ".vm")) {
                    context.setAttribute("velocity", "true");
                }
                String key = context.getOutputName();
                if (files.containsKey(key = StringUtils.replace((String)key, (String)"\\", (String)"/"))) {
                    DocumentRenderer renderer = files.get(key);
                    RenderingContext originalContext = renderer.getRenderingContext();
                    File originalDoc = new File(originalContext.getBasedir(), originalContext.getInputName());
                    throw new RendererException("File '" + module.getSourceDirectory() + File.separator + doc + "' clashes with existing '" + originalDoc + "'.");
                }
                for (Map.Entry<String, DocumentRenderer> entry : files.entrySet()) {
                    if (!entry.getKey().equalsIgnoreCase(key)) continue;
                    RenderingContext originalContext = entry.getValue().getRenderingContext();
                    File originalDoc = new File(originalContext.getBasedir(), originalContext.getInputName());
                    if (Os.isFamily((String)"windows")) {
                        throw new RendererException("File '" + module.getSourceDirectory() + File.separator + doc + "' clashes with existing '" + originalDoc + "'.");
                    }
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.warn("File '" + module.getSourceDirectory() + File.separator + doc + "' could clash with existing '" + originalDoc + "'.");
                }
                files.put(key, new DoxiaDocumentRenderer(context));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Collection<DocumentRenderer> documents, SiteRenderingContext siteRenderingContext, File outputDirectory) throws RendererException, IOException {
        for (DocumentRenderer docRenderer : documents) {
            boolean modified;
            RenderingContext renderingContext = docRenderer.getRenderingContext();
            File outputFile = new File(outputDirectory, docRenderer.getOutputName());
            File inputFile = new File(renderingContext.getBasedir(), renderingContext.getInputName());
            boolean bl = modified = !outputFile.exists() || inputFile.lastModified() > outputFile.lastModified() || siteRenderingContext.getDecoration().getLastModified() > outputFile.lastModified();
            if (modified || docRenderer.isOverwrite()) {
                if (!outputFile.getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Generating " + outputFile);
                }
                Writer writer = null;
                try {
                    if (!docRenderer.isExternalReport()) {
                        writer = WriterFactory.newWriter((File)outputFile, (String)siteRenderingContext.getOutputEncoding());
                    }
                    docRenderer.renderDocument(writer, this, siteRenderingContext);
                }
                catch (Throwable throwable) {
                    IOUtil.close(writer);
                    throw throwable;
                }
                IOUtil.close((Writer)writer);
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug(inputFile + " unchanged, not regenerating...");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void renderDocument(Writer writer, RenderingContext docRenderingContext, SiteRenderingContext siteContext) throws RendererException, FileNotFoundException, UnsupportedEncodingException {
        SiteRendererSink sink = new SiteRendererSink(docRenderingContext);
        File doc = new File(docRenderingContext.getBasedir(), docRenderingContext.getInputName());
        Object reader = null;
        try {
            String resource = doc.getAbsolutePath();
            Parser parser = this.doxia.getParser(docRenderingContext.getParserId());
            parser.setEmitComments(false);
            if (docRenderingContext.getAttribute("velocity") != null) {
                LOGGER.debug("Processing Velocity for " + docRenderingContext.getDoxiaSourcePath());
                try {
                    Context vc = this.createDocumentVelocityContext(docRenderingContext, siteContext);
                    StringWriter sw = new StringWriter();
                    this.velocity.getEngine().mergeTemplate(resource, siteContext.getInputEncoding(), vc, (Writer)sw);
                    String doxiaContent = sw.toString();
                    if (siteContext.getProcessedContentOutput() != null) {
                        this.saveVelocityProcessedContent(docRenderingContext, siteContext, doxiaContent);
                    }
                    reader = new StringReader(doxiaContent);
                }
                catch (VelocityException e) {
                    throw new RendererException("Error parsing " + docRenderingContext.getDoxiaSourcePath() + " as a Velocity template", e);
                }
                if (parser.getType() == 2 && siteContext.isValidate()) {
                    reader = this.validate((Reader)reader, resource);
                }
            } else {
                switch (parser.getType()) {
                    case 2: {
                        reader = ReaderFactory.newXmlReader((File)doc);
                        if (!siteContext.isValidate()) break;
                        reader = this.validate((Reader)reader, resource);
                        break;
                    }
                    default: {
                        reader = ReaderFactory.newReader((File)doc, (String)siteContext.getInputEncoding());
                    }
                }
            }
            this.doxia.parse((Reader)reader, docRenderingContext.getParserId(), (Sink)sink, docRenderingContext.getInputName());
        }
        catch (ParserNotFoundException e) {
            try {
                throw new RendererException("Error getting a parser for '" + doc + "'", e);
                catch (ParseException e2) {
                    StringBuilder errorMsgBuilder = new StringBuilder();
                    errorMsgBuilder.append("Error parsing '").append(doc).append("'");
                    if (e2.getLineNumber() > 0) {
                        errorMsgBuilder.append(", line ").append(e2.getLineNumber());
                    }
                    throw new RendererException(errorMsgBuilder.toString(), e2);
                }
                catch (IOException e3) {
                    throw new RendererException("Error while processing '" + doc + "'", e3);
                }
            }
            catch (Throwable throwable) {
                sink.flush();
                sink.close();
                IOUtil.close(reader);
                throw throwable;
            }
        }
        sink.flush();
        sink.close();
        IOUtil.close((Reader)reader);
        this.mergeDocumentIntoSite(writer, sink, siteContext);
    }

    private void saveVelocityProcessedContent(RenderingContext docRenderingContext, SiteRenderingContext siteContext, String doxiaContent) throws IOException {
        if (!siteContext.getProcessedContentOutput().exists()) {
            siteContext.getProcessedContentOutput().mkdirs();
        }
        String input = docRenderingContext.getInputName();
        File outputFile = new File(siteContext.getProcessedContentOutput(), input.substring(0, input.length() - 3));
        File outputParent = outputFile.getParentFile();
        if (!outputParent.exists()) {
            outputParent.mkdirs();
        }
        FileUtils.fileWrite((File)outputFile, (String)siteContext.getInputEncoding(), (String)doxiaContent);
    }

    protected Context createToolManagedVelocityContext(SiteRenderingContext siteRenderingContext) {
        Locale locale = siteRenderingContext.getLocale();
        String dateFormat = siteRenderingContext.getDecoration().getPublishDate().getFormat();
        EasyFactoryConfiguration config = new EasyFactoryConfiguration(false);
        config.property("safeMode", (Object)Boolean.FALSE);
        config.toolbox("request").tool(ContextTool.class).tool(LinkTool.class).tool(LoopTool.class).tool(RenderTool.class);
        config.toolbox("application").property("locale", (Object)locale).tool(AlternatorTool.class).tool(ClassTool.class).tool(ComparisonDateTool.class).property("format", (Object)dateFormat).tool(ConversionTool.class).property("dateFormat", (Object)dateFormat).tool(DisplayTool.class).tool(EscapeTool.class).tool(FieldTool.class).tool(MathTool.class).tool(NumberTool.class).tool(ResourceTool.class).property("bundles", (Object)new String[]{"site-renderer"}).tool(SortTool.class).tool(XmlTool.class);
        FactoryConfiguration customConfig = ConfigurationUtils.findInClasspath((String)TOOLS_LOCATION);
        if (customConfig != null) {
            config.addConfiguration(customConfig);
        }
        ToolManager manager = new ToolManager(false, false);
        manager.configure((FactoryConfiguration)config);
        return manager.createContext();
    }

    protected Context createDocumentVelocityContext(RenderingContext renderingContext, SiteRenderingContext siteRenderingContext) {
        Map<String, ?> templateProperties;
        Context context = this.createToolManagedVelocityContext(siteRenderingContext);
        context.put("relativePath", (Object)renderingContext.getRelativePath());
        String currentFileName = renderingContext.getOutputName().replace('\\', '/');
        context.put("currentFileName", (Object)currentFileName);
        context.put("alignedFileName", (Object)PathTool.calculateLink((String)currentFileName, (String)renderingContext.getRelativePath()));
        context.put("decoration", (Object)siteRenderingContext.getDecoration());
        Locale locale = siteRenderingContext.getLocale();
        context.put("locale", (Object)locale);
        context.put("supportedLocales", Collections.unmodifiableList(siteRenderingContext.getSiteLocales()));
        context.put("publishDate", (Object)siteRenderingContext.getPublishDate());
        if (DOXIA_SITE_RENDERER_VERSION != null) {
            context.put("doxiaSiteRendererVersion", (Object)DOXIA_SITE_RENDERER_VERSION);
        }
        if ((templateProperties = siteRenderingContext.getTemplateProperties()) != null) {
            for (Map.Entry<String, ?> entry : templateProperties.entrySet()) {
                context.put(entry.getKey(), entry.getValue());
            }
        }
        context.put("PathTool", (Object)new PathTool());
        context.put("StringUtils", (Object)new StringUtils());
        context.put("plexus", (Object)this.plexus);
        return context;
    }

    protected Context createSiteTemplateVelocityContext(DocumentContent content, SiteRenderingContext siteRenderingContext) {
        Context context = this.createDocumentVelocityContext(content.getRenderingContext(), siteRenderingContext);
        context.put("authors", content.getAuthors());
        context.put("shortTitle", (Object)content.getTitle());
        StringBuilder title = new StringBuilder();
        if (siteRenderingContext.getDecoration() != null && siteRenderingContext.getDecoration().getName() != null) {
            title.append(siteRenderingContext.getDecoration().getName());
        } else if (siteRenderingContext.getDefaultWindowTitle() != null) {
            title.append(siteRenderingContext.getDefaultWindowTitle());
        }
        if (title.length() > 0 && StringUtils.isNotEmpty((String)content.getTitle())) {
            title.append(" &#x2013; ");
        }
        if (StringUtils.isNotEmpty((String)content.getTitle())) {
            title.append(content.getTitle());
        }
        context.put("title", (Object)(title.length() > 0 ? title.toString() : null));
        context.put("headContent", (Object)content.getHead());
        context.put("bodyContent", (Object)content.getBody());
        context.put("documentDate", (Object)content.getDate());
        context.put("docRenderingContext", (Object)content.getRenderingContext());
        return context;
    }

    public void generateDocument(Writer writer, SiteRendererSink sink, SiteRenderingContext siteRenderingContext) throws RendererException {
        this.mergeDocumentIntoSite(writer, sink, siteRenderingContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeDocumentIntoSite(Writer writer, DocumentContent content, SiteRenderingContext siteRenderingContext) throws RendererException {
        String templateName = siteRenderingContext.getTemplateName();
        LOGGER.debug("Processing Velocity for template " + templateName + " on " + content.getRenderingContext().getInputName());
        Context context = this.createSiteTemplateVelocityContext(content, siteRenderingContext);
        ClassLoader old = null;
        if (siteRenderingContext.getTemplateClassLoader() != null) {
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(siteRenderingContext.getTemplateClassLoader());
        }
        try {
            Template template;
            Artifact skin = siteRenderingContext.getSkin();
            try {
                SkinModel skinModel = siteRenderingContext.getSkinModel();
                String encoding = skinModel == null ? null : skinModel.getEncoding();
                template = encoding == null ? this.velocity.getEngine().getTemplate(templateName) : this.velocity.getEngine().getTemplate(templateName, encoding);
            }
            catch (ParseErrorException pee) {
                throw new RendererException("Velocity parsing error while reading the site decoration template from " + skin.getId() + " skin", pee);
            }
            catch (ResourceNotFoundException rnfe) {
                throw new RendererException("Could not find the site decoration template from " + skin.getId() + " skin", rnfe);
            }
            try {
                StringWriter sw = new StringWriter();
                template.merge(context, (Writer)sw);
                writer.write(sw.toString().replaceAll("\r?\n", SystemUtils.LINE_SEPARATOR));
            }
            catch (VelocityException ve) {
                throw new RendererException("Velocity error while merging site decoration template.", ve);
            }
            catch (IOException ioe) {
                throw new RendererException("IO exception while merging site decoration template.", ioe);
            }
        }
        finally {
            IOUtil.close((Writer)writer);
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    private SiteRenderingContext createSiteRenderingContext(Map<String, ?> attributes, DecorationModel decoration, String defaultWindowTitle, Locale locale) {
        SiteRenderingContext context = new SiteRenderingContext();
        context.setTemplateProperties(attributes);
        context.setLocale(locale);
        context.setDecoration(decoration);
        context.setDefaultWindowTitle(defaultWindowTitle);
        return context;
    }

    @Override
    public SiteRenderingContext createContextForSkin(Artifact skin, Map<String, ?> attributes, DecorationModel decoration, String defaultWindowTitle, Locale locale) throws IOException, RendererException {
        SiteRenderingContext context = this.createSiteRenderingContext(attributes, decoration, defaultWindowTitle, locale);
        context.setSkin(skin);
        ZipFile zipFile = DefaultSiteRenderer.getZipFile(skin.getFile());
        InputStream in = null;
        try {
            if (zipFile.getEntry(SKIN_TEMPLATE_LOCATION) == null) {
                throw new RendererException("Skin does not contain template at META-INF/maven/site.vm");
            }
            context.setTemplateName(SKIN_TEMPLATE_LOCATION);
            context.setTemplateClassLoader(new URLClassLoader(new URL[]{skin.getFile().toURI().toURL()}));
            ZipEntry skinDescriptorEntry = zipFile.getEntry("META-INF/maven/skin.xml");
            if (skinDescriptorEntry != null) {
                String current;
                in = zipFile.getInputStream(skinDescriptorEntry);
                SkinModel skinModel = new SkinXpp3Reader().read(in);
                context.setSkinModel(skinModel);
                String toolsPrerequisite = skinModel.getPrerequisites() == null ? null : skinModel.getPrerequisites().getDoxiaSitetools();
                Package p = DefaultSiteRenderer.class.getPackage();
                String string = current = p == null ? null : p.getImplementationVersion();
                if (StringUtils.isNotBlank((String)toolsPrerequisite) && current != null && !this.matchVersion(current, toolsPrerequisite)) {
                    throw new RendererException("Cannot use skin: has " + toolsPrerequisite + " Doxia Sitetools prerequisite, but current is " + current);
                }
            }
        }
        catch (XmlPullParserException e) {
            throw new RendererException("Failed to parse META-INF/maven/skin.xml skin descriptor from " + skin.getId() + " skin", e);
        }
        finally {
            IOUtil.close(in);
            DefaultSiteRenderer.closeZipFile(zipFile);
        }
        return context;
    }

    boolean matchVersion(String current, String prerequisite) throws RendererException {
        try {
            DefaultArtifactVersion v = new DefaultArtifactVersion(current);
            VersionRange vr = VersionRange.createFromVersionSpec((String)prerequisite);
            boolean matched = false;
            ArtifactVersion recommendedVersion = vr.getRecommendedVersion();
            if (recommendedVersion == null) {
                List restrictions = vr.getRestrictions();
                for (Restriction restriction : restrictions) {
                    if (!restriction.containsVersion((ArtifactVersion)v)) continue;
                    matched = true;
                    break;
                }
            } else {
                int compareTo = recommendedVersion.compareTo((Object)v);
                boolean bl = matched = compareTo <= 0;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Skin doxia-sitetools prerequisite: " + prerequisite + ", current: " + current + ", matched = " + matched);
            }
            return matched;
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RendererException("Invalid skin doxia-sitetools prerequisite: " + prerequisite, e);
        }
    }

    public void copyResources(SiteRenderingContext siteRenderingContext, File resourcesDirectory, File outputDirectory) throws IOException {
        throw new AssertionError((Object)"copyResources( SiteRenderingContext, File, File ) is deprecated.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyResources(SiteRenderingContext siteRenderingContext, File outputDirectory) throws IOException {
        ZipFile file = DefaultSiteRenderer.getZipFile(siteRenderingContext.getSkin().getFile());
        try {
            Enumeration<? extends ZipEntry> e = file.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (entry.getName().startsWith("META-INF/")) continue;
                File destFile = new File(outputDirectory, entry.getName());
                if (!entry.isDirectory()) {
                    if (destFile.exists()) continue;
                    destFile.getParentFile().mkdirs();
                    DefaultSiteRenderer.copyFileFromZip(file, entry, destFile);
                    continue;
                }
                destFile.mkdirs();
            }
        }
        finally {
            DefaultSiteRenderer.closeZipFile(file);
        }
        for (File siteDirectory : siteRenderingContext.getSiteDirectories()) {
            File resourcesDirectory = new File(siteDirectory, "resources");
            if (resourcesDirectory == null || !resourcesDirectory.exists()) continue;
            this.copyDirectory(resourcesDirectory, outputDirectory);
        }
        File siteCssFile = new File(outputDirectory, "/css/site.css");
        if (!siteCssFile.exists()) {
            File cssDirectory = new File(outputDirectory, "/css/");
            boolean created = cssDirectory.mkdirs();
            if (created && LOGGER.isDebugEnabled()) {
                LOGGER.debug("The directory '" + cssDirectory.getAbsolutePath() + "' did not exist. It was created.");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The file '" + siteCssFile.getAbsolutePath() + "' does not exist. Creating an empty file.");
            }
            Writer writer = null;
            try {
                writer = WriterFactory.newWriter((File)siteCssFile, (String)siteRenderingContext.getOutputEncoding());
                writer.write("/* You can override this file with your own styles */");
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
            IOUtil.close((Writer)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileFromZip(ZipFile file, ZipEntry entry, File destFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(destFile);
        try {
            IOUtil.copy((InputStream)file.getInputStream(entry), (OutputStream)fos);
        }
        finally {
            IOUtil.close((OutputStream)fos);
        }
    }

    protected void copyDirectory(File source, File destination) throws IOException {
        if (source.exists()) {
            DirectoryScanner scanner = new DirectoryScanner();
            String[] includedResources = new String[]{"**/**"};
            scanner.setIncludes(includedResources);
            scanner.addDefaultExcludes();
            scanner.setBasedir(source);
            scanner.scan();
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            for (String name : includedFiles) {
                File sourceFile = new File(source, name);
                File destinationFile = new File(destination, name);
                FileUtils.copyFile((File)sourceFile, (File)destinationFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reader validate(Reader source, String resource) throws ParseException, IOException {
        LOGGER.debug("Validating: " + resource);
        try {
            String content = IOUtil.toString((Reader)new BufferedReader(source));
            new XmlValidator().validate(content);
            StringReader stringReader = new StringReader(content);
            return stringReader;
        }
        finally {
            IOUtil.close((Reader)source);
        }
    }

    static boolean endsWithIgnoreCase(String str, String searchStr) {
        if (str.length() < searchStr.length()) {
            return false;
        }
        return str.regionMatches(true, str.length() - searchStr.length(), searchStr, 0, searchStr.length());
    }

    private static ZipFile getZipFile(File file) throws IOException {
        if (file == null) {
            throw new IOException("Error opening ZipFile: null");
        }
        try {
            return new ZipFile(file);
        }
        catch (ZipException ex) {
            IOException ioe = new IOException("Error opening ZipFile: " + file.getAbsolutePath());
            ioe.initCause(ex);
            throw ioe;
        }
    }

    private static void closeZipFile(ZipFile zipFile) {
        try {
            zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getSiteRendererVersion() {
        InputStream inputStream = DefaultSiteRenderer.class.getResourceAsStream("/META-INF/maven/org.apache.maven.doxia/doxia-site-renderer/pom.properties");
        if (inputStream == null) {
            LOGGER.debug("pom.properties for doxia-site-renderer not found");
            return null;
        }
        Properties properties = new Properties();
        try (InputStream in = inputStream;){
            properties.load(in);
            String string = properties.getProperty("version");
            return string;
        }
        catch (IOException e) {
            LOGGER.debug("Failed to load pom.properties, so Doxia SiteRenderer version will not be available", (Throwable)e);
        }
        return null;
    }
}

