/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus.scanners;

import org.eclipse.sisu.reflect.ClassSpace;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CloningClassLoader
extends ClassLoader {
    private static final String CLONE_MARKER = "$__plexus";
    private final ClassSpace space;

    CloningClassLoader(ClassSpace space) {
        this.space = space;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!name.contains(CLONE_MARKER)) {
            try {
                return this.space.loadClass(name);
            }
            catch (TypeNotPresentException e) {
                throw new ClassNotFoundException(name);
            }
        }
        return super.loadClass(name, resolve);
    }

    static String proxyName(String realName, int cloneId) {
        StringBuilder buf = new StringBuilder();
        if (realName.startsWith("java")) {
            buf.append('$');
        }
        return buf.append(realName).append(CLONE_MARKER).append(cloneId).toString();
    }

    static String getRealName(String proxyName) {
        int cloneMarker = proxyName.lastIndexOf(CLONE_MARKER);
        if (cloneMarker < 0) {
            return proxyName;
        }
        int end = proxyName.length();
        for (int i = cloneMarker + CLONE_MARKER.length(); i < end; ++i) {
            char c = proxyName.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return proxyName;
        }
        return proxyName.substring('$' == proxyName.charAt(0) ? 1 : 0, cloneMarker);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String proxyName = name.replace('.', '/');
        String superName = CloningClassLoader.getRealName(proxyName);
        if (superName.equals(proxyName)) {
            throw new ClassNotFoundException(name);
        }
        ClassWriter cw = new ClassWriter(1);
        cw.visit(49, 1, proxyName, null, superName, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superName, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        byte[] buf = cw.toByteArray();
        return this.defineClass(name, buf, 0, buf.length);
    }

    public String toString() {
        return this.space.toString();
    }
}

