/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http;

import hidden.org.apache.commons.httpclient.methods.GetMethod;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.shared.http.AbstractHttpClientWagon;
import org.apache.maven.wagon.shared.http.HtmlFileListParser;

public class HttpWagon
extends AbstractHttpClientWagon {
    public List getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (destinationDirectory.length() > 0 && !destinationDirectory.endsWith("/")) {
            destinationDirectory = destinationDirectory + "/";
        }
        String url = this.getRepository().getUrl() + "/" + destinationDirectory;
        GetMethod getMethod = new GetMethod(url);
        try {
            int statusCode = this.execute(getMethod);
            this.fireTransferDebug(url + " - Status code: " + statusCode);
            switch (statusCode) {
                case 200: {
                    break;
                }
                case -1: {
                    throw new TransferFailedException("Failed to transfer file: ");
                }
                case 403: {
                    throw new AuthorizationException("Access denied to: " + url);
                }
                case 401: {
                    throw new AuthorizationException("Not authorized.");
                }
                case 407: {
                    throw new AuthorizationException("Not authorized by proxy.");
                }
                case 404: {
                    throw new ResourceDoesNotExistException("File: " + url + " does not exist");
                }
                default: {
                    throw new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode);
                }
            }
            InputStream is = null;
            is = getMethod.getResponseBodyAsStream();
            List list = HtmlFileListParser.parseFileList(url, is);
            return list;
        }
        catch (IOException e) {
            throw new TransferFailedException("Could not read response body.", e);
        }
        finally {
            getMethod.releaseConnection();
        }
    }
}

