/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.interpolation;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.maven.model.Model;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.interpolation.AbstractStringBasedModelInterpolator;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.path.PathTranslator;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.logging.Logger;

public class StringSearchModelInterpolator
extends AbstractStringBasedModelInterpolator {
    private static final Map<Class<?>, Field[]> fieldsByClass = new WeakHashMap();
    private static final Map<Class<?>, Boolean> fieldIsPrimitiveByClass = new WeakHashMap();

    public StringSearchModelInterpolator() {
    }

    public StringSearchModelInterpolator(PathTranslator pathTranslator) {
        super(pathTranslator);
    }

    public Model interpolate(Model model, File projectDir, ProjectBuilderConfiguration config, boolean debugEnabled) throws ModelInterpolationException {
        this.interpolateObject(model, model, projectDir, config, debugEnabled);
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void interpolateObject(Object obj, Model model, File projectDir, ProjectBuilderConfiguration config, boolean debugEnabled) throws ModelInterpolationException {
        try {
            List<ValueSource> valueSources = this.createValueSources(model, projectDir, config);
            List<InterpolationPostProcessor> postProcessors = this.createPostProcessors(model, projectDir, config);
            InterpolateObjectAction action = new InterpolateObjectAction(obj, valueSources, postProcessors, debugEnabled, this, this.getLogger());
            ModelInterpolationException error = AccessController.doPrivileged(action);
            if (error != null) {
                throw error;
            }
        }
        finally {
            this.getInterpolator().clearAnswers();
        }
    }

    protected Interpolator createInterpolator() {
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.setCacheAnswers(true);
        return interpolator;
    }

    static /* synthetic */ Map access$000() {
        return fieldsByClass;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InterpolateObjectAction
    implements PrivilegedAction<ModelInterpolationException> {
        private final boolean debugEnabled;
        private final LinkedList<Object> interpolationTargets;
        private final StringSearchModelInterpolator modelInterpolator;
        private final Logger logger;
        private final List<ValueSource> valueSources;
        private final List<InterpolationPostProcessor> postProcessors;

        public InterpolateObjectAction(Object target, List<ValueSource> valueSources, List<InterpolationPostProcessor> postProcessors, boolean debugEnabled, StringSearchModelInterpolator modelInterpolator, Logger logger) {
            this.valueSources = valueSources;
            this.postProcessors = postProcessors;
            this.debugEnabled = debugEnabled;
            this.interpolationTargets = new LinkedList();
            this.interpolationTargets.add(target);
            this.modelInterpolator = modelInterpolator;
            this.logger = logger;
        }

        @Override
        public ModelInterpolationException run() {
            while (!this.interpolationTargets.isEmpty()) {
                Object obj = this.interpolationTargets.removeFirst();
                try {
                    this.traverseObjectWithParents(obj.getClass(), obj);
                }
                catch (ModelInterpolationException e) {
                    return e;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        private void traverseObjectWithParents(Class<?> cls, Object target) throws ModelInterpolationException {
            block28: {
                block27: {
                    if (cls == null) {
                        return;
                    }
                    if (!cls.isArray()) break block27;
                    this.evaluateArray(target);
                    break block28;
                }
                if (!this.isQualifiedForInterpolation(cls)) break block28;
                fields = (Field[])StringSearchModelInterpolator.access$000().get(cls);
                if (fields == null) {
                    fields = cls.getDeclaredFields();
                    StringSearchModelInterpolator.access$000().put(cls, fields);
                }
                for (i = 0; i < fields.length; ++i) {
                    type = fields[i].getType();
                    if (!this.isQualifiedForInterpolation(fields[i], type)) continue;
                    isAccessible = fields[i].isAccessible();
                    fields[i].setAccessible(true);
                    if (String.class == type) {
                        value = (String)fields[i].get(target);
                        if (value == null || (interpolated = this.modelInterpolator.interpolateInternal((String)value, this.valueSources, this.postProcessors, this.debugEnabled)).equals(value)) continue;
                        fields[i].set(target, interpolated);
                        continue;
                    }
                    if (!Collection.class.isAssignableFrom(type)) ** GOTO lbl61
                    c = (Collection)fields[i].get(target);
                    if (c == null || c.isEmpty()) continue;
                    originalValues = new ArrayList<E>(c);
                    try {
                        c.clear();
                    }
                    catch (UnsupportedOperationException e) {
                        if (this.debugEnabled && this.logger != null) {
                            this.logger.debug("Skipping interpolation of field: " + fields[i] + " in: " + cls.getName() + "; it is an unmodifiable collection.");
                        }
                        fields[i].setAccessible(isAccessible);
                        continue;
                    }
                    try {
                        try {
                            for (V value : originalValues) {
                                if (value /* !! */  != null) {
                                    if (String.class == value /* !! */ .getClass()) {
                                        interpolated = this.modelInterpolator.interpolateInternal((String)value /* !! */ , this.valueSources, this.postProcessors, this.debugEnabled);
                                        if (!interpolated.equals(value /* !! */ )) {
                                            c.add(interpolated);
                                            continue;
                                        }
                                        c.add(value /* !! */ );
                                        continue;
                                    }
                                    c.add(value /* !! */ );
                                    if (value /* !! */ .getClass().isArray()) {
                                        this.evaluateArray(value /* !! */ );
                                        continue;
                                    }
                                    this.interpolationTargets.add(value /* !! */ );
                                    continue;
                                }
                                c.add(value /* !! */ );
                            }
                            continue;
lbl61:
                            // 1 sources

                            if (Map.class.isAssignableFrom(type)) {
                                m = (Map)fields[i].get(target);
                                if (m != null && !m.isEmpty()) {
                                    for (Map.Entry<K, String> entry : m.entrySet()) {
                                        value /* !! */  = entry.getValue();
                                        if (value /* !! */  == null) continue;
                                        if (String.class == value /* !! */ .getClass()) {
                                            interpolated = this.modelInterpolator.interpolateInternal((String)value /* !! */ , this.valueSources, this.postProcessors, this.debugEnabled);
                                            if (interpolated.equals(value /* !! */ )) continue;
                                            try {
                                                entry.setValue(interpolated);
                                            }
                                            catch (UnsupportedOperationException e) {
                                                if (!this.debugEnabled || this.logger == null) continue;
                                                this.logger.debug("Skipping interpolation of field: " + fields[i] + " (key: " + entry.getKey() + ") in: " + cls.getName() + "; it is an unmodifiable collection.");
                                            }
                                            continue;
                                        }
                                        if (value /* !! */ .getClass().isArray()) {
                                            this.evaluateArray(value /* !! */ );
                                            continue;
                                        }
                                        this.interpolationTargets.add(value /* !! */ );
                                    }
                                }
                                continue;
                            }
                            value = fields[i].get(target);
                            if (value == null) continue;
                            if (fields[i].getType().isArray()) {
                                this.evaluateArray(value);
                                continue;
                            }
                            this.interpolationTargets.add(value);
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            throw new ModelInterpolationException("Failed to interpolate field: " + fields[i] + " on class: " + cls.getName(), e);
                        }
                        catch (IllegalAccessException e) {
                            throw new ModelInterpolationException("Failed to interpolate field: " + fields[i] + " on class: " + cls.getName(), e);
                        }
                    }
                    catch (Throwable var13_16) {
                        throw var13_16;
                    }
                    finally {
                        fields[i].setAccessible(isAccessible);
                    }
                }
                this.traverseObjectWithParents(cls.getSuperclass(), target);
            }
        }

        private boolean isQualifiedForInterpolation(Class<?> cls) {
            return !cls.getPackage().getName().startsWith("java");
        }

        private boolean isQualifiedForInterpolation(Field field, Class<?> fieldType) {
            if (!fieldIsPrimitiveByClass.containsKey(fieldType)) {
                fieldIsPrimitiveByClass.put(fieldType, fieldType.isPrimitive());
            }
            if (((Boolean)fieldIsPrimitiveByClass.get(fieldType)).booleanValue()) {
                return false;
            }
            return !"parent".equals(field.getName());
        }

        private void evaluateArray(Object target) throws ModelInterpolationException {
            int len = Array.getLength(target);
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(target, i);
                if (value == null) continue;
                if (String.class == value.getClass()) {
                    String interpolated = this.modelInterpolator.interpolateInternal((String)value, this.valueSources, this.postProcessors, this.debugEnabled);
                    if (interpolated.equals(value)) continue;
                    Array.set(target, i, interpolated);
                    continue;
                }
                this.interpolationTargets.add(value);
            }
        }
    }
}

