/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.regex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.regex.JavaUtilRegexCapabilities;
import org.apache.lucene.search.regex.RegexCapabilities;
import org.apache.lucene.search.regex.RegexQuery;
import org.apache.lucene.search.regex.RegexQueryCapable;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ToStringUtils;

public class SpanRegexQuery
extends SpanQuery
implements RegexQueryCapable {
    private RegexCapabilities regexImpl = new JavaUtilRegexCapabilities();
    private Term term;

    public SpanRegexQuery(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        RegexQuery orig = new RegexQuery(this.term);
        orig.setRegexImplementation(this.regexImpl);
        orig.setRewriteMethod(RegexQuery.SCORING_BOOLEAN_QUERY_REWRITE);
        BooleanQuery bq = (BooleanQuery)orig.rewrite(reader);
        BooleanClause[] clauses = bq.getClauses();
        SpanQuery[] sqs = new SpanQuery[clauses.length];
        for (int i = 0; i < clauses.length; ++i) {
            BooleanClause clause = clauses[i];
            TermQuery tq = (TermQuery)clause.getQuery();
            sqs[i] = new SpanTermQuery(tq.getTerm());
            sqs[i].setBoost(tq.getBoost());
        }
        SpanOrQuery query = new SpanOrQuery(sqs);
        query.setBoost(orig.getBoost());
        return query;
    }

    public Spans getSpans(IndexReader reader) throws IOException {
        throw new UnsupportedOperationException("Query should have been rewritten");
    }

    public String getField() {
        return this.term.field();
    }

    public Collection getTerms() {
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(this.term);
        return terms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpanRegexQuery that = (SpanRegexQuery)o;
        if (!this.regexImpl.equals(that.regexImpl)) {
            return false;
        }
        return this.term.equals((Object)that.term);
    }

    public int hashCode() {
        int result = this.regexImpl.hashCode();
        result = 29 * result + this.term.hashCode();
        return result;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("spanRegexQuery(");
        buffer.append(this.term);
        buffer.append(")");
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    public void setRegexImplementation(RegexCapabilities impl) {
        this.regexImpl = impl;
    }

    public RegexCapabilities getRegexImplementation() {
        return this.regexImpl;
    }
}

