/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.LongValues;

final class GlobalOrdinalsCollector
implements Collector {
    final String field;
    final LongBitSet collectedOrds;
    final MultiDocValues.OrdinalMap ordinalMap;

    GlobalOrdinalsCollector(String field, MultiDocValues.OrdinalMap ordinalMap, long valueCount) {
        this.field = field;
        this.ordinalMap = ordinalMap;
        this.collectedOrds = new LongBitSet(valueCount);
    }

    public LongBitSet getCollectorOrdinals() {
        return this.collectedOrds;
    }

    public boolean needsScores() {
        return false;
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        SortedDocValues docTermOrds = DocValues.getSorted((LeafReader)context.reader(), (String)this.field);
        if (this.ordinalMap != null) {
            LongValues segmentOrdToGlobalOrdLookup = this.ordinalMap.getGlobalOrds(context.ord);
            return new OrdinalMapCollector(docTermOrds, segmentOrdToGlobalOrdLookup);
        }
        return new SegmentOrdinalCollector(docTermOrds);
    }

    final class SegmentOrdinalCollector
    implements LeafCollector {
        private final SortedDocValues docTermOrds;

        SegmentOrdinalCollector(SortedDocValues docTermOrds) {
            this.docTermOrds = docTermOrds;
        }

        public void collect(int doc) throws IOException {
            long segmentOrd = this.docTermOrds.getOrd(doc);
            if (segmentOrd != -1L) {
                GlobalOrdinalsCollector.this.collectedOrds.set(segmentOrd);
            }
        }

        public void setScorer(Scorer scorer) throws IOException {
        }
    }

    final class OrdinalMapCollector
    implements LeafCollector {
        private final SortedDocValues docTermOrds;
        private final LongValues segmentOrdToGlobalOrdLookup;

        OrdinalMapCollector(SortedDocValues docTermOrds, LongValues segmentOrdToGlobalOrdLookup) {
            this.docTermOrds = docTermOrds;
            this.segmentOrdToGlobalOrdLookup = segmentOrdToGlobalOrdLookup;
        }

        public void collect(int doc) throws IOException {
            long segmentOrd = this.docTermOrds.getOrd(doc);
            if (segmentOrd != -1L) {
                long globalOrd = this.segmentOrdToGlobalOrdLookup.get(segmentOrd);
                GlobalOrdinalsCollector.this.collectedOrds.set(globalOrd);
            }
        }

        public void setScorer(Scorer scorer) throws IOException {
        }
    }
}

