/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.util.Arrays;

public class CategoryPath
implements Comparable<CategoryPath> {
    public static final CategoryPath EMPTY = new CategoryPath();
    public final String[] components;
    public final int length;

    private CategoryPath() {
        this.components = null;
        this.length = 0;
    }

    private CategoryPath(CategoryPath copyFrom, int prefixLen) {
        assert (prefixLen > 0 && prefixLen <= copyFrom.components.length) : "prefixLen cannot be negative nor larger than the given components' length: prefixLen=" + prefixLen + " components.length=" + copyFrom.components.length;
        this.components = copyFrom.components;
        this.length = prefixLen;
    }

    public CategoryPath(String ... components) {
        assert (components.length > 0) : "use CategoryPath.EMPTY to create an empty path";
        for (String comp : components) {
            if (comp != null && !comp.isEmpty()) continue;
            throw new IllegalArgumentException("empty or null components not allowed: " + Arrays.toString(components));
        }
        this.components = components;
        this.length = components.length;
    }

    public CategoryPath(String pathString, char delimiter) {
        Object[] comps = pathString.split(Character.toString(delimiter));
        if (comps.length == 1 && comps[0].isEmpty()) {
            this.components = null;
            this.length = 0;
        } else {
            for (String string : comps) {
                if (string != null && !string.isEmpty()) continue;
                throw new IllegalArgumentException("empty or null components not allowed: " + Arrays.toString(comps));
            }
            this.components = comps;
            this.length = this.components.length;
        }
    }

    public int fullPathLength() {
        if (this.length == 0) {
            return 0;
        }
        int charsNeeded = 0;
        for (int i = 0; i < this.length; ++i) {
            charsNeeded += this.components[i].length();
        }
        return charsNeeded += this.length - 1;
    }

    @Override
    public int compareTo(CategoryPath other) {
        int len = this.length < other.length ? this.length : other.length;
        int i = 0;
        int j = 0;
        while (i < len) {
            int cmp = this.components[i].compareTo(other.components[j]);
            if (cmp < 0) {
                return -1;
            }
            if (cmp > 0) {
                return 1;
            }
            ++i;
            ++j;
        }
        return this.length - other.length;
    }

    private void noDelimiter(char[] buf, int offset, int len, char delimiter) {
        for (int idx = 0; idx < len; ++idx) {
            if (buf[offset + idx] != delimiter) continue;
            throw new IllegalArgumentException("delimiter character U+" + Integer.toHexString(delimiter) + " appears in path");
        }
    }

    public int copyFullPath(char[] buf, int start, char delimiter) {
        if (this.length == 0) {
            return 0;
        }
        int idx = start;
        int upto = this.length - 1;
        for (int i = 0; i < upto; ++i) {
            int len = this.components[i].length();
            this.components[i].getChars(0, len, buf, idx);
            this.noDelimiter(buf, idx, len, delimiter);
            idx += len;
            buf[idx++] = delimiter;
        }
        this.components[upto].getChars(0, this.components[upto].length(), buf, idx);
        this.noDelimiter(buf, idx, this.components[upto].length(), delimiter);
        return idx + this.components[upto].length() - start;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CategoryPath)) {
            return false;
        }
        CategoryPath other = (CategoryPath)obj;
        if (this.length != other.length) {
            return false;
        }
        for (int i = this.length - 1; i >= 0; --i) {
            if (this.components[i].equals(other.components[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.length == 0) {
            return 0;
        }
        int hash = this.length;
        for (int i = 0; i < this.length; ++i) {
            hash = hash * 31 + this.components[i].hashCode();
        }
        return hash;
    }

    public long longHashCode() {
        if (this.length == 0) {
            return 0L;
        }
        long hash = this.length;
        for (int i = 0; i < this.length; ++i) {
            hash = hash * 65599L + (long)this.components[i].hashCode();
        }
        return hash;
    }

    public CategoryPath subpath(int length) {
        if (length >= this.length || length < 0) {
            return this;
        }
        if (length == 0) {
            return EMPTY;
        }
        return new CategoryPath(this, length);
    }

    public String toString() {
        return this.toString('/');
    }

    public String toString(char delimiter) {
        if (this.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.length; ++i) {
            sb.append(this.components[i]).append(delimiter);
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}

