/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.params.FacetIndexingParams;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetsAggregator;
import org.apache.lucene.facet.search.FacetsCollector;

public class PerCategoryListAggregator
implements FacetsAggregator {
    private final Map<CategoryListParams, FacetsAggregator> aggregators;
    private final FacetIndexingParams fip;

    public PerCategoryListAggregator(Map<CategoryListParams, FacetsAggregator> aggregators, FacetIndexingParams fip) {
        this.aggregators = aggregators;
        this.fip = fip;
    }

    @Override
    public void aggregate(FacetsCollector.MatchingDocs matchingDocs, CategoryListParams clp, FacetArrays facetArrays) throws IOException {
        this.aggregators.get(clp).aggregate(matchingDocs, clp, facetArrays);
    }

    @Override
    public void rollupValues(FacetRequest fr, int ordinal, int[] children, int[] siblings, FacetArrays facetArrays) {
        CategoryListParams clp = this.fip.getCategoryListParams(fr.categoryPath);
        this.aggregators.get(clp).rollupValues(fr, ordinal, children, siblings, facetArrays);
    }

    @Override
    public boolean requiresDocScores() {
        for (FacetsAggregator aggregator : this.aggregators.values()) {
            if (!aggregator.requiresDocScores()) continue;
            return true;
        }
        return false;
    }
}

