/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;

public final class ArraysPool {
    private final ArrayBlockingQueue<int[]> intsPool;
    private final ArrayBlockingQueue<float[]> floatsPool;
    public final int arrayLength;

    public ArraysPool(int arrayLength, int maxArrays) {
        if (maxArrays == 0) {
            throw new IllegalArgumentException("maxArrays cannot be 0 - don't use this class if you don't intend to pool arrays");
        }
        this.arrayLength = arrayLength;
        this.intsPool = new ArrayBlockingQueue(maxArrays);
        this.floatsPool = new ArrayBlockingQueue(maxArrays);
    }

    public final int[] allocateIntArray() {
        int[] arr = this.intsPool.poll();
        if (arr == null) {
            return new int[this.arrayLength];
        }
        Arrays.fill(arr, 0);
        return arr;
    }

    public final float[] allocateFloatArray() {
        float[] arr = this.floatsPool.poll();
        if (arr == null) {
            return new float[this.arrayLength];
        }
        Arrays.fill(arr, 0.0f);
        return arr;
    }

    public final void free(int[] arr) {
        if (arr != null) {
            this.intsPool.offer(arr);
        }
    }

    public final void free(float[] arr) {
        if (arr != null) {
            this.floatsPool.offer(arr);
        }
    }
}

