/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.encoding;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.lucene.util.encoding.IntDecoder;
import org.apache.lucene.util.encoding.IntEncoder;
import org.apache.lucene.util.encoding.IntEncoderFilter;

public class SortingIntEncoder
extends IntEncoderFilter {
    private float grow = 2.0f;
    private int index = 0;
    private int[] set = new int[1024];

    public SortingIntEncoder(IntEncoder encoder) {
        super(encoder);
    }

    public void close() throws IOException {
        if (this.index == 0) {
            return;
        }
        Arrays.sort(this.set, 0, this.index);
        for (int i = 0; i < this.index; ++i) {
            this.encoder.encode(this.set[i]);
        }
        this.encoder.close();
        this.index = 0;
        super.close();
    }

    public void encode(int value) throws IOException {
        if (this.index == this.set.length) {
            int[] newSet = new int[(int)((float)this.set.length * this.grow)];
            System.arraycopy(this.set, 0, newSet, 0, this.set.length);
            this.set = newSet;
        }
        this.set[this.index++] = value;
    }

    public IntDecoder createMatchingDecoder() {
        return this.encoder.createMatchingDecoder();
    }

    public void reInit(OutputStream out) {
        super.reInit(out);
        this.index = 0;
    }

    public String toString() {
        return "Sorting (" + this.encoder.toString() + ")";
    }
}

