/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.writercache.cl2o;

import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.writercache.TaxonomyWriterCache;
import org.apache.lucene.facet.taxonomy.writercache.cl2o.CompactLabelToOrdinal;

public class Cl2oTaxonomyWriterCache
implements TaxonomyWriterCache {
    private CompactLabelToOrdinal cache;

    public Cl2oTaxonomyWriterCache(int initialCapcity, float loadFactor, int numHashArrays) {
        this.cache = new CompactLabelToOrdinal(initialCapcity, loadFactor, numHashArrays);
    }

    public void close() {
        this.cache = null;
    }

    public boolean hasRoom(int n) {
        return true;
    }

    public int get(CategoryPath categoryPath) {
        return this.cache.getOrdinal(categoryPath);
    }

    public int get(CategoryPath categoryPath, int length) {
        if (length < 0 || length > categoryPath.length()) {
            length = categoryPath.length();
        }
        return this.cache.getOrdinal(categoryPath, length);
    }

    public boolean put(CategoryPath categoryPath, int ordinal) {
        this.cache.addLabel(categoryPath, ordinal);
        return false;
    }

    public boolean put(CategoryPath categoryPath, int prefixLen, int ordinal) {
        this.cache.addLabel(categoryPath, prefixLen, ordinal);
        return false;
    }

    public int getMemoryUsage() {
        int memoryUsage = this.cache == null ? 0 : this.cache.getMemoryUsage();
        return memoryUsage;
    }
}

