/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search.sampling;

public class SamplingParams {
    public static final double DEFAULT_OVERSAMPLE_FACTOR = 2.0;
    public static final double DEFAULT_SAMPLE_RATIO = 0.01;
    public static final int DEFAULT_MAX_SAMPLE_SIZE = 10000;
    public static final int DEFAULT_MIN_SAMPLE_SIZE = 100;
    public static final int DEFAULT_SAMPLING_THRESHOLD = 75000;
    private int maxSampleSize = 10000;
    private int minSampleSize = 100;
    private double sampleRatio = 0.01;
    private int samplingThreshold = 75000;
    private double oversampleFactor = 2.0;

    public final int getMaxSampleSize() {
        return this.maxSampleSize;
    }

    public final int getMinSampleSize() {
        return this.minSampleSize;
    }

    public final double getSampleRatio() {
        return this.sampleRatio;
    }

    public final int getSamplingThreshold() {
        return this.samplingThreshold;
    }

    public void setMaxSampleSize(int maxSampleSize) {
        this.maxSampleSize = maxSampleSize;
    }

    public void setMinSampleSize(int minSampleSize) {
        this.minSampleSize = minSampleSize;
    }

    public void setSampleRatio(double sampleRatio) {
        this.sampleRatio = sampleRatio;
    }

    public void setSampingThreshold(int sampingThreshold) {
        this.samplingThreshold = sampingThreshold;
    }

    public boolean validate() {
        return this.samplingThreshold >= this.maxSampleSize && this.maxSampleSize >= this.minSampleSize && this.sampleRatio > 0.0 && this.sampleRatio < 1.0;
    }

    public final double getOversampleFactor() {
        return this.oversampleFactor;
    }

    public void setOversampleFactor(double oversampleFactor) {
        this.oversampleFactor = oversampleFactor;
    }
}

