/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.directory;

import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;

class ParentArray {
    private volatile int[] prefetchParentOrdinal = null;

    ParentArray() {
    }

    public int[] getArray() {
        return this.prefetchParentOrdinal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh(IndexReader indexReader) throws IOException {
        int first;
        int num = indexReader.maxDoc();
        if (this.prefetchParentOrdinal == null) {
            this.prefetchParentOrdinal = new int[num];
            if (num > 0) {
                this.prefetchParentOrdinal[0] = -1;
            }
            first = 1;
        } else {
            first = this.prefetchParentOrdinal.length;
            if (first == num) {
                return;
            }
            int[] newarray = new int[num];
            System.arraycopy(this.prefetchParentOrdinal, 0, newarray, 0, this.prefetchParentOrdinal.length);
            this.prefetchParentOrdinal = newarray;
        }
        TermPositions positions = indexReader.termPositions(new Term("$payloads$", "p"));
        try {
            if (!positions.skipTo(first) && first < num) {
                throw new CorruptIndexException("Missing parent data for category " + first);
            }
            for (int i = first; i < num; ++i) {
                if (positions.doc() == i) {
                    if (positions.freq() == 0) {
                        throw new CorruptIndexException("Missing parent data for category " + i);
                    }
                    this.prefetchParentOrdinal[i] = positions.nextPosition();
                    if (positions.next()) continue;
                    if (i + 1 < num) {
                        throw new CorruptIndexException("Missing parent data for category " + (i + 1));
                    }
                    break;
                }
                throw new CorruptIndexException("Missing parent data for category " + i);
            }
        }
        finally {
            positions.close();
        }
    }

    void add(int ordinal, int parentOrdinal) throws IOException {
        if (ordinal >= this.prefetchParentOrdinal.length) {
            int[] newarray = new int[ordinal * 2 + 1];
            System.arraycopy(this.prefetchParentOrdinal, 0, newarray, 0, this.prefetchParentOrdinal.length);
            this.prefetchParentOrdinal = newarray;
        }
        this.prefetchParentOrdinal[ordinal] = parentOrdinal;
    }
}

