/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.nio.charset.StandardCharsets;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.BrokerIdsZNode$;
import kafka.zk.BrokerInfo;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BrokerIdZNode$ {
    public static final BrokerIdZNode$ MODULE$;
    private final String HostKey;
    private final String PortKey;
    private final String VersionKey;
    private final String EndpointsKey;
    private final String kafka$zk$BrokerIdZNode$$RackKey;
    private final String JmxPortKey;
    private final String ListenerSecurityProtocolMapKey;
    private final String TimestampKey;

    static {
        new BrokerIdZNode$();
    }

    private String HostKey() {
        return this.HostKey;
    }

    private String PortKey() {
        return this.PortKey;
    }

    private String VersionKey() {
        return this.VersionKey;
    }

    private String EndpointsKey() {
        return this.EndpointsKey;
    }

    public String kafka$zk$BrokerIdZNode$$RackKey() {
        return this.kafka$zk$BrokerIdZNode$$RackKey;
    }

    private String JmxPortKey() {
        return this.JmxPortKey;
    }

    private String ListenerSecurityProtocolMapKey() {
        return this.ListenerSecurityProtocolMapKey;
    }

    private String TimestampKey() {
        return this.TimestampKey;
    }

    public String path(int id) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BrokerIdsZNode$.MODULE$.path(), BoxesRunTime.boxToInteger((int)id)}));
    }

    public byte[] encode(int version, String host, int port, Seq<EndPoint> advertisedEndpoints, int jmxPort, Option<String> rack) {
        scala.collection.mutable.Map jsonMap = (scala.collection.mutable.Map)scala.collection.mutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.VersionKey()), (Object)BoxesRunTime.boxToInteger((int)version)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HostKey()), (Object)host), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PortKey()), (Object)BoxesRunTime.boxToInteger((int)port)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.EndpointsKey()), JavaConverters$.MODULE$.bufferAsJavaListConverter(((TraversableOnce)advertisedEndpoints.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(EndPoint x$1) {
                return x$1.connectionString();
            }
        }, Seq$.MODULE$.canBuildFrom())).toBuffer()).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.JmxPortKey()), (Object)BoxesRunTime.boxToInteger((int)jmxPort)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TimestampKey()), (Object)((Object)BoxesRunTime.boxToLong((long)Time.SYSTEM.milliseconds())).toString())}));
        rack.foreach((Function1)new Serializable(version, jsonMap){
            public static final long serialVersionUID = 0L;
            private final int version$1;
            private final scala.collection.mutable.Map jsonMap$1;

            public final Object apply(String rack) {
                return this.version$1 >= 3 ? this.jsonMap$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BrokerIdZNode$.MODULE$.kafka$zk$BrokerIdZNode$$RackKey()), (Object)rack)) : BoxedUnit.UNIT;
            }
            {
                this.version$1 = version$1;
                this.jsonMap$1 = jsonMap$1;
            }
        });
        Object object = version >= 4 ? jsonMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ListenerSecurityProtocolMapKey()), JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)advertisedEndpoints.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(EndPoint endPoint2) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)endPoint2.listenerName().value()), (Object)endPoint2.securityProtocol().name);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava())) : BoxedUnit.UNIT;
        return Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(jsonMap).asJava());
    }

    public byte[] encode(BrokerInfo brokerInfo) {
        Broker broker = brokerInfo.broker();
        EndPoint plaintextEndpoint = (EndPoint)broker.endPoints().find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(EndPoint x$2) {
                SecurityProtocol securityProtocol2 = x$2.securityProtocol();
                SecurityProtocol securityProtocol3 = SecurityProtocol.PLAINTEXT;
                return !(securityProtocol2 != null ? !securityProtocol2.equals(securityProtocol3) : securityProtocol3 != null);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final EndPoint apply() {
                return new EndPoint(null, -1, null, null);
            }
        });
        return this.encode(brokerInfo.version(), plaintextEndpoint.host(), plaintextEndpoint.port(), broker.endPoints(), brokerInfo.jmxPort(), broker.rack());
    }

    public BrokerInfo decode(int id, byte[] jsonBytes) {
        Either<JsonProcessingException, JsonValue> either = Json$.MODULE$.tryParseBytes(jsonBytes);
        if (either instanceof Right) {
            Seq seq;
            Right right = (Right)either;
            JsonValue js = (JsonValue)right.b();
            JsonObject brokerInfo = js.asJsonObject();
            int version = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$));
            int jmxPort = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.JmxPortKey()).to(DecodeJson$DecodeInt$.MODULE$));
            if (version < 1) {
                throw new KafkaException(new StringBuilder().append((Object)"Unsupported version of broker registration: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new String(jsonBytes, StandardCharsets.UTF_8)}))).toString());
            }
            if (version == 1) {
                String host = brokerInfo.apply(this.HostKey()).to(DecodeJson$DecodeString$.MODULE$);
                int port = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.PortKey()).to(DecodeJson$DecodeInt$.MODULE$));
                SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
                EndPoint endPoint2 = new EndPoint(host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol2), securityProtocol2);
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endPoint2}));
            } else {
                Option securityProtocolMap = brokerInfo.get(this.ListenerSecurityProtocolMapKey()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Map<ListenerName, SecurityProtocol> apply(JsonValue x$3) {
                        return (Map)((TraversableLike)x$3.to(DecodeJson$.MODULE$.decodeMap(DecodeJson$DecodeString$.MODULE$, Map$.MODULE$.canBuildFrom()))).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<ListenerName, SecurityProtocol> apply(Tuple2<String, String> x0$1) {
                                Tuple2<String, String> tuple2 = x0$1;
                                if (tuple2 != null) {
                                    String listenerName = (String)tuple2._1();
                                    String securityProtocol2 = (String)tuple2._2();
                                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ListenerName(listenerName)), (Object)SecurityProtocol.forName((String)securityProtocol2));
                                    return tuple22;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, Map$.MODULE$.canBuildFrom());
                    }
                });
                Seq listeners2 = (Seq)brokerInfo.apply(this.EndpointsKey()).to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeString$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
                seq = (Seq)listeners2.map((Function1)new Serializable(securityProtocolMap){
                    public static final long serialVersionUID = 0L;
                    private final Option securityProtocolMap$1;

                    public final EndPoint apply(String x$4) {
                        return EndPoint$.MODULE$.createEndPoint(x$4, (Option<Map<ListenerName, SecurityProtocol>>)this.securityProtocolMap$1);
                    }
                    {
                        this.securityProtocolMap$1 = securityProtocolMap$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            Seq endpoints2 = seq;
            Option rack = brokerInfo.get(this.kafka$zk$BrokerIdZNode$$RackKey()).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply(JsonValue x$5) {
                    return x$5.to(DecodeJson$.MODULE$.decodeOption(DecodeJson$DecodeString$.MODULE$));
                }
            });
            BrokerInfo brokerInfo2 = new BrokerInfo(new Broker(id, (Seq<EndPoint>)endpoints2, (Option<String>)rack), version, jmxPort);
            return brokerInfo2;
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            JsonProcessingException e = (JsonProcessingException)left.a();
            throw new KafkaException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse ZooKeeper registration for broker ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new String(jsonBytes, StandardCharsets.UTF_8)}))).toString(), (Throwable)e);
        }
        throw new MatchError(either);
    }

    private BrokerIdZNode$() {
        MODULE$ = this;
        this.HostKey = "host";
        this.PortKey = "port";
        this.VersionKey = "version";
        this.EndpointsKey = "endpoints";
        this.kafka$zk$BrokerIdZNode$$RackKey = "rack";
        this.JmxPortKey = "jmx_port";
        this.ListenerSecurityProtocolMapKey = "listener_security_protocol_map";
        this.TimestampKey = "timestamp";
    }
}

