/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Optional;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.LogOffsetSnapshot;
import kafka.server.DelayedFetch$;
import kafka.server.DelayedFetchMetrics$;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperation$;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchMetadata;
import kafka.server.FetchPartitionData;
import kafka.server.FetchPartitionStatus;
import kafka.server.FetchTxnCommitted$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u000f\taA)\u001a7bs\u0016$g)\u001a;dQ*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0011\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:D\u0011\"\u0004\u0001\u0003\u0002\u0003\u0006IA\u0004\u000b\u0002\u000f\u0011,G.Y=NgB\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t!Aj\u001c8h\u0013\ti!\u0002\u0003\u0005\u0017\u0001\t\u0005\t\u0015!\u0003\u0018\u000351W\r^2i\u001b\u0016$\u0018\rZ1uCB\u0011\u0011\u0002G\u0005\u00033\t\u0011QBR3uG\"lU\r^1eCR\f\u0007\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0011\u0011\"H\u0005\u0003=\t\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\"\u0003\u0015\tXo\u001c;b!\tI!%\u0003\u0002$\u0005\ta!+\u001a9mS\u000e\f\u0017+^8uC\"AQ\u0005\u0001B\u0001B\u0003%a%\u0001\bdY&,g\u000e^'fi\u0006$\u0017\r^1\u0011\u0007=9\u0013&\u0003\u0002)!\t1q\n\u001d;j_:\u0004\"A\u000b\u001b\u000e\u0003-R!\u0001L\u0017\u0002\u000fI,\u0007\u000f\\5dC*\u0011afL\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015\u0001$BA\u00193\u0003\u0019\t\u0007/Y2iK*\t1'A\u0002pe\u001eL!!N\u0016\u0003\u001d\rc\u0017.\u001a8u\u001b\u0016$\u0018\rZ1uC\"Aq\u0007\u0001B\u0001B\u0003%\u0001(\u0001\tsKN\u0004xN\\:f\u0007\u0006dGNY1dWB!q\"O\u001eL\u0013\tQ\u0004CA\u0005Gk:\u001cG/[8ocA\u0019AhP!\u000e\u0003uR!A\u0010\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002A{\t\u00191+Z9\u0011\t=\u0011E\tS\u0005\u0003\u0007B\u0011a\u0001V;qY\u0016\u0014\u0004CA#G\u001b\u0005i\u0013BA$.\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"!C%\n\u0005)\u0013!A\u0005$fi\u000eD\u0007+\u0019:uSRLwN\u001c#bi\u0006\u0004\"a\u0004'\n\u00055\u0003\"\u0001B+oSRDQa\u0014\u0001\u0005\u0002A\u000ba\u0001P5oSRtDcB)S'R+fk\u0016\t\u0003\u0013\u0001AQ!\u0004(A\u00029AQA\u0006(A\u0002]AQa\u0007(A\u0002qAQ\u0001\t(A\u0002\u0005BQ!\n(A\u0002\u0019BQa\u000e(A\u0002aBQ!\u0017\u0001\u0005Bi\u000b1\u0002\u001e:z\u0007>l\u0007\u000f\\3uKR\t1\f\u0005\u0002\u00109&\u0011Q\f\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015y\u0006\u0001\"\u0011a\u00031yg.\u0012=qSJ\fG/[8o)\u0005Y\u0005\"\u00022\u0001\t\u0003\u0002\u0017AC8o\u0007>l\u0007\u000f\\3uK\u0002")
public class DelayedFetch
extends DelayedOperation {
    public final FetchMetadata kafka$server$DelayedFetch$$fetchMetadata;
    public final ReplicaManager kafka$server$DelayedFetch$$replicaManager;
    public final ReplicaQuota kafka$server$DelayedFetch$$quota;
    private final Option<ClientMetadata> clientMetadata;
    private final Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                IntRef accumulatedSize = IntRef.create((int)0);
                this.kafka$server$DelayedFetch$$fetchMetadata.fetchPartitionStatus().foreach((Function1)new Serializable(this, accumulatedSize, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DelayedFetch $outer;
                    private final IntRef accumulatedSize$1;
                    private final Object nonLocalReturnKey1$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final void apply(Tuple2<TopicPartition, FetchPartitionStatus> x0$1) {
                        FetchIsolation fetchIsolation;
                        Optional fetchLeaderEpoch;
                        TopicPartition topicPartition;
                        block22: {
                            BoxedUnit boxedUnit;
                            block21: {
                                LogOffsetMetadata logOffsetMetadata;
                                Tuple2<TopicPartition, FetchPartitionStatus> tuple2 = x0$1;
                                if (tuple2 == null) throw new MatchError(tuple2);
                                topicPartition = (TopicPartition)tuple2._1();
                                FetchPartitionStatus fetchStatus = (FetchPartitionStatus)tuple2._2();
                                LogOffsetMetadata fetchOffset = fetchStatus.startOffsetMetadata();
                                fetchLeaderEpoch = fetchStatus.fetchInfo().currentLeaderEpoch;
                                LogOffsetMetadata logOffsetMetadata2 = fetchOffset;
                                LogOffsetMetadata logOffsetMetadata3 = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
                                if (!(logOffsetMetadata2 != null ? !((Object)logOffsetMetadata2).equals(logOffsetMetadata3) : logOffsetMetadata3 != null)) {
                                    boxedUnit = BoxedUnit.UNIT;
                                    break block21;
                                }
                                Partition partition = this.$outer.kafka$server$DelayedFetch$$replicaManager.getPartitionOrException(topicPartition, this.$outer.kafka$server$DelayedFetch$$fetchMetadata.fetchOnlyLeader());
                                LogOffsetSnapshot offsetSnapshot = partition.fetchOffsetSnapshot(fetchLeaderEpoch, this.$outer.kafka$server$DelayedFetch$$fetchMetadata.fetchOnlyLeader());
                                fetchIsolation = this.$outer.kafka$server$DelayedFetch$$fetchMetadata.fetchIsolation();
                                if (FetchLogEnd$.MODULE$.equals(fetchIsolation)) {
                                    logOffsetMetadata = offsetSnapshot.logEndOffset();
                                } else if (FetchHighWatermark$.MODULE$.equals(fetchIsolation)) {
                                    logOffsetMetadata = offsetSnapshot.highWatermark();
                                } else {
                                    if (!FetchTxnCommitted$.MODULE$.equals(fetchIsolation)) break block22;
                                    logOffsetMetadata = offsetSnapshot.lastStableOffset();
                                }
                                LogOffsetMetadata endOffset = logOffsetMetadata;
                                if (endOffset.messageOffset() != fetchOffset.messageOffset()) {
                                    if (endOffset.onOlderSegment(fetchOffset)) {
                                        this.$outer.debug((Function0<String>)new Serializable(this, topicPartition){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$tryComplete$1 $outer;
                                            private final TopicPartition topicPartition$1;

                                            public final String apply() {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Satisfying fetch ", " since it is fetching later segments of partition ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$server$DelayedFetch$$anonfun$$$outer().kafka$server$DelayedFetch$$fetchMetadata, this.topicPartition$1}));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.topicPartition$1 = topicPartition$1;
                                            }
                                        });
                                        throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, this.$outer.forceComplete());
                                    }
                                    if (fetchOffset.onOlderSegment(endOffset)) {
                                        this.$outer.debug((Function0<String>)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$tryComplete$1 $outer;

                                            public final String apply() {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Satisfying fetch ", " immediately since it is fetching older segments."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$server$DelayedFetch$$anonfun$$$outer().kafka$server$DelayedFetch$$fetchMetadata}));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                        if (!this.$outer.kafka$server$DelayedFetch$$replicaManager.shouldLeaderThrottle(this.$outer.kafka$server$DelayedFetch$$quota, topicPartition, this.$outer.kafka$server$DelayedFetch$$fetchMetadata.replicaId())) {
                                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, this.$outer.forceComplete());
                                        }
                                    } else if (fetchOffset.messageOffset() < endOffset.messageOffset()) {
                                        int bytesAvailable = package$.MODULE$.min(endOffset.positionDiff(fetchOffset), fetchStatus.fetchInfo().maxBytes);
                                        if (!this.$outer.kafka$server$DelayedFetch$$replicaManager.shouldLeaderThrottle(this.$outer.kafka$server$DelayedFetch$$quota, topicPartition, this.$outer.kafka$server$DelayedFetch$$fetchMetadata.replicaId())) {
                                            this.accumulatedSize$1.elem += bytesAvailable;
                                        }
                                    }
                                }
                                if (this.$outer.kafka$server$DelayedFetch$$fetchMetadata.isFromFollower()) {
                                    if (partition.getReplica(this.$outer.kafka$server$DelayedFetch$$fetchMetadata.replicaId()).exists((Function1)new Serializable(this, offsetSnapshot){
                                        public static final long serialVersionUID = 0L;
                                        private final LogOffsetSnapshot offsetSnapshot$1;

                                        public final boolean apply(Replica r) {
                                            return this.offsetSnapshot$1.highWatermark().messageOffset() > r.lastSentHighWatermark();
                                        }
                                        {
                                            this.offsetSnapshot$1 = offsetSnapshot$1;
                                        }
                                    })) {
                                        throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, this.$outer.forceComplete());
                                    }
                                    boxedUnit = BoxedUnit.UNIT;
                                    break block21;
                                }
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                            return;
                        }
                        try {
                            throw new MatchError((Object)fetchIsolation);
                        }
                        catch (FencedLeaderEpochException fencedLeaderEpochException) {
                            this.$outer.debug((Function0<String>)new Serializable(this, topicPartition, fetchLeaderEpoch){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$tryComplete$1 $outer;
                                private final TopicPartition topicPartition$1;
                                private final Optional fetchLeaderEpoch$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker is the leader of partition ", ", but the requested epoch "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is fenced by the latest leader epoch, satisfy ", " immediately"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fetchLeaderEpoch$1, this.$outer.kafka$server$DelayedFetch$$anonfun$$$outer().kafka$server$DelayedFetch$$fetchMetadata}))).toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.topicPartition$1 = topicPartition$1;
                                    this.fetchLeaderEpoch$1 = fetchLeaderEpoch$1;
                                }
                            });
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, this.$outer.forceComplete());
                        }
                        catch (KafkaStorageException kafkaStorageException) {
                            this.$outer.debug((Function0<String>)new Serializable(this, topicPartition){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$tryComplete$1 $outer;
                                private final TopicPartition topicPartition$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", " is in an offline log directory, satisfy ", " immediately"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1, this.$outer.kafka$server$DelayedFetch$$anonfun$$$outer().kafka$server$DelayedFetch$$fetchMetadata}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.topicPartition$1 = topicPartition$1;
                                }
                            });
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, this.$outer.forceComplete());
                        }
                        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                            this.$outer.debug((Function0<String>)new Serializable(this, topicPartition){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$tryComplete$1 $outer;
                                private final TopicPartition topicPartition$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker no longer knows of partition ", ", satisfy ", " immediately"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1, this.$outer.kafka$server$DelayedFetch$$anonfun$$$outer().kafka$server$DelayedFetch$$fetchMetadata}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.topicPartition$1 = topicPartition$1;
                                }
                            });
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, this.$outer.forceComplete());
                        }
                        catch (ReplicaNotAvailableException replicaNotAvailableException) {
                            this.$outer.debug((Function0<String>)new Serializable(this, topicPartition){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$tryComplete$1 $outer;
                                private final TopicPartition topicPartition$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker no longer has a replica of ", ", satisfy ", " immediately"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1, this.$outer.kafka$server$DelayedFetch$$anonfun$$$outer().kafka$server$DelayedFetch$$fetchMetadata}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.topicPartition$1 = topicPartition$1;
                                }
                            });
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, this.$outer.forceComplete());
                        }
                        catch (NotLeaderForPartitionException notLeaderForPartitionException) {
                            this.$outer.debug((Function0<String>)new Serializable(this, topicPartition){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$tryComplete$1 $outer;
                                private final TopicPartition topicPartition$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker is no longer the leader of ", ", satisfy ", " immediately"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1, this.$outer.kafka$server$DelayedFetch$$anonfun$$$outer().kafka$server$DelayedFetch$$fetchMetadata}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.topicPartition$1 = topicPartition$1;
                                }
                            });
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, this.$outer.forceComplete());
                        }
                    }

                    public /* synthetic */ DelayedFetch kafka$server$DelayedFetch$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.accumulatedSize$1 = accumulatedSize$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                bl = accumulatedSize.elem >= this.kafka$server$DelayedFetch$$fetchMetadata.fetchMinBytes() ? this.forceComplete() : false;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    @Override
    public void onExpiration() {
        if (this.kafka$server$DelayedFetch$$fetchMetadata.isFromFollower()) {
            DelayedFetchMetrics$.MODULE$.followerExpiredRequestMeter().mark();
        } else {
            DelayedFetchMetrics$.MODULE$.consumerExpiredRequestMeter().mark();
        }
    }

    @Override
    public void onComplete() {
        int x$1 = this.kafka$server$DelayedFetch$$fetchMetadata.replicaId();
        boolean x$2 = this.kafka$server$DelayedFetch$$fetchMetadata.fetchOnlyLeader();
        FetchIsolation x$3 = this.kafka$server$DelayedFetch$$fetchMetadata.fetchIsolation();
        int x$4 = this.kafka$server$DelayedFetch$$fetchMetadata.fetchMaxBytes();
        boolean x$5 = this.kafka$server$DelayedFetch$$fetchMetadata.hardMaxBytesLimit();
        Seq x$6 = (Seq)this.kafka$server$DelayedFetch$$fetchMetadata.fetchPartitionStatus().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, FetchRequest.PartitionData> apply(Tuple2<TopicPartition, FetchPartitionStatus> x0$2) {
                Tuple2<TopicPartition, FetchPartitionStatus> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    FetchPartitionStatus status = (FetchPartitionStatus)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)status.fetchInfo());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Option<ClientMetadata> x$7 = this.clientMetadata;
        ReplicaQuota x$8 = this.kafka$server$DelayedFetch$$quota;
        Seq<Tuple2<TopicPartition, LogReadResult>> logReadResults = this.kafka$server$DelayedFetch$$replicaManager.readFromLocalLog(x$1, x$2, x$3, x$4, x$5, (Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>>)x$6, x$8, x$7);
        Seq fetchPartitionData = (Seq)logReadResults.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, FetchPartitionData> apply(Tuple2<TopicPartition, LogReadResult> x0$3) {
                Tuple2<TopicPartition, LogReadResult> tuple2 = x0$3;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    LogReadResult result = (LogReadResult)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new FetchPartitionData(result.error(), result.highWatermark(), result.leaderLogStartOffset(), result.info().records(), result.lastStableOffset(), result.info().abortedTransactions(), result.preferredReadReplica()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.responseCallback.apply((Object)fetchPartitionData);
    }

    public DelayedFetch(long delayMs, FetchMetadata fetchMetadata, ReplicaManager replicaManager, ReplicaQuota quota, Option<ClientMetadata> clientMetadata, Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit> responseCallback) {
        this.kafka$server$DelayedFetch$$fetchMetadata = fetchMetadata;
        this.kafka$server$DelayedFetch$$replicaManager = replicaManager;
        this.kafka$server$DelayedFetch$$quota = quota;
        this.clientMetadata = clientMetadata;
        this.responseCallback = responseCallback;
        super(delayMs, DelayedOperation$.MODULE$.$lessinit$greater$default$2());
    }
}

