/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.util.Properties;
import joptsimple.OptionSpec;
import kafka.admin.AdminOperationException;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class PreferredReplicaLeaderElectionCommand$
implements Logging {
    public static final PreferredReplicaLeaderElectionCommand$ MODULE$;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new PreferredReplicaLeaderElectionCommand$();
    }

    private Logger logger$lzycompute() {
        PreferredReplicaLeaderElectionCommand$ preferredReplicaLeaderElectionCommand$ = this;
        synchronized (preferredReplicaLeaderElectionCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        int timeout = 30000;
        this.run(args, timeout);
    }

    /*
     * WARNING - void declaration
     */
    public void run(String[] args, int timeout) {
        PreferredReplicaLeaderElectionCommand.Command command;
        None$ partitionsForPreferredReplicaElection;
        Predef$.MODULE$.println((Object)"This tool is deprecated. Please use kafka-leader-election tool. Tracking issue: KAFKA-8405");
        PreferredReplicaLeaderElectionCommand.PreferredReplicaLeaderElectionCommandOptions commandOpts = new PreferredReplicaLeaderElectionCommand.PreferredReplicaLeaderElectionCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(commandOpts, "This tool helps to causes leadership for each partition to be transferred back to the 'preferred replica', it can be used to balance leadership among the servers.");
        CommandLineUtils$.MODULE$.checkRequiredArgs(commandOpts.parser(), commandOpts.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[0]));
        if (commandOpts.options().has(commandOpts.bootstrapServerOpt()) == commandOpts.options().has(commandOpts.zkConnectOpt())) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(commandOpts.parser(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exactly one of '", "' or '", "' must be provided"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{commandOpts.bootstrapServerOpt(), commandOpts.zkConnectOpt()})));
        }
        Object object = partitionsForPreferredReplicaElection = commandOpts.options().has(commandOpts.jsonFileOpt()) ? new Some(this.parsePreferredReplicaElectionData(Utils.readFileAsString((String)((String)commandOpts.options().valueOf(commandOpts.jsonFileOpt()))))) : None$.MODULE$;
        if (commandOpts.options().has(commandOpts.zkConnectOpt())) {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Warning: --zookeeper is deprecated and will be removed in a future version of Kafka."})).s((Seq)Nil$.MODULE$));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Use --bootstrap-server instead to specify a broker to connect to."})).s((Seq)Nil$.MODULE$));
            command = new PreferredReplicaLeaderElectionCommand.ZkCommand((String)commandOpts.options().valueOf(commandOpts.zkConnectOpt()), JaasUtils.isZkSecurityEnabled(), timeout);
        } else {
            Properties adminProps = commandOpts.options().has(commandOpts.adminClientConfigOpt()) ? Utils.loadProps((String)((String)commandOpts.options().valueOf(commandOpts.adminClientConfigOpt()))) : new Properties();
            adminProps.setProperty("bootstrap.servers", (String)commandOpts.options().valueOf(commandOpts.bootstrapServerOpt()));
            adminProps.setProperty("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)timeout)).toString());
            command = new PreferredReplicaLeaderElectionCommand.AdminClientCommand(adminProps);
        }
        PreferredReplicaLeaderElectionCommand.AdminClientCommand preferredReplicaElectionCommand = command;
        try {
            preferredReplicaElectionCommand.electPreferredLeaders((Option<Set<TopicPartition>>)partitionsForPreferredReplicaElection);
            preferredReplicaElectionCommand.close();
            return;
        }
        catch (Throwable throwable) {
            void var5_6;
            var5_6.close();
            throw throwable;
        }
    }

    public int run$default$2() {
        return 30000;
    }

    public scala.collection.immutable.Set<TopicPartition> parsePreferredReplicaElectionData(String jsonString) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonString);
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonValue js = (JsonValue)some.x();
            Option<JsonValue> option2 = js.asJsonObject().get("partitions");
            if (option2 instanceof Some) {
                scala.collection.immutable.Set set;
                Some some2 = (Some)option2;
                JsonValue partitionsList = (JsonValue)some2.x();
                Iterator partitionsRaw = partitionsList.asJsonArray().iterator().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final JsonObject apply(JsonValue x$1) {
                        return x$1.asJsonObject();
                    }
                });
                Buffer partitions = partitionsRaw.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final TopicPartition apply(JsonObject p) {
                        String topic = p.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
                        int partition = BoxesRunTime.unboxToInt((Object)p.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
                        return new TopicPartition(topic, partition);
                    }
                }).toBuffer();
                Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates(partitions);
                if (duplicatePartitions.nonEmpty()) {
                    throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Preferred replica election data contains duplicate partitions: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicatePartitions.mkString(",")})));
                }
                scala.collection.immutable.Set set2 = set = partitions.toSet();
                return set2;
            }
            if (None$.MODULE$.equals(option2)) {
                throw new AdminOperationException("Preferred replica election data is empty");
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            throw new AdminOperationException("Preferred replica election data is empty");
        }
        throw new MatchError(option);
    }

    public void writePreferredReplicaElectionData(KafkaZkClient zkClient, Set<TopicPartition> partitionsUndergoingPreferredReplicaElection) {
        try {
            zkClient.createPreferredReplicaElection((scala.collection.immutable.Set<TopicPartition>)partitionsUndergoingPreferredReplicaElection.toSet());
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Created preferred replica election path with %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsUndergoingPreferredReplicaElection.mkString(",")})));
            return;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(throwable.toString());
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new AdminOperationException(new StringBuilder().append((Object)"Preferred replica leader election currently in progress for ").append((Object)new StringOps(Predef$.MODULE$.augmentString("%s. Aborting operation")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{zkClient.getPreferredReplicaElection().mkString(",")}))).toString());
        }
    }

    private PreferredReplicaLeaderElectionCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

