/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.concurrent.atomic.AtomicLong;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.KafkaStream;
import kafka.tools.ConsumerPerformance;
import kafka.tools.ConsumerPerformance$;
import kafka.utils.ZkUtils$;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class ConsumerPerformance$ {
    public static final ConsumerPerformance$ MODULE$;
    private final Logger logger;

    static {
        new ConsumerPerformance$();
    }

    private Logger logger() {
        return this.logger;
    }

    public void main(String[] args) {
        ConsumerPerformance.ConsumerPerfConfig config = new ConsumerPerformance.ConsumerPerfConfig(args);
        this.logger().info((Object)"Starting consumer...");
        ObjectRef totalMessagesRead = ObjectRef.create((Object)new AtomicLong(0L));
        ObjectRef totalBytesRead = ObjectRef.create((Object)new AtomicLong(0L));
        if (!config.hideHeader()) {
            if (config.showDetailedStats()) {
                Predef$.MODULE$.println((Object)"time, fetch.size, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec");
            } else {
                Predef$.MODULE$.println((Object)"start.time, end.time, fetch.size, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec");
            }
        }
        ZkUtils$.MODULE$.maybeDeletePath(config.consumerConfig().zkConnect(), new StringBuilder().append((Object)"/consumers/").append((Object)config.consumerConfig().groupId()).toString());
        ConsumerConnector consumerConnector = Consumer$.MODULE$.create(config.consumerConfig());
        Map<String, List<KafkaStream<byte[], byte[]>>> topicMessageStreams = consumerConnector.createMessageStreams((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)config.topic()), (Object)BoxesRunTime.boxToInteger((int)config.numThreads()))}))));
        ObjectRef threadList = ObjectRef.create((Object)Nil$.MODULE$);
        topicMessageStreams.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, List<KafkaStream<byte[], byte[]>>> check$ifrefutable$1) {
                Tuple2<String, List<KafkaStream<byte[], byte[]>>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(config, totalMessagesRead, totalBytesRead, threadList){
            public static final long serialVersionUID = 0L;
            public final ConsumerPerformance.ConsumerPerfConfig config$1;
            public final ObjectRef totalMessagesRead$1;
            public final ObjectRef totalBytesRead$1;
            public final ObjectRef threadList$1;

            public final void apply(Tuple2<String, List<KafkaStream<byte[], byte[]>>> x$1) {
                Tuple2<String, List<KafkaStream<byte[], byte[]>>> tuple2 = x$1;
                if (tuple2 != null) {
                    List streamList = (List)tuple2._2();
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), streamList.length()).foreach$mVc$sp((Function1)new Serializable(this, streamList){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.main.2 $outer;
                        private final List streamList$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.$outer.threadList$1.elem = ((List)this.$outer.threadList$1.elem).$colon$colon((Object)new ConsumerPerformance.ConsumerPerfThread(i, new StringBuilder().append((Object)"kafka-zk-consumer-").append((Object)BoxesRunTime.boxToInteger((int)i)).toString(), (KafkaStream)this.streamList$1.apply(i), this.$outer.config$1, (AtomicLong)this.$outer.totalMessagesRead$1.elem, (AtomicLong)this.$outer.totalBytesRead$1.elem));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.streamList$1 = streamList$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.config$1 = config$1;
                this.totalMessagesRead$1 = totalMessagesRead$1;
                this.totalBytesRead$1 = totalBytesRead$1;
                this.threadList$1 = threadList$1;
            }
        });
        this.logger().info((Object)"Sleeping for 1 second.");
        Thread.sleep(1000L);
        this.logger().info((Object)"starting threads");
        long startMs = System.currentTimeMillis();
        ((List)threadList.elem).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(ConsumerPerformance.ConsumerPerfThread thread) {
                thread.start();
            }
        });
        ((List)threadList.elem).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(ConsumerPerformance.ConsumerPerfThread thread) {
                thread.join();
            }
        });
        long endMs = System.currentTimeMillis();
        double elapsedSecs = (double)(endMs - startMs - (long)config.consumerConfig().consumerTimeoutMs()) / 1000.0;
        if (!config.showDetailedStats()) {
            double totalMBRead = (double)((AtomicLong)totalBytesRead.elem).get() * 1.0 / (double)0x100000;
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s, %s, %d, %.4f, %.4f, %d, %.4f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.dateFormat().format(BoxesRunTime.boxToLong((long)startMs)), config.dateFormat().format(BoxesRunTime.boxToLong((long)endMs)), BoxesRunTime.boxToInteger((int)config.consumerConfig().fetchMessageMaxBytes()), BoxesRunTime.boxToDouble((double)totalMBRead), BoxesRunTime.boxToDouble((double)(totalMBRead / elapsedSecs)), BoxesRunTime.boxToLong((long)((AtomicLong)totalMessagesRead.elem).get()), BoxesRunTime.boxToDouble((double)((double)((AtomicLong)totalMessagesRead.elem).get() / elapsedSecs))})));
        }
        System.exit(0);
    }

    private ConsumerPerformance$() {
        MODULE$ = this;
        this.logger = Logger.getLogger(this.getClass());
    }
}

