/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.acl;

import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AclBindingTest {
    private static final AclBinding ACL1 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "", AclOperation.ALL, AclPermissionType.ALLOW));
    private static final AclBinding ACL2 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic", PatternType.LITERAL), new AccessControlEntry("User:*", "", AclOperation.READ, AclPermissionType.ALLOW));
    private static final AclBinding ACL3 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic2", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "127.0.0.1", AclOperation.READ, AclPermissionType.DENY));
    private static final AclBinding UNKNOWN_ACL = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic2", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "127.0.0.1", AclOperation.UNKNOWN, AclPermissionType.DENY));
    private static final AclBindingFilter ANY_ANONYMOUS = new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter("User:ANONYMOUS", null, AclOperation.ANY, AclPermissionType.ANY));
    private static final AclBindingFilter ANY_DENY = new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.DENY));
    private static final AclBindingFilter ANY_MYTOPIC = new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "mytopic", PatternType.LITERAL), new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY));

    @Test
    public void testMatching() {
        Assertions.assertEquals((Object)ACL1, (Object)ACL1);
        AclBinding acl1Copy = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "", AclOperation.ALL, AclPermissionType.ALLOW));
        Assertions.assertEquals((Object)ACL1, (Object)acl1Copy);
        Assertions.assertEquals((Object)acl1Copy, (Object)ACL1);
        Assertions.assertEquals((Object)ACL2, (Object)ACL2);
        Assertions.assertNotEquals((Object)ACL1, (Object)ACL2);
        Assertions.assertNotEquals((Object)ACL2, (Object)ACL1);
        Assertions.assertTrue((boolean)AclBindingFilter.ANY.matches(ACL1));
        Assertions.assertNotEquals((Object)AclBindingFilter.ANY, (Object)ACL1);
        Assertions.assertTrue((boolean)AclBindingFilter.ANY.matches(ACL2));
        Assertions.assertNotEquals((Object)AclBindingFilter.ANY, (Object)ACL2);
        Assertions.assertTrue((boolean)AclBindingFilter.ANY.matches(ACL3));
        Assertions.assertNotEquals((Object)AclBindingFilter.ANY, (Object)ACL3);
        Assertions.assertEquals((Object)AclBindingFilter.ANY, (Object)AclBindingFilter.ANY);
        Assertions.assertTrue((boolean)ANY_ANONYMOUS.matches(ACL1));
        Assertions.assertNotEquals((Object)ANY_ANONYMOUS, (Object)ACL1);
        Assertions.assertFalse((boolean)ANY_ANONYMOUS.matches(ACL2));
        Assertions.assertNotEquals((Object)ANY_ANONYMOUS, (Object)ACL2);
        Assertions.assertTrue((boolean)ANY_ANONYMOUS.matches(ACL3));
        Assertions.assertNotEquals((Object)ANY_ANONYMOUS, (Object)ACL3);
        Assertions.assertFalse((boolean)ANY_DENY.matches(ACL1));
        Assertions.assertFalse((boolean)ANY_DENY.matches(ACL2));
        Assertions.assertTrue((boolean)ANY_DENY.matches(ACL3));
        Assertions.assertTrue((boolean)ANY_MYTOPIC.matches(ACL1));
        Assertions.assertTrue((boolean)ANY_MYTOPIC.matches(ACL2));
        Assertions.assertFalse((boolean)ANY_MYTOPIC.matches(ACL3));
        Assertions.assertTrue((boolean)ANY_ANONYMOUS.matches(UNKNOWN_ACL));
        Assertions.assertTrue((boolean)ANY_DENY.matches(UNKNOWN_ACL));
        Assertions.assertEquals((Object)UNKNOWN_ACL, (Object)UNKNOWN_ACL);
        Assertions.assertFalse((boolean)ANY_MYTOPIC.matches(UNKNOWN_ACL));
    }

    @Test
    public void testUnknowns() {
        Assertions.assertFalse((boolean)ACL1.isUnknown());
        Assertions.assertFalse((boolean)ACL2.isUnknown());
        Assertions.assertFalse((boolean)ACL3.isUnknown());
        Assertions.assertFalse((boolean)ANY_ANONYMOUS.isUnknown());
        Assertions.assertFalse((boolean)ANY_DENY.isUnknown());
        Assertions.assertFalse((boolean)ANY_MYTOPIC.isUnknown());
        Assertions.assertTrue((boolean)UNKNOWN_ACL.isUnknown());
    }

    @Test
    public void testMatchesAtMostOne() {
        Assertions.assertNull((Object)ACL1.toFilter().findIndefiniteField());
        Assertions.assertNull((Object)ACL2.toFilter().findIndefiniteField());
        Assertions.assertNull((Object)ACL3.toFilter().findIndefiniteField());
        Assertions.assertFalse((boolean)ANY_ANONYMOUS.matchesAtMostOne());
        Assertions.assertFalse((boolean)ANY_DENY.matchesAtMostOne());
        Assertions.assertFalse((boolean)ANY_MYTOPIC.matchesAtMostOne());
    }

    @Test
    public void shouldNotThrowOnUnknownPatternType() {
        new AclBinding(new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.UNKNOWN), ACL1.entry());
    }

    @Test
    public void shouldNotThrowOnUnknownResourceType() {
        new AclBinding(new ResourcePattern(ResourceType.UNKNOWN, "foo", PatternType.LITERAL), ACL1.entry());
    }

    @Test
    public void shouldThrowOnMatchPatternType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new AclBinding(new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.MATCH), ACL1.entry()));
    }

    @Test
    public void shouldThrowOnAnyPatternType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new AclBinding(new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.ANY), ACL1.entry()));
    }

    @Test
    public void shouldThrowOnAnyResourceType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new AclBinding(new ResourcePattern(ResourceType.ANY, "foo", PatternType.LITERAL), ACL1.entry()));
    }
}

