/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.CooperativeStickyAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractStickyAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractStickyAssignorTest;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CooperativeStickyAssignorTest
extends AbstractStickyAssignorTest {
    @Override
    public AbstractStickyAssignor createAssignor() {
        return new CooperativeStickyAssignor();
    }

    @Override
    public ConsumerPartitionAssignor.Subscription buildSubscriptionV0(List<String> topics, List<TopicPartition> partitions, int generationId) {
        return null;
    }

    @Override
    public ConsumerPartitionAssignor.Subscription buildSubscriptionV1(List<String> topics, List<TopicPartition> partitions, int generationId) {
        this.assignor.onAssignment(new ConsumerPartitionAssignor.Assignment(partitions), new ConsumerGroupMetadata(this.groupId, generationId, this.consumer1, Optional.empty()));
        return new ConsumerPartitionAssignor.Subscription(topics, this.assignor.subscriptionUserData(new HashSet<String>(topics)), partitions, -1, Optional.empty());
    }

    @Override
    public ConsumerPartitionAssignor.Subscription buildSubscriptionV2Above(List<String> topics, List<TopicPartition> partitions, int generationId) {
        return new ConsumerPartitionAssignor.Subscription(topics, this.assignor.subscriptionUserData(new HashSet<String>(topics)), partitions, generationId, Optional.empty());
    }

    @Override
    public ByteBuffer generateUserData(List<String> topics, List<TopicPartition> partitions, int generation) {
        this.assignor.onAssignment(new ConsumerPartitionAssignor.Assignment(partitions), new ConsumerGroupMetadata(this.groupId, this.generationId, this.consumer1, Optional.empty()));
        return this.assignor.subscriptionUserData(new HashSet<String>(topics));
    }

    @Test
    public void testEncodeAndDecodeGeneration() {
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(CooperativeStickyAssignorTest.topics(this.topic), this.assignor.subscriptionUserData(new HashSet<String>(CooperativeStickyAssignorTest.topics(this.topic))));
        Optional encodedGeneration = ((CooperativeStickyAssignor)this.assignor).memberData((ConsumerPartitionAssignor.Subscription)subscription).generation;
        Assertions.assertTrue((boolean)encodedGeneration.isPresent());
        Assertions.assertEquals((Integer)((Integer)encodedGeneration.get()), (int)-1);
        int generation = 10;
        this.assignor.onAssignment(null, new ConsumerGroupMetadata("dummy-group-id", generation, "dummy-member-id", Optional.empty()));
        subscription = new ConsumerPartitionAssignor.Subscription(CooperativeStickyAssignorTest.topics(this.topic), this.assignor.subscriptionUserData(new HashSet<String>(CooperativeStickyAssignorTest.topics(this.topic))));
        encodedGeneration = ((CooperativeStickyAssignor)this.assignor).memberData((ConsumerPartitionAssignor.Subscription)subscription).generation;
        Assertions.assertTrue((boolean)encodedGeneration.isPresent());
        Assertions.assertEquals((Integer)((Integer)encodedGeneration.get()), (int)generation);
    }

    @Test
    public void testDecodeGeneration() {
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(CooperativeStickyAssignorTest.topics(this.topic));
        Assertions.assertFalse((boolean)((CooperativeStickyAssignor)this.assignor).memberData((ConsumerPartitionAssignor.Subscription)subscription).generation.isPresent());
    }

    @Test
    public void testAllConsumersHaveOwnedPartitionInvalidatedWhenClaimedByMultipleConsumersInSameGenerationWithEqualPartitionsPerConsumer() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 3);
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(CooperativeStickyAssignorTest.topics(this.topic), CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic, 0), CooperativeStickyAssignorTest.tp(this.topic, 1)), this.generationId));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(CooperativeStickyAssignorTest.topics(this.topic), CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic, 0), CooperativeStickyAssignorTest.tp(this.topic, 2)), this.generationId));
        this.subscriptions.put(this.consumer3, this.buildSubscriptionV2Above(CooperativeStickyAssignorTest.topics(this.topic), Collections.emptyList(), this.generationId));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic, 1)), assignment.get(this.consumer1));
        Assertions.assertEquals(CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic, 2)), assignment.get(this.consumer2));
        Assertions.assertTrue((boolean)((List)assignment.get(this.consumer3)).isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)CooperativeStickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testAllConsumersHaveOwnedPartitionInvalidatedWhenClaimedByMultipleConsumersInSameGenerationWithUnequalPartitionsPerConsumer() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 4);
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(CooperativeStickyAssignorTest.topics(this.topic), CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic, 0), CooperativeStickyAssignorTest.tp(this.topic, 1)), this.generationId));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(CooperativeStickyAssignorTest.topics(this.topic), CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic, 0), CooperativeStickyAssignorTest.tp(this.topic, 2)), this.generationId));
        this.subscriptions.put(this.consumer3, this.buildSubscriptionV2Above(CooperativeStickyAssignorTest.topics(this.topic), Collections.emptyList(), this.generationId));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic, 1), CooperativeStickyAssignorTest.tp(this.topic, 3)), assignment.get(this.consumer1));
        Assertions.assertEquals(CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic, 2)), assignment.get(this.consumer2));
        Assertions.assertTrue((boolean)((List)assignment.get(this.consumer3)).isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)CooperativeStickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testMemberDataWithInconsistentData() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 2);
        List<TopicPartition> ownedPartitionsInUserdata = CooperativeStickyAssignorTest.partitions(this.tp1);
        List<TopicPartition> ownedPartitionsInSubscription = CooperativeStickyAssignorTest.partitions(this.tp0);
        this.assignor.onAssignment(new ConsumerPartitionAssignor.Assignment(ownedPartitionsInUserdata), new ConsumerGroupMetadata(this.groupId, this.generationId, this.consumer1, Optional.empty()));
        ByteBuffer userDataWithHigherGenerationId = this.assignor.subscriptionUserData(new HashSet<String>(CooperativeStickyAssignorTest.topics(this.topic)));
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(CooperativeStickyAssignorTest.topics(this.topic), userDataWithHigherGenerationId, ownedPartitionsInSubscription);
        AbstractStickyAssignor.MemberData memberData = this.memberData(subscription);
        Assertions.assertEquals(ownedPartitionsInSubscription, (Object)memberData.partitions, (String)("subscription: " + subscription + " doesn't have expected owned partition"));
        Assertions.assertEquals((int)this.generationId, (Integer)memberData.generation.orElse(-1), (String)("subscription: " + subscription + " doesn't have expected generation id"));
    }

    @Test
    public void testMemberDataWithEmptyPartitionsAndEqualGeneration() {
        List<String> topics = CooperativeStickyAssignorTest.topics(this.topic);
        List<TopicPartition> ownedPartitions = CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic1, 0), CooperativeStickyAssignorTest.tp(this.topic2, 1));
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(topics, this.generateUserData(topics, ownedPartitions, this.generationId), Collections.emptyList(), this.generationId, Optional.empty());
        AbstractStickyAssignor.MemberData memberData = this.memberData(subscription);
        Assertions.assertEquals(Collections.emptyList(), (Object)memberData.partitions, (String)("subscription: " + subscription + " doesn't have expected owned partition"));
        Assertions.assertEquals((int)this.generationId, (Integer)memberData.generation.orElse(-1), (String)("subscription: " + subscription + " doesn't have expected generation id"));
    }

    @Test
    public void testMemberDataWithEmptyPartitionsAndHigherGeneration() {
        List<String> topics = CooperativeStickyAssignorTest.topics(this.topic);
        List<TopicPartition> ownedPartitions = CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic1, 0), CooperativeStickyAssignorTest.tp(this.topic2, 1));
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(topics, this.generateUserData(topics, ownedPartitions, this.generationId - 1), Collections.emptyList(), this.generationId, Optional.empty());
        AbstractStickyAssignor.MemberData memberData = this.memberData(subscription);
        Assertions.assertEquals(Collections.emptyList(), (Object)memberData.partitions, (String)("subscription: " + subscription + " doesn't have expected owned partition"));
        Assertions.assertEquals((int)this.generationId, (Integer)memberData.generation.orElse(-1), (String)("subscription: " + subscription + " doesn't have expected generation id"));
    }

    @Test
    public void testAssignorWithOldVersionSubscriptions() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic1, 3);
        List<String> subscribedTopics = CooperativeStickyAssignorTest.topics(this.topic1);
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV1(subscribedTopics, CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic1, 0)), this.generationId));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV1(subscribedTopics, CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic1, 1)), this.generationId));
        this.subscriptions.put(this.consumer3, this.buildSubscriptionV2Above(subscribedTopics, Collections.emptyList(), this.generationId));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic1, 0)), assignment.get(this.consumer1));
        Assertions.assertEquals(CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic1, 1)), assignment.get(this.consumer2));
        Assertions.assertEquals(CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic1, 2)), assignment.get(this.consumer3));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)CooperativeStickyAssignorTest.isFullyBalanced(assignment));
    }

    @Override
    public void verifyValidityAndBalance(Map<String, ConsumerPartitionAssignor.Subscription> subscriptions, Map<String, List<TopicPartition>> assignments, Map<String, Integer> partitionsPerTopic) {
        int rebalances = 0;
        while (this.verifyCooperativeValidity(subscriptions, assignments)) {
            for (Map.Entry<String, List<TopicPartition>> entry : assignments.entrySet()) {
                String consumer = entry.getKey();
                ConsumerPartitionAssignor.Subscription oldSubscription = subscriptions.get(consumer);
                subscriptions.put(consumer, this.buildSubscriptionV2Above(oldSubscription.topics(), entry.getValue(), this.generationId));
            }
            assignments.clear();
            assignments.putAll(this.assignor.assign(partitionsPerTopic, subscriptions));
            Assertions.assertTrue((++rebalances <= 4 ? 1 : 0) != 0);
        }
        super.verifyValidityAndBalance(subscriptions, assignments, partitionsPerTopic);
    }

    private boolean verifyCooperativeValidity(Map<String, ConsumerPartitionAssignor.Subscription> subscriptions, Map<String, List<TopicPartition>> assignments) {
        HashSet<TopicPartition> allAddedPartitions = new HashSet<TopicPartition>();
        HashSet allRevokedPartitions = new HashSet();
        for (Map.Entry<String, List<TopicPartition>> entry : assignments.entrySet()) {
            List ownedPartitions = subscriptions.get(entry.getKey()).ownedPartitions();
            List<TopicPartition> assignedPartitions = entry.getValue();
            HashSet revokedPartitions = new HashSet(ownedPartitions);
            revokedPartitions.removeAll(assignedPartitions);
            HashSet<TopicPartition> addedPartitions = new HashSet<TopicPartition>(assignedPartitions);
            addedPartitions.removeAll(ownedPartitions);
            allAddedPartitions.addAll(addedPartitions);
            allRevokedPartitions.addAll(revokedPartitions);
        }
        HashSet intersection = new HashSet(allAddedPartitions);
        intersection.retainAll(allRevokedPartitions);
        Assertions.assertTrue((boolean)intersection.isEmpty(), (String)("Error: Some partitions were assigned to a new consumer during the same rebalance they are being revoked from their previous owner. Partitions: " + intersection));
        return !allRevokedPartitions.isEmpty();
    }
}

