/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginException;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.apache.kafka.common.security.auth.SaslExtensionsCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class OAuthBearerLoginModuleTest {
    public static final SaslExtensions RAISE_UNSUPPORTED_CB_EXCEPTION_FLAG = null;

    @Test
    public void login1Commit1Login2Commit2Logout1Login3Commit3Logout2() throws LoginException {
        Subject subject = new Subject();
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        Set<Object> publicCredentials = subject.getPublicCredentials();
        OAuthBearerToken[] tokens = new OAuthBearerToken[]{(OAuthBearerToken)Mockito.mock(OAuthBearerToken.class), (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class), (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class)};
        SaslExtensions[] extensions = new SaslExtensions[]{(SaslExtensions)Mockito.mock(SaslExtensions.class), (SaslExtensions)Mockito.mock(SaslExtensions.class), (SaslExtensions)Mockito.mock(SaslExtensions.class)};
        TestCallbackHandler testTokenCallbackHandler = new TestCallbackHandler(tokens, extensions);
        OAuthBearerLoginModule loginModule1 = new OAuthBearerLoginModule();
        loginModule1.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        OAuthBearerLoginModule loginModule2 = new OAuthBearerLoginModule();
        loginModule2.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        OAuthBearerLoginModule loginModule3 = new OAuthBearerLoginModule();
        loginModule3.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        Assertions.assertEquals((int)0, (int)privateCredentials.size());
        Assertions.assertEquals((int)0, (int)publicCredentials.size());
        loginModule1.login();
        Assertions.assertEquals((int)0, (int)privateCredentials.size());
        Assertions.assertEquals((int)0, (int)publicCredentials.size());
        loginModule1.commit();
        Assertions.assertEquals((int)1, (int)privateCredentials.size());
        Assertions.assertEquals((int)1, (int)publicCredentials.size());
        Assertions.assertSame((Object)tokens[0], (Object)privateCredentials.iterator().next());
        Assertions.assertSame((Object)extensions[0], (Object)publicCredentials.iterator().next());
        loginModule2.login();
        Assertions.assertEquals((int)1, (int)privateCredentials.size());
        Assertions.assertEquals((int)1, (int)publicCredentials.size());
        Assertions.assertSame((Object)tokens[0], (Object)privateCredentials.iterator().next());
        Assertions.assertSame((Object)extensions[0], (Object)publicCredentials.iterator().next());
        loginModule2.commit();
        Assertions.assertEquals((int)2, (int)privateCredentials.size());
        Assertions.assertEquals((int)2, (int)publicCredentials.size());
        Iterator<Object> iterator = privateCredentials.iterator();
        Iterator<Object> publicIterator = publicCredentials.iterator();
        Assertions.assertNotSame((Object)tokens[2], (Object)iterator.next());
        Assertions.assertNotSame((Object)tokens[2], (Object)iterator.next());
        Assertions.assertNotSame((Object)extensions[2], (Object)publicIterator.next());
        Assertions.assertNotSame((Object)extensions[2], (Object)publicIterator.next());
        loginModule1.logout();
        Assertions.assertEquals((int)1, (int)privateCredentials.size());
        Assertions.assertEquals((int)1, (int)publicCredentials.size());
        Assertions.assertSame((Object)tokens[1], (Object)privateCredentials.iterator().next());
        Assertions.assertSame((Object)extensions[1], (Object)publicCredentials.iterator().next());
        loginModule3.login();
        Assertions.assertEquals((int)1, (int)privateCredentials.size());
        Assertions.assertEquals((int)1, (int)publicCredentials.size());
        Assertions.assertSame((Object)tokens[1], (Object)privateCredentials.iterator().next());
        Assertions.assertSame((Object)extensions[1], (Object)publicCredentials.iterator().next());
        loginModule3.commit();
        Assertions.assertEquals((int)2, (int)privateCredentials.size());
        Assertions.assertEquals((int)2, (int)publicCredentials.size());
        iterator = privateCredentials.iterator();
        publicIterator = publicCredentials.iterator();
        Assertions.assertNotSame((Object)tokens[0], (Object)iterator.next());
        Assertions.assertNotSame((Object)tokens[0], (Object)iterator.next());
        Assertions.assertNotSame((Object)extensions[0], (Object)publicIterator.next());
        Assertions.assertNotSame((Object)extensions[0], (Object)publicIterator.next());
        loginModule2.logout();
        Assertions.assertEquals((int)1, (int)privateCredentials.size());
        Assertions.assertEquals((int)1, (int)publicCredentials.size());
        Assertions.assertSame((Object)tokens[2], (Object)privateCredentials.iterator().next());
        Assertions.assertSame((Object)extensions[2], (Object)publicCredentials.iterator().next());
        Mockito.verifyNoInteractions((Object[])tokens);
        Mockito.verifyNoInteractions((Object[])extensions);
    }

    @Test
    public void login1Commit1Logout1Login2Commit2Logout2() throws LoginException {
        Subject subject = new Subject();
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        Set<Object> publicCredentials = subject.getPublicCredentials();
        OAuthBearerToken[] tokens = new OAuthBearerToken[]{(OAuthBearerToken)Mockito.mock(OAuthBearerToken.class), (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class)};
        SaslExtensions[] extensions = new SaslExtensions[]{(SaslExtensions)Mockito.mock(SaslExtensions.class), (SaslExtensions)Mockito.mock(SaslExtensions.class)};
        TestCallbackHandler testTokenCallbackHandler = new TestCallbackHandler(tokens, extensions);
        OAuthBearerLoginModule loginModule1 = new OAuthBearerLoginModule();
        loginModule1.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        OAuthBearerLoginModule loginModule2 = new OAuthBearerLoginModule();
        loginModule2.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        Assertions.assertEquals((int)0, (int)privateCredentials.size());
        Assertions.assertEquals((int)0, (int)publicCredentials.size());
        loginModule1.login();
        Assertions.assertEquals((int)0, (int)privateCredentials.size());
        Assertions.assertEquals((int)0, (int)publicCredentials.size());
        loginModule1.commit();
        Assertions.assertEquals((int)1, (int)privateCredentials.size());
        Assertions.assertEquals((int)1, (int)publicCredentials.size());
        Assertions.assertSame((Object)tokens[0], (Object)privateCredentials.iterator().next());
        Assertions.assertSame((Object)extensions[0], (Object)publicCredentials.iterator().next());
        loginModule1.logout();
        Assertions.assertEquals((int)0, (int)privateCredentials.size());
        Assertions.assertEquals((int)0, (int)publicCredentials.size());
        loginModule2.login();
        Assertions.assertEquals((int)0, (int)privateCredentials.size());
        Assertions.assertEquals((int)0, (int)publicCredentials.size());
        loginModule2.commit();
        Assertions.assertEquals((int)1, (int)privateCredentials.size());
        Assertions.assertEquals((int)1, (int)publicCredentials.size());
        Assertions.assertSame((Object)tokens[1], (Object)privateCredentials.iterator().next());
        Assertions.assertSame((Object)extensions[1], (Object)publicCredentials.iterator().next());
        loginModule2.logout();
        Assertions.assertEquals((int)0, (int)privateCredentials.size());
        Assertions.assertEquals((int)0, (int)publicCredentials.size());
        Mockito.verifyNoInteractions((Object[])tokens);
        Mockito.verifyNoInteractions((Object[])extensions);
    }

    @Test
    public void loginAbortLoginCommitLogout() throws LoginException {
        Subject subject = new Subject();
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        Set<Object> publicCredentials = subject.getPublicCredentials();
        OAuthBearerToken[] tokens = new OAuthBearerToken[]{(OAuthBearerToken)Mockito.mock(OAuthBearerToken.class), (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class)};
        SaslExtensions[] extensions = new SaslExtensions[]{(SaslExtensions)Mockito.mock(SaslExtensions.class), (SaslExtensions)Mockito.mock(SaslExtensions.class)};
        TestCallbackHandler testTokenCallbackHandler = new TestCallbackHandler(tokens, extensions);
        OAuthBearerLoginModule loginModule = new OAuthBearerLoginModule();
        loginModule.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        Assertions.assertEquals((int)0, (int)privateCredentials.size());
        Assertions.assertEquals((int)0, (int)publicCredentials.size());
        loginModule.login();
        Assertions.assertEquals((int)0, (int)privateCredentials.size());
        Assertions.assertEquals((int)0, (int)publicCredentials.size());
        loginModule.abort();
        Assertions.assertEquals((int)0, (int)privateCredentials.size());
        Assertions.assertEquals((int)0, (int)publicCredentials.size());
        loginModule.login();
        Assertions.assertEquals((int)0, (int)privateCredentials.size());
        Assertions.assertEquals((int)0, (int)publicCredentials.size());
        loginModule.commit();
        Assertions.assertEquals((int)1, (int)privateCredentials.size());
        Assertions.assertEquals((int)1, (int)publicCredentials.size());
        Assertions.assertSame((Object)tokens[1], (Object)privateCredentials.iterator().next());
        Assertions.assertSame((Object)extensions[1], (Object)publicCredentials.iterator().next());
        loginModule.logout();
        Assertions.assertEquals((int)0, (int)privateCredentials.size());
        Assertions.assertEquals((int)0, (int)publicCredentials.size());
        Mockito.verifyNoInteractions((Object[])tokens);
        Mockito.verifyNoInteractions((Object[])extensions);
    }

    @Test
    public void login1Commit1Login2Abort2Login3Commit3Logout3() throws LoginException {
        Subject subject = new Subject();
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        Set<Object> publicCredentials = subject.getPublicCredentials();
        OAuthBearerToken[] tokens = new OAuthBearerToken[]{(OAuthBearerToken)Mockito.mock(OAuthBearerToken.class), (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class), (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class)};
        SaslExtensions[] extensions = new SaslExtensions[]{(SaslExtensions)Mockito.mock(SaslExtensions.class), (SaslExtensions)Mockito.mock(SaslExtensions.class), (SaslExtensions)Mockito.mock(SaslExtensions.class)};
        TestCallbackHandler testTokenCallbackHandler = new TestCallbackHandler(tokens, extensions);
        OAuthBearerLoginModule loginModule1 = new OAuthBearerLoginModule();
        loginModule1.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        OAuthBearerLoginModule loginModule2 = new OAuthBearerLoginModule();
        loginModule2.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        OAuthBearerLoginModule loginModule3 = new OAuthBearerLoginModule();
        loginModule3.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        Assertions.assertEquals((int)0, (int)privateCredentials.size());
        Assertions.assertEquals((int)0, (int)publicCredentials.size());
        loginModule1.login();
        Assertions.assertEquals((int)0, (int)privateCredentials.size());
        Assertions.assertEquals((int)0, (int)publicCredentials.size());
        loginModule1.commit();
        Assertions.assertEquals((int)1, (int)privateCredentials.size());
        Assertions.assertEquals((int)1, (int)publicCredentials.size());
        Assertions.assertSame((Object)tokens[0], (Object)privateCredentials.iterator().next());
        Assertions.assertSame((Object)extensions[0], (Object)publicCredentials.iterator().next());
        loginModule2.login();
        Assertions.assertEquals((int)1, (int)privateCredentials.size());
        Assertions.assertEquals((int)1, (int)publicCredentials.size());
        Assertions.assertSame((Object)tokens[0], (Object)privateCredentials.iterator().next());
        Assertions.assertSame((Object)extensions[0], (Object)publicCredentials.iterator().next());
        loginModule2.abort();
        Assertions.assertEquals((int)1, (int)privateCredentials.size());
        Assertions.assertSame((Object)tokens[0], (Object)privateCredentials.iterator().next());
        Assertions.assertEquals((int)1, (int)publicCredentials.size());
        Assertions.assertSame((Object)extensions[0], (Object)publicCredentials.iterator().next());
        loginModule2.login();
        Assertions.assertEquals((int)1, (int)privateCredentials.size());
        Assertions.assertSame((Object)tokens[0], (Object)privateCredentials.iterator().next());
        Assertions.assertEquals((int)1, (int)publicCredentials.size());
        Assertions.assertSame((Object)extensions[0], (Object)publicCredentials.iterator().next());
        loginModule2.commit();
        Assertions.assertEquals((int)2, (int)privateCredentials.size());
        Iterator<Object> iterator = privateCredentials.iterator();
        Assertions.assertNotSame((Object)tokens[1], (Object)iterator.next());
        Assertions.assertNotSame((Object)tokens[1], (Object)iterator.next());
        Assertions.assertEquals((int)2, (int)publicCredentials.size());
        Iterator<Object> publicIterator = publicCredentials.iterator();
        Assertions.assertNotSame((Object)extensions[1], (Object)publicIterator.next());
        Assertions.assertNotSame((Object)extensions[1], (Object)publicIterator.next());
        loginModule1.logout();
        Assertions.assertEquals((int)1, (int)privateCredentials.size());
        Assertions.assertSame((Object)tokens[2], (Object)privateCredentials.iterator().next());
        Assertions.assertEquals((int)1, (int)publicCredentials.size());
        Assertions.assertSame((Object)extensions[2], (Object)publicCredentials.iterator().next());
        Mockito.verifyNoInteractions((Object[])tokens);
        Mockito.verifyNoInteractions((Object[])extensions);
    }

    @Test
    public void commitDoesNotThrowOnUnsupportedExtensionsCallback() throws LoginException {
        Subject subject = new Subject();
        OAuthBearerToken[] tokens = new OAuthBearerToken[]{(OAuthBearerToken)Mockito.mock(OAuthBearerToken.class), (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class), (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class)};
        TestCallbackHandler testTokenCallbackHandler = new TestCallbackHandler(tokens, new SaslExtensions[]{RAISE_UNSUPPORTED_CB_EXCEPTION_FLAG});
        OAuthBearerLoginModule loginModule1 = new OAuthBearerLoginModule();
        loginModule1.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        loginModule1.login();
        loginModule1.commit();
        SaslExtensions extensions = subject.getPublicCredentials(SaslExtensions.class).iterator().next();
        Assertions.assertNotNull((Object)extensions);
        Assertions.assertTrue((boolean)extensions.map().isEmpty());
        Mockito.verifyNoInteractions((Object[])tokens);
    }

    private static class TestCallbackHandler
    implements AuthenticateCallbackHandler {
        private final OAuthBearerToken[] tokens;
        private int index = 0;
        private int extensionsIndex = 0;
        private final SaslExtensions[] extensions;

        public TestCallbackHandler(OAuthBearerToken[] tokens, SaslExtensions[] extensions) {
            this.tokens = Objects.requireNonNull(tokens);
            this.extensions = extensions;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof OAuthBearerTokenCallback) {
                    try {
                        this.handleCallback((OAuthBearerTokenCallback)callback);
                        continue;
                    }
                    catch (KafkaException e) {
                        throw new IOException(e.getMessage(), e);
                    }
                }
                if (callback instanceof SaslExtensionsCallback) {
                    try {
                        this.handleExtensionsCallback((SaslExtensionsCallback)callback);
                        continue;
                    }
                    catch (KafkaException e) {
                        throw new IOException(e.getMessage(), e);
                    }
                }
                throw new UnsupportedCallbackException(callback);
            }
        }

        public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        }

        public void close() {
        }

        private void handleCallback(OAuthBearerTokenCallback callback) throws IOException {
            if (callback.token() != null) {
                throw new IllegalArgumentException("Callback had a token already");
            }
            if (this.tokens.length <= this.index) {
                throw new IOException("no more tokens");
            }
            callback.token(this.tokens[this.index++]);
        }

        private void handleExtensionsCallback(SaslExtensionsCallback callback) throws IOException, UnsupportedCallbackException {
            SaslExtensions extension;
            if (this.extensions.length > this.extensionsIndex) {
                if ((extension = this.extensions[this.extensionsIndex++]) == RAISE_UNSUPPORTED_CB_EXCEPTION_FLAG) {
                    throw new UnsupportedCallbackException((Callback)callback);
                }
            } else {
                throw new IOException("no more extensions");
            }
            callback.extensions(extension);
        }
    }
}

