/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CommonClientConfigsTest {
    @Test
    public void testExponentialBackoffDefaults() {
        TestConfig defaultConf = new TestConfig(Collections.emptyMap());
        Assertions.assertEquals((Long)50L, (Long)defaultConf.getLong("reconnect.backoff.ms"));
        Assertions.assertEquals((Long)1000L, (Long)defaultConf.getLong("reconnect.backoff.max.ms"));
        TestConfig bothSetConfig = new TestConfig(new HashMap<String, Object>(){
            {
                this.put("reconnect.backoff.ms", "123");
                this.put("reconnect.backoff.max.ms", "12345");
            }
        });
        Assertions.assertEquals((Long)123L, (Long)bothSetConfig.getLong("reconnect.backoff.ms"));
        Assertions.assertEquals((Long)12345L, (Long)bothSetConfig.getLong("reconnect.backoff.max.ms"));
        TestConfig reconnectBackoffSetConf = new TestConfig(new HashMap<String, Object>(){
            {
                this.put("reconnect.backoff.ms", "123");
            }
        });
        Assertions.assertEquals((Long)123L, (Long)reconnectBackoffSetConf.getLong("reconnect.backoff.ms"));
        Assertions.assertEquals((Long)123L, (Long)reconnectBackoffSetConf.getLong("reconnect.backoff.max.ms"));
    }

    private static class TestConfig
    extends AbstractConfig {
        private static final ConfigDef CONFIG = new ConfigDef().define("reconnect.backoff.ms", ConfigDef.Type.LONG, (Object)50L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, "").define("reconnect.backoff.max.ms", ConfigDef.Type.LONG, (Object)1000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, "");

        protected Map<String, Object> postProcessParsedConfig(Map<String, Object> parsedValues) {
            return CommonClientConfigs.postProcessReconnectBackoffConfigs((AbstractConfig)this, parsedValues);
        }

        public TestConfig(Map<?, ?> props) {
            super(CONFIG, props);
        }
    }
}

