/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.ConvertedRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;

public class RecordsUtil {
    protected static ConvertedRecords<MemoryRecords> downConvert(Iterable<? extends RecordBatch> batches, byte toMagic, long firstOffset, Time time) {
        ArrayList<RecordBatchAndRecords> recordBatchAndRecordsList = new ArrayList<RecordBatchAndRecords>();
        int totalSizeEstimate = 0;
        long startNanos = time.nanoseconds();
        for (RecordBatch recordBatch : batches) {
            if (toMagic < 2 && recordBatch.isControlBatch()) continue;
            if (recordBatch.magic() <= toMagic) {
                totalSizeEstimate += recordBatch.sizeInBytes();
                recordBatchAndRecordsList.add(new RecordBatchAndRecords(recordBatch, null, null));
                continue;
            }
            ArrayList<Record> records = new ArrayList<Record>();
            for (Object record : recordBatch) {
                if (toMagic <= 1 && !recordBatch.isCompressed() && record.offset() < firstOffset) continue;
                records.add((Record)record);
            }
            if (records.isEmpty()) continue;
            long baseOffset = recordBatch.magic() >= 2 && toMagic >= 2 ? recordBatch.baseOffset() : ((Record)records.get(0)).offset();
            totalSizeEstimate += AbstractRecords.estimateSizeInBytes(toMagic, baseOffset, recordBatch.compressionType(), records);
            recordBatchAndRecordsList.add(new RecordBatchAndRecords(recordBatch, records, baseOffset));
        }
        ByteBuffer buffer = ByteBuffer.allocate(totalSizeEstimate);
        long l = 0L;
        int numRecordsConverted = 0;
        for (RecordBatchAndRecords recordBatchAndRecords : recordBatchAndRecordsList) {
            l += (long)recordBatchAndRecords.batch.sizeInBytes();
            if (recordBatchAndRecords.batch.magic() <= toMagic) {
                recordBatchAndRecords.batch.writeTo(buffer);
                continue;
            }
            MemoryRecordsBuilder builder = RecordsUtil.convertRecordBatch(toMagic, buffer, recordBatchAndRecords);
            buffer = builder.buffer();
            l += (long)builder.uncompressedBytesWritten();
            numRecordsConverted += builder.numRecords();
        }
        buffer.flip();
        RecordConversionStats stats = new RecordConversionStats(l, numRecordsConverted, time.nanoseconds() - startNanos);
        return new ConvertedRecords<MemoryRecords>(MemoryRecords.readableRecords(buffer), stats);
    }

    private static MemoryRecordsBuilder convertRecordBatch(byte magic, ByteBuffer buffer, RecordBatchAndRecords recordBatchAndRecords) {
        RecordBatch batch = recordBatchAndRecords.batch;
        TimestampType timestampType = batch.timestampType();
        long logAppendTime = timestampType == TimestampType.LOG_APPEND_TIME ? batch.maxTimestamp() : -1L;
        MemoryRecordsBuilder builder = MemoryRecords.builder(buffer, magic, batch.compressionType(), timestampType, recordBatchAndRecords.baseOffset, logAppendTime);
        for (Record record : recordBatchAndRecords.records) {
            if (magic > 1) {
                builder.append(record);
                continue;
            }
            builder.appendWithOffset(record.offset(), record.timestamp(), record.key(), record.value());
        }
        builder.close();
        return builder;
    }

    private static class RecordBatchAndRecords {
        private final RecordBatch batch;
        private final List<Record> records;
        private final Long baseOffset;

        private RecordBatchAndRecords(RecordBatch batch, List<Record> records, Long baseOffset) {
            this.batch = batch;
            this.records = records;
            this.baseOffset = baseOffset;
        }
    }
}

