/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MemoryRecordsTest {
    private CompressionType compression;
    private byte magic;
    private long firstOffset;
    private long pid;
    private short epoch;
    private int firstSequence;
    private long logAppendTime = System.currentTimeMillis();
    private int partitionLeaderEpoch = 998;

    public MemoryRecordsTest(byte magic, long firstOffset, CompressionType compression) {
        this.magic = magic;
        this.compression = compression;
        this.firstOffset = firstOffset;
        if (magic >= 2) {
            this.pid = 134234L;
            this.epoch = (short)28;
            this.firstSequence = 777;
        } else {
            this.pid = -1L;
            this.epoch = (short)-1;
            this.firstSequence = -1;
        }
    }

    @Test
    public void testIterator() {
        SimpleRecord[] records;
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, this.magic, this.compression, TimestampType.CREATE_TIME, this.firstOffset, this.logAppendTime, this.pid, this.epoch, this.firstSequence, false, false, this.partitionLeaderEpoch, buffer.limit());
        for (SimpleRecord record : records = new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes()), new SimpleRecord(4L, null, "4".getBytes()), new SimpleRecord(5L, "d".getBytes(), null), new SimpleRecord(6L, (byte[])null, null)}) {
            builder.append(record);
        }
        MemoryRecords memoryRecords = builder.build();
        for (int iteration = 0; iteration < 2; ++iteration) {
            int total = 0;
            for (RecordBatch batch : memoryRecords.batches()) {
                Assert.assertTrue((boolean)batch.isValid());
                Assert.assertEquals((Object)this.compression, (Object)batch.compressionType());
                Assert.assertEquals((long)(this.firstOffset + (long)total), (long)batch.baseOffset());
                if (this.magic >= 2) {
                    Assert.assertEquals((long)this.pid, (long)batch.producerId());
                    Assert.assertEquals((long)this.epoch, (long)batch.producerEpoch());
                    Assert.assertEquals((long)(this.firstSequence + total), (long)batch.baseSequence());
                    Assert.assertEquals((long)this.partitionLeaderEpoch, (long)batch.partitionLeaderEpoch());
                    Assert.assertEquals((long)records.length, (long)batch.countOrNull().intValue());
                    Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
                    Assert.assertEquals((long)records[records.length - 1].timestamp(), (long)batch.maxTimestamp());
                } else {
                    Assert.assertEquals((long)-1L, (long)batch.producerId());
                    Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
                    Assert.assertEquals((long)-1L, (long)batch.baseSequence());
                    Assert.assertEquals((long)-1L, (long)batch.partitionLeaderEpoch());
                    Assert.assertNull((Object)batch.countOrNull());
                    if (this.magic == 0) {
                        Assert.assertEquals((Object)TimestampType.NO_TIMESTAMP_TYPE, (Object)batch.timestampType());
                    } else {
                        Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
                    }
                }
                int recordCount = 0;
                for (Record record : batch) {
                    Assert.assertTrue((boolean)record.isValid());
                    Assert.assertTrue((boolean)record.hasMagic(batch.magic()));
                    Assert.assertFalse((boolean)record.isCompressed());
                    Assert.assertEquals((long)(this.firstOffset + (long)total), (long)record.offset());
                    Assert.assertEquals((Object)records[total].key(), (Object)record.key());
                    Assert.assertEquals((Object)records[total].value(), (Object)record.value());
                    if (this.magic >= 2) {
                        Assert.assertEquals((long)(this.firstSequence + total), (long)record.sequence());
                    }
                    Assert.assertFalse((boolean)record.hasTimestampType(TimestampType.LOG_APPEND_TIME));
                    if (this.magic == 0) {
                        Assert.assertEquals((long)-1L, (long)record.timestamp());
                        Assert.assertFalse((boolean)record.hasTimestampType(TimestampType.CREATE_TIME));
                        Assert.assertTrue((boolean)record.hasTimestampType(TimestampType.NO_TIMESTAMP_TYPE));
                    } else {
                        Assert.assertEquals((long)records[total].timestamp(), (long)record.timestamp());
                        Assert.assertFalse((boolean)record.hasTimestampType(TimestampType.NO_TIMESTAMP_TYPE));
                        if (this.magic < 2) {
                            Assert.assertTrue((boolean)record.hasTimestampType(TimestampType.CREATE_TIME));
                        } else {
                            Assert.assertFalse((boolean)record.hasTimestampType(TimestampType.CREATE_TIME));
                        }
                    }
                    ++total;
                    ++recordCount;
                }
                Assert.assertEquals((long)(batch.baseOffset() + (long)recordCount - 1L), (long)batch.lastOffset());
            }
        }
    }

    @Test
    public void testHasRoomForMethod() {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(0L, "a".getBytes(), "1".getBytes());
        Assert.assertTrue((boolean)builder.hasRoomFor(1L, "b".getBytes(), "2".getBytes(), Record.EMPTY_HEADERS));
        builder.close();
        Assert.assertFalse((boolean)builder.hasRoomFor(1L, "b".getBytes(), "2".getBytes(), Record.EMPTY_HEADERS));
    }

    @Test
    public void testHasRoomForMethodWithHeaders() {
        if (this.magic >= 2) {
            MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(100), (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
            RecordHeaders headers = new RecordHeaders();
            headers.add("hello", "world.world".getBytes());
            headers.add("hello", "world.world".getBytes());
            headers.add("hello", "world.world".getBytes());
            headers.add("hello", "world.world".getBytes());
            headers.add("hello", "world.world".getBytes());
            builder.append(this.logAppendTime, "key".getBytes(), "value".getBytes());
            Assert.assertTrue((boolean)builder.hasRoomFor(this.logAppendTime, "key".getBytes(), "value".getBytes(), Record.EMPTY_HEADERS));
            Assert.assertFalse((boolean)builder.hasRoomFor(this.logAppendTime, "key".getBytes(), "value".getBytes(), headers.toArray()));
        }
    }

    @Test
    public void testChecksum() {
        if (this.compression != CompressionType.NONE && this.compression != CompressionType.LZ4) {
            return;
        }
        SimpleRecord[] records = new SimpleRecord[]{new SimpleRecord(283843L, "key1".getBytes(), "value1".getBytes()), new SimpleRecord(1234L, "key2".getBytes(), "value2".getBytes())};
        RecordBatch batch = (RecordBatch)MemoryRecords.withRecords((byte)this.magic, (CompressionType)this.compression, (SimpleRecord[])records).batches().iterator().next();
        long expectedChecksum = this.magic == 0 ? (this.compression == CompressionType.NONE ? 1978725405L : 66944826L) : (this.magic == 1 ? (this.compression == CompressionType.NONE ? 109425508L : 1407303399L) : (this.compression == CompressionType.NONE ? 3851219455L : 2745969314L));
        Assert.assertEquals((String)("Unexpected checksum for magic " + this.magic + " and compression type " + this.compression), (long)expectedChecksum, (long)batch.checksum());
    }

    @Test
    public void testFilterToPreservesPartitionLeaderEpoch() {
        if (this.magic >= 2) {
            int partitionLeaderEpoch = 67;
            ByteBuffer buffer = ByteBuffer.allocate(2048);
            MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)0L, (long)-1L, (int)partitionLeaderEpoch);
            builder.append(10L, null, "a".getBytes());
            builder.append(11L, "1".getBytes(), "b".getBytes());
            builder.append(12L, null, "c".getBytes());
            ByteBuffer filtered = ByteBuffer.allocate(2048);
            builder.build().filterTo(new TopicPartition("foo", 0), (MemoryRecords.RecordFilter)new RetainNonNullKeysFilter(), filtered, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
            filtered.flip();
            MemoryRecords filteredRecords = MemoryRecords.readableRecords((ByteBuffer)filtered);
            List batches = TestUtils.toList(filteredRecords.batches());
            Assert.assertEquals((long)1L, (long)batches.size());
            MutableRecordBatch firstBatch = (MutableRecordBatch)batches.get(0);
            Assert.assertEquals((long)partitionLeaderEpoch, (long)firstBatch.partitionLeaderEpoch());
        }
    }

    @Test
    public void testFilterToEmptyBatchRetention() {
        if (this.magic >= 2) {
            for (boolean isTransactional : Arrays.asList(true, false)) {
                ByteBuffer buffer = ByteBuffer.allocate(2048);
                long producerId = 23L;
                short producerEpoch = 5;
                long baseOffset = 3L;
                int baseSequence = 10;
                int partitionLeaderEpoch = 293;
                MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)baseOffset, (long)-1L, (long)producerId, (short)producerEpoch, (int)baseSequence, (boolean)isTransactional, (int)partitionLeaderEpoch);
                builder.append(11L, "2".getBytes(), "b".getBytes());
                builder.append(12L, "3".getBytes(), "c".getBytes());
                builder.close();
                ByteBuffer filtered = ByteBuffer.allocate(2048);
                builder.build().filterTo(new TopicPartition("foo", 0), new MemoryRecords.RecordFilter(){

                    protected MemoryRecords.RecordFilter.BatchRetention checkBatchRetention(RecordBatch batch) {
                        return MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY;
                    }

                    protected boolean shouldRetainRecord(RecordBatch recordBatch, Record record) {
                        return false;
                    }
                }, filtered, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
                filtered.flip();
                MemoryRecords filteredRecords = MemoryRecords.readableRecords((ByteBuffer)filtered);
                List batches = TestUtils.toList(filteredRecords.batches());
                Assert.assertEquals((long)1L, (long)batches.size());
                MutableRecordBatch batch = (MutableRecordBatch)batches.get(0);
                Assert.assertEquals((long)0L, (long)batch.countOrNull().intValue());
                Assert.assertEquals((long)12L, (long)batch.maxTimestamp());
                Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
                Assert.assertEquals((long)baseOffset, (long)batch.baseOffset());
                Assert.assertEquals((long)(baseOffset + 1L), (long)batch.lastOffset());
                Assert.assertEquals((long)baseSequence, (long)batch.baseSequence());
                Assert.assertEquals((long)(baseSequence + 1), (long)batch.lastSequence());
                Assert.assertEquals((Object)isTransactional, (Object)batch.isTransactional());
            }
        }
    }

    @Test
    public void testEmptyBatchDeletion() {
        if (this.magic >= 2) {
            for (final MemoryRecords.RecordFilter.BatchRetention deleteRetention : Arrays.asList(MemoryRecords.RecordFilter.BatchRetention.DELETE, MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY)) {
                ByteBuffer buffer = ByteBuffer.allocate(61);
                long producerId = 23L;
                short producerEpoch = 5;
                long baseOffset = 3L;
                int baseSequence = 10;
                int partitionLeaderEpoch = 293;
                DefaultRecordBatch.writeEmptyHeader((ByteBuffer)buffer, (byte)2, (long)producerId, (short)producerEpoch, (int)baseSequence, (long)baseOffset, (long)baseOffset, (int)partitionLeaderEpoch, (TimestampType)TimestampType.CREATE_TIME, (long)System.currentTimeMillis(), (boolean)false, (boolean)false);
                buffer.flip();
                ByteBuffer filtered = ByteBuffer.allocate(2048);
                MemoryRecords.readableRecords((ByteBuffer)buffer).filterTo(new TopicPartition("foo", 0), new MemoryRecords.RecordFilter(){

                    protected MemoryRecords.RecordFilter.BatchRetention checkBatchRetention(RecordBatch batch) {
                        return deleteRetention;
                    }

                    protected boolean shouldRetainRecord(RecordBatch recordBatch, Record record) {
                        return false;
                    }
                }, filtered, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
                filtered.flip();
                MemoryRecords filteredRecords = MemoryRecords.readableRecords((ByteBuffer)filtered);
                Assert.assertEquals((long)0L, (long)filteredRecords.sizeInBytes());
            }
        }
    }

    @Test
    public void testBuildEndTxnMarker() {
        if (this.magic >= 2) {
            long producerId = 73L;
            short producerEpoch = 13;
            long initialOffset = 983L;
            int coordinatorEpoch = 347;
            int partitionLeaderEpoch = 29;
            EndTransactionMarker marker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
            MemoryRecords records = MemoryRecords.withEndTransactionMarker((long)initialOffset, (long)System.currentTimeMillis(), (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)marker);
            Assert.assertEquals((long)records.buffer().remaining(), (long)records.buffer().capacity());
            List batches = TestUtils.toList(records.batches());
            Assert.assertEquals((long)1L, (long)batches.size());
            RecordBatch batch = (RecordBatch)batches.get(0);
            Assert.assertTrue((boolean)batch.isControlBatch());
            Assert.assertEquals((long)producerId, (long)batch.producerId());
            Assert.assertEquals((long)producerEpoch, (long)batch.producerEpoch());
            Assert.assertEquals((long)initialOffset, (long)batch.baseOffset());
            Assert.assertEquals((long)partitionLeaderEpoch, (long)batch.partitionLeaderEpoch());
            Assert.assertTrue((boolean)batch.isValid());
            List createdRecords = TestUtils.toList(batch);
            Assert.assertEquals((long)1L, (long)createdRecords.size());
            Record record = (Record)createdRecords.get(0);
            Assert.assertTrue((boolean)record.isValid());
            EndTransactionMarker deserializedMarker = EndTransactionMarker.deserialize((Record)record);
            Assert.assertEquals((Object)ControlRecordType.COMMIT, (Object)deserializedMarker.controlType());
            Assert.assertEquals((long)coordinatorEpoch, (long)deserializedMarker.coordinatorEpoch());
        }
    }

    @Test
    public void testFilterToBatchDiscard() {
        if (this.compression != CompressionType.NONE || this.magic >= 2) {
            ByteBuffer buffer = ByteBuffer.allocate(2048);
            MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
            builder.append(10L, "1".getBytes(), "a".getBytes());
            builder.close();
            builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
            builder.append(11L, "2".getBytes(), "b".getBytes());
            builder.append(12L, "3".getBytes(), "c".getBytes());
            builder.close();
            builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)3L);
            builder.append(13L, "4".getBytes(), "d".getBytes());
            builder.append(20L, "5".getBytes(), "e".getBytes());
            builder.append(15L, "6".getBytes(), "f".getBytes());
            builder.close();
            builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)6L);
            builder.append(16L, "7".getBytes(), "g".getBytes());
            builder.close();
            buffer.flip();
            ByteBuffer filtered = ByteBuffer.allocate(2048);
            MemoryRecords.readableRecords((ByteBuffer)buffer).filterTo(new TopicPartition("foo", 0), new MemoryRecords.RecordFilter(){

                protected MemoryRecords.RecordFilter.BatchRetention checkBatchRetention(RecordBatch batch) {
                    if (batch.lastOffset() == 2L || batch.lastOffset() == 6L) {
                        return MemoryRecords.RecordFilter.BatchRetention.DELETE;
                    }
                    return MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY;
                }

                protected boolean shouldRetainRecord(RecordBatch recordBatch, Record record) {
                    return true;
                }
            }, filtered, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
            filtered.flip();
            MemoryRecords filteredRecords = MemoryRecords.readableRecords((ByteBuffer)filtered);
            List batches = TestUtils.toList(filteredRecords.batches());
            Assert.assertEquals((long)2L, (long)batches.size());
            Assert.assertEquals((long)0L, (long)((MutableRecordBatch)batches.get(0)).lastOffset());
            Assert.assertEquals((long)5L, (long)((MutableRecordBatch)batches.get(1)).lastOffset());
        }
    }

    @Test
    public void testFilterToAlreadyCompactedLog() {
        ByteBuffer buffer = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(5L, 10L, null, "a".getBytes());
        builder.appendWithOffset(8L, 11L, "1".getBytes(), "b".getBytes());
        builder.appendWithOffset(10L, 12L, null, "c".getBytes());
        builder.close();
        buffer.flip();
        ByteBuffer filtered = ByteBuffer.allocate(2048);
        MemoryRecords.readableRecords((ByteBuffer)buffer).filterTo(new TopicPartition("foo", 0), (MemoryRecords.RecordFilter)new RetainNonNullKeysFilter(), filtered, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
        filtered.flip();
        MemoryRecords filteredRecords = MemoryRecords.readableRecords((ByteBuffer)filtered);
        List batches = TestUtils.toList(filteredRecords.batches());
        Assert.assertEquals((long)1L, (long)batches.size());
        MutableRecordBatch batch = (MutableRecordBatch)batches.get(0);
        List records = TestUtils.toList(batch);
        Assert.assertEquals((long)1L, (long)records.size());
        Assert.assertEquals((long)8L, (long)((Record)records.get(0)).offset());
        if (this.magic >= 1) {
            Assert.assertEquals((Object)new SimpleRecord(11L, "1".getBytes(), "b".getBytes()), (Object)new SimpleRecord((Record)records.get(0)));
        } else {
            Assert.assertEquals((Object)new SimpleRecord(-1L, "1".getBytes(), "b".getBytes()), (Object)new SimpleRecord((Record)records.get(0)));
        }
        if (this.magic >= 2) {
            Assert.assertEquals((long)0L, (long)batch.baseOffset());
            Assert.assertEquals((long)10L, (long)batch.lastOffset());
        } else {
            Assert.assertEquals((long)8L, (long)batch.baseOffset());
            Assert.assertEquals((long)8L, (long)batch.lastOffset());
        }
    }

    @Test
    public void testFilterToPreservesProducerInfo() {
        if (this.magic >= 2) {
            ByteBuffer buffer = ByteBuffer.allocate(2048);
            MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
            builder.append(10L, null, "a".getBytes());
            builder.append(11L, "1".getBytes(), "b".getBytes());
            builder.append(12L, null, "c".getBytes());
            builder.close();
            long pid1 = 23L;
            short epoch1 = 5;
            int baseSequence1 = 10;
            builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)3L, (long)-1L, (long)pid1, (short)epoch1, (int)baseSequence1);
            builder.append(13L, null, "d".getBytes());
            builder.append(14L, "4".getBytes(), "e".getBytes());
            builder.append(15L, "5".getBytes(), "f".getBytes());
            builder.close();
            long pid2 = 99384L;
            short epoch2 = 234;
            int baseSequence2 = 15;
            builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)3L, (long)-1L, (long)pid2, (short)epoch2, (int)baseSequence2, (boolean)true, (int)-1);
            builder.append(16L, "6".getBytes(), "g".getBytes());
            builder.append(17L, "7".getBytes(), "h".getBytes());
            builder.append(18L, null, "i".getBytes());
            builder.close();
            buffer.flip();
            ByteBuffer filtered = ByteBuffer.allocate(2048);
            MemoryRecords.readableRecords((ByteBuffer)buffer).filterTo(new TopicPartition("foo", 0), (MemoryRecords.RecordFilter)new RetainNonNullKeysFilter(), filtered, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
            filtered.flip();
            MemoryRecords filteredRecords = MemoryRecords.readableRecords((ByteBuffer)filtered);
            List batches = TestUtils.toList(filteredRecords.batches());
            Assert.assertEquals((long)3L, (long)batches.size());
            MutableRecordBatch firstBatch = (MutableRecordBatch)batches.get(0);
            Assert.assertEquals((long)1L, (long)firstBatch.countOrNull().intValue());
            Assert.assertEquals((long)0L, (long)firstBatch.baseOffset());
            Assert.assertEquals((long)2L, (long)firstBatch.lastOffset());
            Assert.assertEquals((long)-1L, (long)firstBatch.producerId());
            Assert.assertEquals((long)-1L, (long)firstBatch.producerEpoch());
            Assert.assertEquals((long)-1L, (long)firstBatch.baseSequence());
            Assert.assertEquals((long)-1L, (long)firstBatch.lastSequence());
            Assert.assertFalse((boolean)firstBatch.isTransactional());
            List firstBatchRecords = TestUtils.toList(firstBatch);
            Assert.assertEquals((long)1L, (long)firstBatchRecords.size());
            Assert.assertEquals((long)-1L, (long)((Record)firstBatchRecords.get(0)).sequence());
            Assert.assertEquals((Object)new SimpleRecord(11L, "1".getBytes(), "b".getBytes()), (Object)new SimpleRecord((Record)firstBatchRecords.get(0)));
            MutableRecordBatch secondBatch = (MutableRecordBatch)batches.get(1);
            Assert.assertEquals((long)2L, (long)secondBatch.countOrNull().intValue());
            Assert.assertEquals((long)3L, (long)secondBatch.baseOffset());
            Assert.assertEquals((long)5L, (long)secondBatch.lastOffset());
            Assert.assertEquals((long)pid1, (long)secondBatch.producerId());
            Assert.assertEquals((long)epoch1, (long)secondBatch.producerEpoch());
            Assert.assertEquals((long)baseSequence1, (long)secondBatch.baseSequence());
            Assert.assertEquals((long)(baseSequence1 + 2), (long)secondBatch.lastSequence());
            Assert.assertFalse((boolean)secondBatch.isTransactional());
            List secondBatchRecords = TestUtils.toList(secondBatch);
            Assert.assertEquals((long)2L, (long)secondBatchRecords.size());
            Assert.assertEquals((long)(baseSequence1 + 1), (long)((Record)secondBatchRecords.get(0)).sequence());
            Assert.assertEquals((Object)new SimpleRecord(14L, "4".getBytes(), "e".getBytes()), (Object)new SimpleRecord((Record)secondBatchRecords.get(0)));
            Assert.assertEquals((long)(baseSequence1 + 2), (long)((Record)secondBatchRecords.get(1)).sequence());
            Assert.assertEquals((Object)new SimpleRecord(15L, "5".getBytes(), "f".getBytes()), (Object)new SimpleRecord((Record)secondBatchRecords.get(1)));
            MutableRecordBatch thirdBatch = (MutableRecordBatch)batches.get(2);
            Assert.assertEquals((long)2L, (long)thirdBatch.countOrNull().intValue());
            Assert.assertEquals((long)3L, (long)thirdBatch.baseOffset());
            Assert.assertEquals((long)5L, (long)thirdBatch.lastOffset());
            Assert.assertEquals((long)pid2, (long)thirdBatch.producerId());
            Assert.assertEquals((long)epoch2, (long)thirdBatch.producerEpoch());
            Assert.assertEquals((long)baseSequence2, (long)thirdBatch.baseSequence());
            Assert.assertEquals((long)(baseSequence2 + 2), (long)thirdBatch.lastSequence());
            Assert.assertTrue((boolean)thirdBatch.isTransactional());
            List thirdBatchRecords = TestUtils.toList(thirdBatch);
            Assert.assertEquals((long)2L, (long)thirdBatchRecords.size());
            Assert.assertEquals((long)baseSequence2, (long)((Record)thirdBatchRecords.get(0)).sequence());
            Assert.assertEquals((Object)new SimpleRecord(16L, "6".getBytes(), "g".getBytes()), (Object)new SimpleRecord((Record)thirdBatchRecords.get(0)));
            Assert.assertEquals((long)(baseSequence2 + 1), (long)((Record)thirdBatchRecords.get(1)).sequence());
            Assert.assertEquals((Object)new SimpleRecord(17L, "7".getBytes(), "h".getBytes()), (Object)new SimpleRecord((Record)thirdBatchRecords.get(1)));
        }
    }

    @Test
    public void testFilterToWithUndersizedBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, null, "a".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
        builder.append(11L, "1".getBytes(), new byte[128]);
        builder.append(12L, "2".getBytes(), "c".getBytes());
        builder.append(13L, null, "d".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)4L);
        builder.append(14L, null, "e".getBytes());
        builder.append(15L, "5".getBytes(), "f".getBytes());
        builder.append(16L, "6".getBytes(), "g".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)7L);
        builder.append(17L, "7".getBytes(), new byte[128]);
        builder.close();
        buffer.flip();
        ByteBuffer output = ByteBuffer.allocate(64);
        ArrayList records = new ArrayList();
        while (buffer.hasRemaining()) {
            output.rewind();
            MemoryRecords.FilterResult result = MemoryRecords.readableRecords((ByteBuffer)buffer).filterTo(new TopicPartition("foo", 0), (MemoryRecords.RecordFilter)new RetainNonNullKeysFilter(), output, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
            buffer.position(buffer.position() + result.bytesRead);
            result.output.flip();
            if (output != result.output) {
                Assert.assertEquals((long)0L, (long)output.position());
            }
            MemoryRecords filtered = MemoryRecords.readableRecords((ByteBuffer)result.output);
            records.addAll(TestUtils.toList(filtered.records()));
        }
        Assert.assertEquals((long)5L, (long)records.size());
        for (Record record : records) {
            Assert.assertNotNull((Object)record.key());
        }
    }

    @Test
    public void testToString() {
        long timestamp = 1000000L;
        MemoryRecords memoryRecords = MemoryRecords.withRecords((byte)this.magic, (CompressionType)this.compression, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, "key1".getBytes(), "value1".getBytes()), new SimpleRecord(timestamp + 1L, "key2".getBytes(), "value2".getBytes())});
        switch (this.magic) {
            case 0: {
                Assert.assertEquals((Object)"[(record=LegacyRecordBatch(offset=0, Record(magic=0, attributes=0, compression=NONE, crc=1978725405, key=4 bytes, value=6 bytes))), (record=LegacyRecordBatch(offset=1, Record(magic=0, attributes=0, compression=NONE, crc=1964753830, key=4 bytes, value=6 bytes)))]", (Object)memoryRecords.toString());
                break;
            }
            case 1: {
                Assert.assertEquals((Object)"[(record=LegacyRecordBatch(offset=0, Record(magic=1, attributes=0, compression=NONE, crc=97210616, CreateTime=1000000, key=4 bytes, value=6 bytes))), (record=LegacyRecordBatch(offset=1, Record(magic=1, attributes=0, compression=NONE, crc=3535988507, CreateTime=1000001, key=4 bytes, value=6 bytes)))]", (Object)memoryRecords.toString());
                break;
            }
            case 2: {
                Assert.assertEquals((Object)"[(record=DefaultRecord(offset=0, timestamp=1000000, key=4 bytes, value=6 bytes)), (record=DefaultRecord(offset=1, timestamp=1000001, key=4 bytes, value=6 bytes))]", (Object)memoryRecords.toString());
                break;
            }
            default: {
                Assert.fail((String)("Unexpected magic " + this.magic));
            }
        }
    }

    @Test
    public void testFilterTo() {
        List<Long> expectedMaxTimestamps;
        List<Long> expectedStartOffsets;
        List<Long> expectedEndOffsets;
        ByteBuffer buffer = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, null, "a".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
        builder.append(11L, "1".getBytes(), "b".getBytes());
        builder.append(12L, null, "c".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)3L);
        builder.append(13L, null, "d".getBytes());
        builder.append(20L, "4".getBytes(), "e".getBytes());
        builder.append(15L, "5".getBytes(), "f".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)6L);
        builder.append(16L, "6".getBytes(), "g".getBytes());
        builder.close();
        buffer.flip();
        ByteBuffer filtered = ByteBuffer.allocate(2048);
        MemoryRecords.FilterResult result = MemoryRecords.readableRecords((ByteBuffer)buffer).filterTo(new TopicPartition("foo", 0), (MemoryRecords.RecordFilter)new RetainNonNullKeysFilter(), filtered, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
        filtered.flip();
        Assert.assertEquals((long)7L, (long)result.messagesRead);
        Assert.assertEquals((long)4L, (long)result.messagesRetained);
        Assert.assertEquals((long)buffer.limit(), (long)result.bytesRead);
        Assert.assertEquals((long)filtered.limit(), (long)result.bytesRetained);
        if (this.magic > 0) {
            Assert.assertEquals((long)20L, (long)result.maxTimestamp);
            if (this.compression == CompressionType.NONE && this.magic < 2) {
                Assert.assertEquals((long)4L, (long)result.shallowOffsetOfMaxTimestamp);
            } else {
                Assert.assertEquals((long)5L, (long)result.shallowOffsetOfMaxTimestamp);
            }
        }
        MemoryRecords filteredRecords = MemoryRecords.readableRecords((ByteBuffer)filtered);
        List batches = TestUtils.toList(filteredRecords.batches());
        if (this.magic < 2 && this.compression == CompressionType.NONE) {
            expectedEndOffsets = Arrays.asList(1L, 4L, 5L, 6L);
            expectedStartOffsets = Arrays.asList(1L, 4L, 5L, 6L);
            expectedMaxTimestamps = Arrays.asList(11L, 20L, 15L, 16L);
        } else if (this.magic < 2) {
            expectedEndOffsets = Arrays.asList(1L, 5L, 6L);
            expectedStartOffsets = Arrays.asList(1L, 4L, 6L);
            expectedMaxTimestamps = Arrays.asList(11L, 20L, 16L);
        } else {
            expectedEndOffsets = Arrays.asList(2L, 5L, 6L);
            expectedStartOffsets = Arrays.asList(1L, 3L, 6L);
            expectedMaxTimestamps = Arrays.asList(11L, 20L, 16L);
        }
        Assert.assertEquals((long)expectedEndOffsets.size(), (long)batches.size());
        for (int i = 0; i < expectedEndOffsets.size(); ++i) {
            RecordBatch batch = (RecordBatch)batches.get(i);
            Assert.assertEquals((long)expectedStartOffsets.get(i), (long)batch.baseOffset());
            Assert.assertEquals((long)expectedEndOffsets.get(i), (long)batch.lastOffset());
            Assert.assertEquals((long)this.magic, (long)batch.magic());
            Assert.assertEquals((Object)this.compression, (Object)batch.compressionType());
            if (this.magic >= 1) {
                Assert.assertEquals((long)expectedMaxTimestamps.get(i), (long)batch.maxTimestamp());
                Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
                continue;
            }
            Assert.assertEquals((long)-1L, (long)batch.maxTimestamp());
            Assert.assertEquals((Object)TimestampType.NO_TIMESTAMP_TYPE, (Object)batch.timestampType());
        }
        List records = TestUtils.toList(filteredRecords.records());
        Assert.assertEquals((long)4L, (long)records.size());
        Record first = (Record)records.get(0);
        Assert.assertEquals((long)1L, (long)first.offset());
        if (this.magic > 0) {
            Assert.assertEquals((long)11L, (long)first.timestamp());
        }
        Assert.assertEquals((Object)"1", (Object)Utils.utf8((ByteBuffer)first.key(), (int)first.keySize()));
        Assert.assertEquals((Object)"b", (Object)Utils.utf8((ByteBuffer)first.value(), (int)first.valueSize()));
        Record second = (Record)records.get(1);
        Assert.assertEquals((long)4L, (long)second.offset());
        if (this.magic > 0) {
            Assert.assertEquals((long)20L, (long)second.timestamp());
        }
        Assert.assertEquals((Object)"4", (Object)Utils.utf8((ByteBuffer)second.key(), (int)second.keySize()));
        Assert.assertEquals((Object)"e", (Object)Utils.utf8((ByteBuffer)second.value(), (int)second.valueSize()));
        Record third = (Record)records.get(2);
        Assert.assertEquals((long)5L, (long)third.offset());
        if (this.magic > 0) {
            Assert.assertEquals((long)15L, (long)third.timestamp());
        }
        Assert.assertEquals((Object)"5", (Object)Utils.utf8((ByteBuffer)third.key(), (int)third.keySize()));
        Assert.assertEquals((Object)"f", (Object)Utils.utf8((ByteBuffer)third.value(), (int)third.valueSize()));
        Record fourth = (Record)records.get(3);
        Assert.assertEquals((long)6L, (long)fourth.offset());
        if (this.magic > 0) {
            Assert.assertEquals((long)16L, (long)fourth.timestamp());
        }
        Assert.assertEquals((Object)"6", (Object)Utils.utf8((ByteBuffer)fourth.key(), (int)fourth.keySize()));
        Assert.assertEquals((Object)"g", (Object)Utils.utf8((ByteBuffer)fourth.value(), (int)fourth.valueSize()));
    }

    @Test
    public void testFilterToPreservesLogAppendTime() {
        long logAppendTime = System.currentTimeMillis();
        ByteBuffer buffer = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)0L, (long)logAppendTime, (long)this.pid, (short)this.epoch, (int)this.firstSequence);
        builder.append(10L, null, "a".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)1L, (long)logAppendTime, (long)this.pid, (short)this.epoch, (int)this.firstSequence);
        builder.append(11L, "1".getBytes(), "b".getBytes());
        builder.append(12L, null, "c".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)3L, (long)logAppendTime, (long)this.pid, (short)this.epoch, (int)this.firstSequence);
        builder.append(13L, null, "d".getBytes());
        builder.append(14L, "4".getBytes(), "e".getBytes());
        builder.append(15L, "5".getBytes(), "f".getBytes());
        builder.close();
        buffer.flip();
        ByteBuffer filtered = ByteBuffer.allocate(2048);
        MemoryRecords.readableRecords((ByteBuffer)buffer).filterTo(new TopicPartition("foo", 0), (MemoryRecords.RecordFilter)new RetainNonNullKeysFilter(), filtered, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
        filtered.flip();
        MemoryRecords filteredRecords = MemoryRecords.readableRecords((ByteBuffer)filtered);
        List<RecordBatch> batches = TestUtils.toList(filteredRecords.batches());
        Assert.assertEquals((long)(this.magic < 2 && this.compression == CompressionType.NONE ? 3L : 2L), (long)batches.size());
        for (RecordBatch batch : batches) {
            Assert.assertEquals((Object)this.compression, (Object)batch.compressionType());
            if (this.magic <= 0) continue;
            Assert.assertEquals((Object)TimestampType.LOG_APPEND_TIME, (Object)batch.timestampType());
            Assert.assertEquals((long)logAppendTime, (long)batch.maxTimestamp());
        }
    }

    @Parameterized.Parameters(name="{index} magic={0}, firstOffset={1}, compressionType={2}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (long firstOffset : Arrays.asList(0L, 57L)) {
            for (byte magic : Arrays.asList((byte)0, (byte)1, (byte)2)) {
                for (CompressionType type : CompressionType.values()) {
                    values.add(new Object[]{magic, firstOffset, type});
                }
            }
        }
        return values;
    }

    private static class RetainNonNullKeysFilter
    extends MemoryRecords.RecordFilter {
        private RetainNonNullKeysFilter() {
        }

        protected MemoryRecords.RecordFilter.BatchRetention checkBatchRetention(RecordBatch batch) {
            return MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY;
        }

        public boolean shouldRetainRecord(RecordBatch batch, Record record) {
            return record.hasKey();
        }
    }
}

