/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.stats;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.Total;
import org.junit.Assert;
import org.junit.Test;

public class MeterTest {
    private static final double EPS = 1.0E-7;

    @Test
    public void testMeter() {
        Map emptyTags = Collections.emptyMap();
        MetricName rateMetricName = new MetricName("rate", "test", "", emptyTags);
        MetricName totalMetricName = new MetricName("total", "test", "", emptyTags);
        Meter meter = new Meter(rateMetricName, totalMetricName);
        List stats = meter.stats();
        Assert.assertEquals((long)2L, (long)stats.size());
        CompoundStat.NamedMeasurable total = (CompoundStat.NamedMeasurable)stats.get(0);
        CompoundStat.NamedMeasurable rate = (CompoundStat.NamedMeasurable)stats.get(1);
        Assert.assertEquals((Object)rateMetricName, (Object)rate.name());
        Assert.assertEquals((Object)totalMetricName, (Object)total.name());
        Rate rateStat = (Rate)rate.stat();
        Total totalStat = (Total)total.stat();
        MetricConfig config = new MetricConfig();
        double nextValue = 0.0;
        double expectedTotal = 0.0;
        long now = 0L;
        double intervalMs = 100.0;
        double delta = 5.0;
        for (int i = 1; i <= 100; ++i) {
            while (now < (long)(i * 1000)) {
                expectedTotal += nextValue;
                meter.record(config, nextValue, now);
                now = (long)((double)now + intervalMs);
                nextValue += delta;
            }
            Assert.assertEquals((double)expectedTotal, (double)totalStat.measure(config, now), (double)1.0E-7);
            long windowSizeMs = rateStat.windowSize(config, now);
            long windowStartMs = Math.max(now - windowSizeMs, 0L);
            double sampledTotal = 0.0;
            double prevValue = nextValue - delta;
            long timeMs = now - 100L;
            while (timeMs >= windowStartMs) {
                sampledTotal += prevValue;
                timeMs = (long)((double)timeMs - intervalMs);
                prevValue -= delta;
            }
            Assert.assertEquals((double)(sampledTotal * 1000.0 / (double)windowSizeMs), (double)rateStat.measure(config, now), (double)1.0E-7);
        }
    }
}

