/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;

public class MetadataRequest
extends AbstractRequestResponse {
    public static Schema curSchema = ProtoUtils.currentRequestSchema(ApiKeys.METADATA.id);
    private static String TOPICS_KEY_NAME = "topics";
    private final List<String> topics;

    public MetadataRequest(List<String> topics) {
        super(new Struct(curSchema));
        this.struct.set(TOPICS_KEY_NAME, (Object)topics.toArray());
        this.topics = topics;
    }

    public MetadataRequest(Struct struct) {
        super(struct);
        Object[] topicArray = struct.getArray(TOPICS_KEY_NAME);
        this.topics = new ArrayList<String>();
        for (Object topicObj : topicArray) {
            this.topics.add((String)topicObj);
        }
    }

    public List<String> topics() {
        return this.topics;
    }

    public static MetadataRequest parse(ByteBuffer buffer) {
        return new MetadataRequest((Struct)curSchema.read(buffer));
    }
}

