/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ListGroupsResponse;

public class ListGroupsRequest
extends AbstractRequest {
    public ListGroupsRequest(short version) {
        super(new Struct(ProtoUtils.requestSchema(ApiKeys.LIST_GROUPS.id, version)), version);
    }

    public ListGroupsRequest(Struct struct, short versionId) {
        super(struct, versionId);
    }

    @Override
    public AbstractResponse getErrorResponse(Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                short errorCode = Errors.forException(e).code();
                return new ListGroupsResponse(errorCode, Collections.emptyList());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.LIST_GROUPS.id)));
    }

    public static ListGroupsRequest parse(ByteBuffer buffer, int versionId) {
        return new ListGroupsRequest(ProtoUtils.parseRequest(ApiKeys.LIST_GROUPS.id, versionId, buffer), (short)versionId);
    }

    public static ListGroupsRequest parse(ByteBuffer buffer) {
        return ListGroupsRequest.parse(buffer, ProtoUtils.latestVersion(ApiKeys.LIST_GROUPS.id));
    }

    public static class Builder
    extends AbstractRequest.Builder<ListGroupsRequest> {
        public Builder() {
            super(ApiKeys.LIST_GROUPS);
        }

        @Override
        public ListGroupsRequest build() {
            return new ListGroupsRequest(this.version());
        }

        public String toString() {
            return "(type=ListGroupsRequest)";
        }
    }
}

