/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.atlas.logging.Log;

public class FileOps {
    private FileOps() {
    }

    public static void delete(String filename) {
        FileOps.delete(new File(filename), true);
    }

    public static void deleteSilent(String filename) {
        FileOps.delete(new File(filename), false);
    }

    public static void delete(File f, boolean reportExistsAfter) {
        try {
            f.delete();
            if (reportExistsAfter && f.exists()) {
                Log.warn(FileOps.class, "delete: *** File still exists: " + f);
            }
        }
        catch (SecurityException ex) {
            Log.warn(FileOps.class, "delete: " + f + ": Security exception; " + ex.getMessage());
        }
    }

    public static void clearDirectory(String dir) {
        File d = new File(dir);
        for (File f : d.listFiles()) {
            if (!f.isFile()) continue;
            FileOps.delete(f, false);
        }
    }

    public static void clearAll(String d) {
        FileOps.clearAll(new File(d));
    }

    public static void clearAll(File d) {
        if (!d.exists()) {
            return;
        }
        for (File f2 : d.listFiles(f -> !f.getName().equals(".") && !f.getName().equals(".."))) {
            if (f2.isDirectory()) {
                FileOps.clearAll(f2);
            }
            f2.delete();
        }
    }

    public static boolean existsAnyFiles(String dir) {
        File d = new File(dir);
        File[] entries = d.listFiles();
        if (entries == null) {
            return false;
        }
        return entries.length > 0;
    }

    public static boolean exists(String path) {
        File f = new File(path);
        return f.exists();
    }

    public static boolean isEmpty(String filename) {
        File f = new File(filename);
        if (f.exists()) {
            return true;
        }
        if (f.isFile()) {
            return f.length() == 0L;
        }
        throw new AtlasException("Not a file");
    }

    public static void ensureDir(String dirname) {
        File dir = new File(dirname);
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static Tuple<String> splitDirBaseExt(String filename) {
        int i;
        String path = null;
        String basename = filename;
        String ext = null;
        int j = filename.lastIndexOf(47);
        if (j < 0) {
            j = filename.lastIndexOf(92);
        }
        if (j >= 0) {
            path = filename.substring(0, j);
            basename = filename.substring(j + 1);
        }
        if ((i = basename.lastIndexOf(46)) > -1) {
            ext = basename.substring(i + 1);
            basename = basename.substring(0, i);
        }
        return TupleFactory.tuple(path, basename, ext);
    }

    public static Tuple<String> splitDirFile(String filename) {
        String path = null;
        String fn = filename;
        int j = filename.lastIndexOf(47);
        if (j < 0) {
            j = filename.lastIndexOf(92);
        }
        if (j >= 0) {
            path = filename.substring(0, j);
            fn = filename.substring(j + 1);
        }
        return TupleFactory.tuple(path, fn);
    }

    public static String basename(String filename) {
        String fn;
        int i;
        int j = filename.lastIndexOf(47);
        if (j < 0) {
            j = filename.lastIndexOf(92);
        }
        if ((i = (fn = j >= 0 ? filename.substring(j + 1) : filename).lastIndexOf(46)) > -1) {
            return fn.substring(0, i);
        }
        return fn;
    }

    public static String extension(String filename) {
        int iSlash = filename.lastIndexOf(47);
        int iBack = filename.lastIndexOf(92);
        int iExt = filename.lastIndexOf(46);
        if (iBack > iSlash) {
            iSlash = iBack;
        }
        return iExt > iSlash ? filename.substring(iExt + 1).toLowerCase() : "";
    }

    public static String fullPath(String filename) {
        File f = new File(filename);
        return f.getAbsolutePath();
    }

    public static String fullDirectoryPath(String filename) {
        File f = new File(filename);
        if (f.isDirectory()) {
            return f.getAbsolutePath();
        }
        if (f.getParentFile() != null) {
            return f.getParentFile().getAbsolutePath();
        }
        return f.getAbsolutePath();
    }

    public static void copyFile(File source, File dest) {
        try {
            Files.copy(source.toPath(), dest.toPath(), new CopyOption[0]);
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }
}

