/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.ConfigUtil;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

@InterfaceAudience.Private
public class SplitTransaction {
    private static final Log LOG = LogFactory.getLog(SplitTransaction.class);
    private final HRegion parent;
    private HRegionInfo hri_a;
    private HRegionInfo hri_b;
    private long fileSplitTimeout = 30000L;
    private int znodeVersion = -1;
    boolean useZKForAssignment;
    private final byte[] splitrow;
    private final List<JournalEntry> journal = new ArrayList<JournalEntry>();
    private static IOException closedByOtherException = new IOException("Failed to close region: already closed by another thread");

    public SplitTransaction(HRegion r, byte[] splitrow) {
        this.parent = r;
        this.splitrow = splitrow;
        this.journal.add(new JournalEntry(JournalEntryType.STARTED));
        this.useZKForAssignment = ConfigUtil.useZKForAssignment(r.getBaseConf());
    }

    public boolean prepare() {
        if (!this.parent.isSplittable()) {
            return false;
        }
        if (this.splitrow == null) {
            return false;
        }
        HRegionInfo hri = this.parent.getRegionInfo();
        this.parent.prepareToSplit();
        byte[] startKey = hri.getStartKey();
        byte[] endKey = hri.getEndKey();
        if (Bytes.equals((byte[])startKey, (byte[])this.splitrow) || !this.parent.getRegionInfo().containsRow(this.splitrow)) {
            LOG.info((Object)("Split row is not inside region key range or is equal to startkey: " + Bytes.toStringBinary((byte[])this.splitrow)));
            return false;
        }
        long rid = SplitTransaction.getDaughterRegionIdTimestamp(hri);
        this.hri_a = new HRegionInfo(hri.getTable(), startKey, this.splitrow, false, rid);
        this.hri_b = new HRegionInfo(hri.getTable(), this.splitrow, endKey, false, rid);
        this.journal.add(new JournalEntry(JournalEntryType.PREPARED));
        return true;
    }

    private static long getDaughterRegionIdTimestamp(HRegionInfo hri) {
        long rid = EnvironmentEdgeManager.currentTimeMillis();
        if (rid < hri.getRegionId()) {
            LOG.warn((Object)("Clock skew; parent regions id is " + hri.getRegionId() + " but current time here is " + rid));
            rid = hri.getRegionId() + 1L;
        }
        return rid;
    }

    PairOfSameType<HRegion> createDaughters(Server server, RegionServerServices services) throws IOException {
        LOG.info((Object)("Starting split of region " + this.parent));
        if (server != null && server.isStopped() || services != null && services.isStopping()) {
            throw new IOException("Server is stopped or stopping");
        }
        assert (!this.parent.lock.writeLock().isHeldByCurrentThread()) : "Unsafe to hold write lock while performing RPCs";
        this.journal.add(new JournalEntry(JournalEntryType.BEFORE_PRE_SPLIT_HOOK));
        if (this.parent.getCoprocessorHost() != null) {
            this.parent.getCoprocessorHost().preSplit();
            this.parent.getCoprocessorHost().preSplit(this.splitrow);
        }
        this.journal.add(new JournalEntry(JournalEntryType.AFTER_PRE_SPLIT_HOOK));
        boolean testing = server == null ? true : server.getConfiguration().getBoolean("hbase.testing.nocluster", false);
        this.fileSplitTimeout = testing ? this.fileSplitTimeout : server.getConfiguration().getLong("hbase.regionserver.fileSplitTimeout", this.fileSplitTimeout);
        PairOfSameType<HRegion> daughterRegions = this.stepsBeforePONR(server, services, testing);
        ArrayList<Mutation> metaEntries = new ArrayList<Mutation>();
        if (this.parent.getCoprocessorHost() != null) {
            if (this.parent.getCoprocessorHost().preSplitBeforePONR(this.splitrow, metaEntries)) {
                throw new IOException("Coprocessor bypassing region " + this.parent.getRegionNameAsString() + " split.");
            }
            try {
                for (Mutation p : metaEntries) {
                    HRegionInfo.parseRegionName((byte[])p.getRow());
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Row key of mutation from coprossor is not parsable as region name.Mutations from coprocessor should only for hbase:meta table.");
                throw e;
            }
        }
        this.journal.add(new JournalEntry(JournalEntryType.PONR));
        if (!testing && this.useZKForAssignment) {
            if (metaEntries == null || metaEntries.isEmpty()) {
                MetaEditor.splitRegion(server.getCatalogTracker(), this.parent.getRegionInfo(), ((HRegion)daughterRegions.getFirst()).getRegionInfo(), ((HRegion)daughterRegions.getSecond()).getRegionInfo(), server.getServerName());
            } else {
                this.offlineParentInMetaAndputMetaEntries(server.getCatalogTracker(), this.parent.getRegionInfo(), ((HRegion)daughterRegions.getFirst()).getRegionInfo(), ((HRegion)daughterRegions.getSecond()).getRegionInfo(), server.getServerName(), metaEntries);
            }
        } else if (services != null && !this.useZKForAssignment && !services.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.SPLIT_PONR, this.parent.getRegionInfo(), this.hri_a, this.hri_b)) {
            throw new IOException("Failed to notify master that split passed PONR: " + this.parent.getRegionInfo().getRegionNameAsString());
        }
        return daughterRegions;
    }

    public PairOfSameType<HRegion> stepsBeforePONR(Server server, RegionServerServices services, boolean testing) throws IOException {
        if (server != null && server.getZooKeeper() != null && this.useZKForAssignment) {
            try {
                SplitTransaction.createNodeSplitting(server.getZooKeeper(), this.parent.getRegionInfo(), server.getServerName(), this.hri_a, this.hri_b);
            }
            catch (KeeperException e) {
                throw new IOException("Failed creating PENDING_SPLIT znode on " + this.parent.getRegionNameAsString(), e);
            }
        } else if (services != null && !this.useZKForAssignment && !services.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.READY_TO_SPLIT, this.parent.getRegionInfo(), this.hri_a, this.hri_b)) {
            throw new IOException("Failed to get ok from master to split " + this.parent.getRegionNameAsString());
        }
        this.journal.add(new JournalEntry(JournalEntryType.SET_SPLITTING_IN_ZK));
        if (server != null && server.getZooKeeper() != null && this.useZKForAssignment) {
            this.znodeVersion = this.getZKNode(server, services);
        }
        this.parent.getRegionFileSystem().createSplitsDir();
        this.journal.add(new JournalEntry(JournalEntryType.CREATE_SPLIT_DIR));
        Map<byte[], List<StoreFile>> hstoreFilesToSplit = null;
        Exception exceptionToThrow = null;
        try {
            hstoreFilesToSplit = this.parent.close(false);
        }
        catch (Exception e) {
            exceptionToThrow = e;
        }
        if (exceptionToThrow == null && hstoreFilesToSplit == null) {
            exceptionToThrow = closedByOtherException;
        }
        if (exceptionToThrow != closedByOtherException) {
            this.journal.add(new JournalEntry(JournalEntryType.CLOSED_PARENT_REGION));
        }
        if (exceptionToThrow != null) {
            if (exceptionToThrow instanceof IOException) {
                throw (IOException)exceptionToThrow;
            }
            throw new IOException(exceptionToThrow);
        }
        if (!testing) {
            services.removeFromOnlineRegions(this.parent, null);
        }
        this.journal.add(new JournalEntry(JournalEntryType.OFFLINED_PARENT));
        Pair<Integer, Integer> expectedReferences = this.splitStoreFiles(hstoreFilesToSplit);
        this.journal.add(new JournalEntry(JournalEntryType.STARTED_REGION_A_CREATION));
        this.assertReferenceFileCount((Integer)expectedReferences.getFirst(), this.parent.getRegionFileSystem().getSplitsDir(this.hri_a));
        HRegion a = this.parent.createDaughterRegionFromSplits(this.hri_a);
        this.assertReferenceFileCount((Integer)expectedReferences.getFirst(), new Path(this.parent.getRegionFileSystem().getTableDir(), this.hri_a.getEncodedName()));
        this.journal.add(new JournalEntry(JournalEntryType.STARTED_REGION_B_CREATION));
        this.assertReferenceFileCount((Integer)expectedReferences.getSecond(), this.parent.getRegionFileSystem().getSplitsDir(this.hri_b));
        HRegion b = this.parent.createDaughterRegionFromSplits(this.hri_b);
        this.assertReferenceFileCount((Integer)expectedReferences.getSecond(), new Path(this.parent.getRegionFileSystem().getTableDir(), this.hri_b.getEncodedName()));
        return new PairOfSameType((Object)a, (Object)b);
    }

    void assertReferenceFileCount(int expectedReferenceFileCount, Path dir) throws IOException {
        if (expectedReferenceFileCount != 0 && expectedReferenceFileCount != FSUtils.getRegionReferenceFileCount(this.parent.getFilesystem(), dir)) {
            throw new IOException("Failing split. Expected reference file count isn't equal.");
        }
    }

    void openDaughters(Server server, RegionServerServices services, HRegion a, HRegion b) throws IOException {
        boolean stopping;
        boolean stopped = server != null && server.isStopped();
        boolean bl = stopping = services != null && services.isStopping();
        if (stopped || stopping) {
            LOG.info((Object)("Not opening daughters " + b.getRegionInfo().getRegionNameAsString() + " and " + a.getRegionInfo().getRegionNameAsString() + " because stopping=" + stopping + ", stopped=" + stopped));
        } else {
            DaughterOpener aOpener = new DaughterOpener(server, a);
            DaughterOpener bOpener = new DaughterOpener(server, b);
            aOpener.start();
            bOpener.start();
            try {
                aOpener.join();
                if (aOpener.getException() == null) {
                    this.journal.add(new JournalEntry(JournalEntryType.OPENED_REGION_A));
                }
                bOpener.join();
                if (bOpener.getException() == null) {
                    this.journal.add(new JournalEntry(JournalEntryType.OPENED_REGION_B));
                }
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
            if (aOpener.getException() != null) {
                throw new IOException("Failed " + aOpener.getName(), aOpener.getException());
            }
            if (bOpener.getException() != null) {
                throw new IOException("Failed " + bOpener.getName(), bOpener.getException());
            }
            if (services != null) {
                try {
                    if (this.useZKForAssignment) {
                        services.postOpenDeployTasks(b, server.getCatalogTracker());
                    } else if (!services.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.SPLIT, this.parent.getRegionInfo(), this.hri_a, this.hri_b)) {
                        throw new IOException("Failed to report split region to master: " + this.parent.getRegionInfo().getShortNameToLog());
                    }
                    services.addToOnlineRegions(b);
                    if (this.useZKForAssignment) {
                        services.postOpenDeployTasks(a, server.getCatalogTracker());
                    }
                    services.addToOnlineRegions(a);
                }
                catch (KeeperException ke) {
                    throw new IOException(ke);
                }
            }
        }
    }

    void transitionZKNode(Server server, RegionServerServices services, HRegion a, HRegion b) throws IOException {
        if (server != null && server.getZooKeeper() != null) {
            try {
                this.znodeVersion = SplitTransaction.transitionSplittingNode(server.getZooKeeper(), this.parent.getRegionInfo(), a.getRegionInfo(), b.getRegionInfo(), server.getServerName(), this.znodeVersion, EventType.RS_ZK_REGION_SPLITTING, EventType.RS_ZK_REGION_SPLIT);
                int spins = 0;
                do {
                    if (spins % 10 == 0) {
                        LOG.debug((Object)("Still waiting on the master to process the split for " + this.parent.getRegionInfo().getEncodedName()));
                    }
                    Thread.sleep(100L);
                    this.znodeVersion = SplitTransaction.transitionSplittingNode(server.getZooKeeper(), this.parent.getRegionInfo(), a.getRegionInfo(), b.getRegionInfo(), server.getServerName(), this.znodeVersion, EventType.RS_ZK_REGION_SPLIT, EventType.RS_ZK_REGION_SPLIT);
                    ++spins;
                } while (this.znodeVersion != -1 && !server.isStopped() && !services.isStopping());
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new IOException("Failed telling master about split", e);
            }
        }
    }

    private int getZKNode(Server server, RegionServerServices services) throws IOException {
        try {
            int spins = 0;
            Stat stat = new Stat();
            ZooKeeperWatcher zkw = server.getZooKeeper();
            ServerName expectedServer = server.getServerName();
            String node = this.parent.getRegionInfo().getEncodedName();
            while (!server.isStopped() && !services.isStopping()) {
                if (spins % 5 == 0) {
                    LOG.debug((Object)("Still waiting for master to process the pending_split for " + node));
                    SplitTransaction.transitionSplittingNode(zkw, this.parent.getRegionInfo(), this.hri_a, this.hri_b, expectedServer, -1, EventType.RS_ZK_REQUEST_REGION_SPLIT, EventType.RS_ZK_REQUEST_REGION_SPLIT);
                }
                Thread.sleep(100L);
                ++spins;
                byte[] data = ZKAssign.getDataNoWatch((ZooKeeperWatcher)zkw, (String)node, (Stat)stat);
                if (data == null) {
                    throw new IOException("Data is null, splitting node " + node + " no longer exists");
                }
                RegionTransition rt = RegionTransition.parseFrom((byte[])data);
                EventType et = rt.getEventType();
                if (et == EventType.RS_ZK_REGION_SPLITTING) {
                    ServerName serverName = rt.getServerName();
                    if (!serverName.equals((Object)expectedServer)) {
                        throw new IOException("Splitting node " + node + " is for " + serverName + ", not us " + expectedServer);
                    }
                    byte[] payloadOfSplitting = rt.getPayload();
                    List splittingRegions = HRegionInfo.parseDelimitedFrom((byte[])payloadOfSplitting, (int)0, (int)payloadOfSplitting.length);
                    assert (splittingRegions.size() == 2);
                    HRegionInfo a = (HRegionInfo)splittingRegions.get(0);
                    HRegionInfo b = (HRegionInfo)splittingRegions.get(1);
                    if (!this.hri_a.equals((Object)a) || !this.hri_b.equals((Object)b)) {
                        throw new IOException("Splitting node " + node + " is for " + a + ", " + b + ", not expected daughters: " + this.hri_a + ", " + this.hri_b);
                    }
                    return stat.getVersion();
                }
                if (et == EventType.RS_ZK_REQUEST_REGION_SPLIT) continue;
                throw new IOException("Splitting node " + node + " moved out of splitting to " + et);
            }
            throw new IOException("Server is " + (services.isStopping() ? "stopping" : "stopped"));
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new IOException("Failed getting SPLITTING znode on " + this.parent.getRegionNameAsString(), e);
        }
    }

    public PairOfSameType<HRegion> execute(Server server, RegionServerServices services) throws IOException {
        this.useZKForAssignment = server == null ? true : ConfigUtil.useZKForAssignment(server.getConfiguration());
        PairOfSameType<HRegion> regions = this.createDaughters(server, services);
        if (this.parent.getCoprocessorHost() != null) {
            this.parent.getCoprocessorHost().preSplitAfterPONR();
        }
        return this.stepsAfterPONR(server, services, regions);
    }

    public PairOfSameType<HRegion> stepsAfterPONR(Server server, RegionServerServices services, PairOfSameType<HRegion> regions) throws IOException {
        this.openDaughters(server, services, (HRegion)regions.getFirst(), (HRegion)regions.getSecond());
        if (server != null && server.getZooKeeper() != null && this.useZKForAssignment) {
            this.transitionZKNode(server, services, (HRegion)regions.getFirst(), (HRegion)regions.getSecond());
        }
        this.journal.add(new JournalEntry(JournalEntryType.BEFORE_POST_SPLIT_HOOK));
        if (this.parent.getCoprocessorHost() != null) {
            this.parent.getCoprocessorHost().postSplit((HRegion)regions.getFirst(), (HRegion)regions.getSecond());
        }
        this.journal.add(new JournalEntry(JournalEntryType.AFTER_POST_SPLIT_HOOK));
        return regions;
    }

    private void offlineParentInMetaAndputMetaEntries(CatalogTracker catalogTracker, HRegionInfo parent, HRegionInfo splitA, HRegionInfo splitB, ServerName serverName, List<Mutation> metaEntries) throws IOException {
        List<Mutation> mutations = metaEntries;
        HRegionInfo copyOfParent = new HRegionInfo(parent);
        copyOfParent.setOffline(true);
        copyOfParent.setSplit(true);
        Put putParent = MetaEditor.makePutFromRegionInfo(copyOfParent);
        MetaEditor.addDaughtersToPut(putParent, splitA, splitB);
        mutations.add((Mutation)putParent);
        Put putA = MetaEditor.makePutFromRegionInfo(splitA);
        Put putB = MetaEditor.makePutFromRegionInfo(splitB);
        this.addLocation(putA, serverName, 1L);
        this.addLocation(putB, serverName, 1L);
        mutations.add((Mutation)putA);
        mutations.add((Mutation)putB);
        MetaEditor.mutateMetaTable(catalogTracker, mutations);
    }

    public Put addLocation(Put p, ServerName sn, long openSeqNum) {
        p.addImmutable(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)sn.getHostAndPort()));
        p.addImmutable(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, Bytes.toBytes((long)sn.getStartcode()));
        p.addImmutable(HConstants.CATALOG_FAMILY, HConstants.SEQNUM_QUALIFIER, Bytes.toBytes((long)openSeqNum));
        return p;
    }

    void openDaughterRegion(Server server, HRegion daughter) throws IOException, KeeperException {
        HRegionInfo hri = daughter.getRegionInfo();
        LoggingProgressable reporter = server == null ? null : new LoggingProgressable(hri, server.getConfiguration().getLong("hbase.regionserver.split.daughter.open.log.interval", 10000L));
        daughter.openHRegion(reporter);
    }

    private Pair<Integer, Integer> splitStoreFiles(Map<byte[], List<StoreFile>> hstoreFilesToSplit) throws IOException {
        if (hstoreFilesToSplit == null) {
            throw new IOException("Close returned empty list of StoreFiles");
        }
        int nbFiles = hstoreFilesToSplit.size();
        if (nbFiles == 0) {
            return new Pair((Object)0, (Object)0);
        }
        LOG.info((Object)("Preparing to split " + nbFiles + " storefiles for region " + this.parent));
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder();
        builder.setNameFormat("StoreFileSplitter-%1$d");
        ThreadFactory factory = builder.build();
        ThreadPoolExecutor threadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(nbFiles, factory);
        ArrayList<Future<Pair<Path, Path>>> futures = new ArrayList<Future<Pair<Path, Path>>>(nbFiles);
        for (Map.Entry<byte[], List<StoreFile>> entry : hstoreFilesToSplit.entrySet()) {
            for (StoreFile storeFile : entry.getValue()) {
                StoreFileSplitter sfs = new StoreFileSplitter(entry.getKey(), storeFile);
                futures.add(threadPool.submit(sfs));
            }
        }
        threadPool.shutdown();
        try {
            boolean stillRunning;
            boolean bl = stillRunning = !threadPool.awaitTermination(this.fileSplitTimeout, TimeUnit.MILLISECONDS);
            if (stillRunning) {
                threadPool.shutdownNow();
                while (!threadPool.isTerminated()) {
                    Thread.sleep(50L);
                }
                throw new IOException("Took too long to split the files and create the references, aborting split");
            }
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        int created_a = 0;
        int created_b = 0;
        for (Future future : futures) {
            try {
                Pair p = (Pair)future.get();
                created_a += p.getFirst() != null ? 1 : 0;
                created_b += p.getSecond() != null ? 1 : 0;
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Split storefiles for region " + this.parent + " Daugther A: " + created_a + " storefiles, Daugther B: " + created_b + " storefiles."));
        }
        return new Pair((Object)created_a, (Object)created_b);
    }

    private Pair<Path, Path> splitStoreFile(byte[] family, StoreFile sf) throws IOException {
        HRegionFileSystem fs = this.parent.getRegionFileSystem();
        String familyName = Bytes.toString((byte[])family);
        Path path_a = fs.splitStoreFile(this.hri_a, familyName, sf, this.splitrow, false, this.parent.getSplitPolicy());
        Path path_b = fs.splitStoreFile(this.hri_b, familyName, sf, this.splitrow, true, this.parent.getSplitPolicy());
        return new Pair((Object)path_a, (Object)path_b);
    }

    public boolean rollback(Server server, RegionServerServices services) throws IOException {
        if (this.parent.getCoprocessorHost() != null) {
            this.parent.getCoprocessorHost().preRollBackSplit();
        }
        boolean result = true;
        ListIterator<JournalEntry> iterator = this.journal.listIterator(this.journal.size());
        block12: while (iterator.hasPrevious()) {
            JournalEntry je = iterator.previous();
            switch (je.type) {
                case SET_SPLITTING_IN_ZK: {
                    if (server != null && server.getZooKeeper() != null && this.useZKForAssignment) {
                        SplitTransaction.cleanZK(server, this.parent.getRegionInfo());
                        continue block12;
                    }
                    if (services == null || this.useZKForAssignment || services.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.SPLIT_REVERTED, this.parent.getRegionInfo(), this.hri_a, this.hri_b)) continue block12;
                    return false;
                }
                case CREATE_SPLIT_DIR: {
                    this.parent.writestate.writesEnabled = true;
                    this.parent.getRegionFileSystem().cleanupSplitsDir();
                    continue block12;
                }
                case CLOSED_PARENT_REGION: {
                    try {
                        this.parent.initialize();
                        continue block12;
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Failed rollbacking CLOSED_PARENT_REGION of region " + this.parent.getRegionNameAsString()), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                case STARTED_REGION_A_CREATION: {
                    this.parent.getRegionFileSystem().cleanupDaughterRegion(this.hri_a);
                    continue block12;
                }
                case STARTED_REGION_B_CREATION: {
                    this.parent.getRegionFileSystem().cleanupDaughterRegion(this.hri_b);
                    continue block12;
                }
                case OFFLINED_PARENT: {
                    if (services == null) continue block12;
                    services.addToOnlineRegions(this.parent);
                    continue block12;
                }
                case PONR: {
                    return false;
                }
                case STARTED: 
                case PREPARED: 
                case BEFORE_PRE_SPLIT_HOOK: 
                case AFTER_PRE_SPLIT_HOOK: 
                case BEFORE_POST_SPLIT_HOOK: 
                case AFTER_POST_SPLIT_HOOK: 
                case OPENED_REGION_A: 
                case OPENED_REGION_B: {
                    continue block12;
                }
            }
            throw new RuntimeException("Unhandled journal entry: " + je);
        }
        if (this.parent.getCoprocessorHost() != null) {
            this.parent.getCoprocessorHost().postRollBackSplit();
        }
        return result;
    }

    HRegionInfo getFirstDaughter() {
        return this.hri_a;
    }

    HRegionInfo getSecondDaughter() {
        return this.hri_b;
    }

    private static void cleanZK(Server server, HRegionInfo hri) {
        try {
            if (!ZKAssign.deleteNode((ZooKeeperWatcher)server.getZooKeeper(), (String)hri.getEncodedName(), (EventType)EventType.RS_ZK_REQUEST_REGION_SPLIT, (ServerName)server.getServerName())) {
                ZKAssign.deleteNode((ZooKeeperWatcher)server.getZooKeeper(), (String)hri.getEncodedName(), (EventType)EventType.RS_ZK_REGION_SPLITTING, (ServerName)server.getServerName());
            }
        }
        catch (KeeperException.NoNodeException e) {
            LOG.info((Object)("Failed cleanup zk node of " + hri.getRegionNameAsString()), (Throwable)e);
        }
        catch (KeeperException e) {
            server.abort("Failed cleanup of " + hri.getRegionNameAsString(), (Throwable)e);
        }
    }

    public static void createNodeSplitting(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName, HRegionInfo a, HRegionInfo b) throws KeeperException, IOException {
        LOG.debug((Object)zkw.prefix("Creating ephemeral node for " + region.getEncodedName() + " in PENDING_SPLIT state"));
        byte[] payload = HRegionInfo.toDelimitedByteArray((HRegionInfo[])new HRegionInfo[]{a, b});
        RegionTransition rt = RegionTransition.createRegionTransition((EventType)EventType.RS_ZK_REQUEST_REGION_SPLIT, (byte[])region.getRegionName(), (ServerName)serverName, (byte[])payload);
        String node = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)region.getEncodedName());
        if (!ZKUtil.createEphemeralNodeAndWatch((ZooKeeperWatcher)zkw, (String)node, (byte[])rt.toByteArray())) {
            throw new IOException("Failed create of ephemeral " + node);
        }
    }

    public static int transitionSplittingNode(ZooKeeperWatcher zkw, HRegionInfo parent, HRegionInfo a, HRegionInfo b, ServerName serverName, int znodeVersion, EventType beginState, EventType endState) throws KeeperException, IOException {
        byte[] payload = HRegionInfo.toDelimitedByteArray((HRegionInfo[])new HRegionInfo[]{a, b});
        return ZKAssign.transitionNode((ZooKeeperWatcher)zkw, (HRegionInfo)parent, (ServerName)serverName, (EventType)beginState, (EventType)endState, (int)znodeVersion, (byte[])payload);
    }

    List<JournalEntry> getJournal() {
        return this.journal;
    }

    class StoreFileSplitter
    implements Callable<Pair<Path, Path>> {
        private final byte[] family;
        private final StoreFile sf;

        public StoreFileSplitter(byte[] family, StoreFile sf) {
            this.sf = sf;
            this.family = family;
        }

        @Override
        public Pair<Path, Path> call() throws IOException {
            return SplitTransaction.this.splitStoreFile(this.family, this.sf);
        }
    }

    static class LoggingProgressable
    implements CancelableProgressable {
        private final HRegionInfo hri;
        private long lastLog = -1L;
        private final long interval;

        LoggingProgressable(HRegionInfo hri, long interval) {
            this.hri = hri;
            this.interval = interval;
        }

        @Override
        public boolean progress() {
            long now = EnvironmentEdgeManager.currentTimeMillis();
            if (now - this.lastLog > this.interval) {
                LOG.info((Object)("Opening " + this.hri.getRegionNameAsString()));
                this.lastLog = now;
            }
            return true;
        }
    }

    class DaughterOpener
    extends HasThread {
        private final Server server;
        private final HRegion r;
        private Throwable t;

        DaughterOpener(Server s, HRegion r) {
            super((s == null ? "null-services" : s.getServerName()) + "-daughterOpener=" + r.getRegionInfo().getEncodedName());
            this.t = null;
            this.setDaemon(true);
            this.server = s;
            this.r = r;
        }

        Throwable getException() {
            return this.t;
        }

        public void run() {
            try {
                SplitTransaction.this.openDaughterRegion(this.server, this.r);
            }
            catch (Throwable t) {
                this.t = t;
            }
        }
    }

    static class JournalEntry {
        private JournalEntryType type;
        private long timestamp;

        public JournalEntry(JournalEntryType type) {
            this(type, EnvironmentEdgeManager.currentTimeMillis());
        }

        public JournalEntry(JournalEntryType type, long timestamp) {
            this.type = type;
            this.timestamp = timestamp;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)this.type);
            sb.append(" at ");
            sb.append(this.timestamp);
            return sb.toString();
        }
    }

    static enum JournalEntryType {
        STARTED,
        PREPARED,
        BEFORE_PRE_SPLIT_HOOK,
        AFTER_PRE_SPLIT_HOOK,
        SET_SPLITTING_IN_ZK,
        CREATE_SPLIT_DIR,
        CLOSED_PARENT_REGION,
        OFFLINED_PARENT,
        STARTED_REGION_A_CREATION,
        STARTED_REGION_B_CREATION,
        OPENED_REGION_A,
        OPENED_REGION_B,
        BEFORE_POST_SPLIT_HOOK,
        AFTER_POST_SPLIT_HOOK,
        PONR;

    }
}

