/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.handler.DeleteTableHandler;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class TruncateTableHandler
extends DeleteTableHandler {
    private static final Log LOG = LogFactory.getLog(TruncateTableHandler.class);
    private final boolean preserveSplits;

    public TruncateTableHandler(TableName tableName, Server server, MasterServices masterServices, boolean preserveSplits) {
        super(tableName, server, masterServices);
        this.preserveSplits = preserveSplits;
    }

    @Override
    protected void handleTableOperation(List<HRegionInfo> regions) throws IOException, KeeperException {
        MasterCoprocessorHost cpHost = ((HMaster)this.server).getCoprocessorHost();
        if (cpHost != null) {
            cpHost.preTruncateTableHandler(this.tableName);
        }
        this.waitRegionInTransition(regions);
        this.removeTableData(regions);
        this.recreateTable(regions);
        if (cpHost != null) {
            cpHost.postTruncateTableHandler(this.tableName);
        }
    }

    private void recreateTable(List<HRegionInfo> regions) throws IOException {
        MasterFileSystem mfs = this.masterServices.getMasterFileSystem();
        Path tempdir = mfs.getTempDir();
        FileSystem fs = mfs.getFileSystem();
        AssignmentManager assignmentManager = this.masterServices.getAssignmentManager();
        this.checkAndSetEnablingTable(assignmentManager, this.tableName);
        try {
            HRegionInfo[] newRegions;
            Path tempTableDir = FSUtils.getTableDir(tempdir, this.tableName);
            new FSTableDescriptors(this.server.getConfiguration()).createTableDescriptorForTableDirectory(tempTableDir, this.getTableDescriptor(), false);
            Path tableDir = FSUtils.getTableDir(mfs.getRootDir(), this.tableName);
            if (this.preserveSplits) {
                newRegions = regions.toArray(new HRegionInfo[regions.size()]);
                LOG.info((Object)("Truncate will preserve " + newRegions.length + " regions"));
            } else {
                newRegions = new HRegionInfo[]{new HRegionInfo(this.tableName, null, null)};
                LOG.info((Object)"Truncate will not preserve the regions");
            }
            List<HRegionInfo> regionInfos = ModifyRegionUtils.createRegions(this.masterServices.getConfiguration(), tempdir, this.getTableDescriptor(), newRegions, null);
            if (!fs.rename(tempTableDir, tableDir)) {
                throw new IOException("Unable to move table from temp=" + tempTableDir + " to hbase root=" + tableDir);
            }
            MetaEditor.addRegionsToMeta(this.masterServices.getCatalogTracker(), regionInfos);
            ModifyRegionUtils.assignRegions(assignmentManager, regionInfos);
            try {
                assignmentManager.getZKTable().setEnabledTable(this.tableName);
            }
            catch (KeeperException e) {
                throw new IOException("Unable to ensure that " + this.tableName + " will be" + " enabled because of a ZooKeeper issue", e);
            }
        }
        catch (IOException e) {
            this.removeEnablingTable(assignmentManager, this.tableName);
            throw e;
        }
    }

    void checkAndSetEnablingTable(AssignmentManager assignmentManager, TableName tableName) throws IOException {
        try {
            if (!assignmentManager.getZKTable().checkAndSetEnablingTable(tableName)) {
                throw new TableExistsException(tableName);
            }
        }
        catch (KeeperException e) {
            throw new IOException("Unable to ensure that the table will be enabling because of a ZooKeeper issue", e);
        }
    }

    void removeEnablingTable(AssignmentManager assignmentManager, TableName tableName) {
        try {
            assignmentManager.getZKTable().removeEnablingTable(tableName, false);
        }
        catch (KeeperException e) {
            LOG.error((Object)("Got a keeper exception while removing the ENABLING table znode " + tableName), (Throwable)e);
        }
    }

    void removeTableData(List<HRegionInfo> regions) throws IOException, KeeperException {
        LOG.debug((Object)"Deleting regions from META");
        MetaEditor.deleteRegions(this.server.getCatalogTracker(), regions);
        MasterFileSystem mfs = this.masterServices.getMasterFileSystem();
        Path tempTableDir = mfs.moveTableToTemp(this.tableName);
        FileSystem fs = mfs.getFileSystem();
        for (HRegionInfo hri : regions) {
            LOG.debug((Object)("Archiving region " + hri.getRegionNameAsString() + " from FS"));
            HFileArchiver.archiveRegion(fs, mfs.getRootDir(), tempTableDir, HRegion.getRegionDir(tempTableDir, hri.getEncodedName()));
        }
        if (!fs.delete(tempTableDir, true)) {
            LOG.error((Object)("Couldn't delete " + tempTableDir));
        }
        LOG.debug((Object)("Table '" + this.tableName + "' archived!"));
    }

    void waitRegionInTransition(List<HRegionInfo> regions) throws IOException {
        AssignmentManager am = this.masterServices.getAssignmentManager();
        RegionStates states = am.getRegionStates();
        long waitTime = this.server.getConfiguration().getLong("hbase.master.wait.on.region", 300000L);
        for (HRegionInfo region : regions) {
            long done = System.currentTimeMillis() + waitTime;
            while (System.currentTimeMillis() < done) {
                if (states.isRegionInState(region, RegionState.State.FAILED_OPEN)) {
                    am.regionOffline(region);
                }
                if (!states.isRegionInTransition(region)) break;
                try {
                    Thread.sleep(this.waitingTimeForEvents);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Interrupted while sleeping");
                    throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                }
                LOG.debug((Object)("Waiting on region to clear regions in transition; " + am.getRegionStates().getRegionTransitionState(region)));
            }
            if (!states.isRegionInTransition(region)) continue;
            throw new IOException("Waited hbase.master.wait.on.region (" + waitTime + "ms) for region to leave region " + region.getRegionNameAsString() + " in transitions");
        }
    }
}

