/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ChainWALEntryFilter;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ScopeWALEntryFilter;
import org.apache.hadoop.hbase.replication.SystemTableWALEntryFilter;
import org.apache.hadoop.hbase.replication.TableCfWALEntryFilter;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestReplicationWALEntryFilters {
    static byte[] a = new byte[]{97};
    static byte[] b = new byte[]{98};
    static byte[] c = new byte[]{99};
    static byte[] d = new byte[]{100};
    WALEntryFilter nullFilter = new WALEntryFilter(){

        public HLog.Entry filter(HLog.Entry entry) {
            return null;
        }
    };
    WALEntryFilter passFilter = new WALEntryFilter(){

        public HLog.Entry filter(HLog.Entry entry) {
            return entry;
        }
    };

    @Test
    public void testSystemTableWALEntryFilter() {
        SystemTableWALEntryFilter filter = new SystemTableWALEntryFilter();
        HLogKey key1 = new HLogKey(HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes(), HTableDescriptor.META_TABLEDESC.getTableName(), 0L, 0L, null);
        HLog.Entry metaEntry = new HLog.Entry(key1, null);
        Assert.assertNull((Object)filter.filter(metaEntry));
        HLogKey key2 = new HLogKey(new byte[0], HTableDescriptor.NAMESPACE_TABLEDESC.getTableName(), 0L, 0L, null);
        HLog.Entry nsEntry = new HLog.Entry(key2, null);
        Assert.assertNull((Object)filter.filter(nsEntry));
        HLogKey key3 = new HLogKey(new byte[0], TableName.valueOf((String)"foo"), 0L, 0L, null);
        HLog.Entry userEntry = new HLog.Entry(key3, null);
        this.assertEquals(userEntry, filter.filter(userEntry));
    }

    @Test
    public void testScopeWALEntryFilter() {
        ScopeWALEntryFilter filter = new ScopeWALEntryFilter();
        HLog.Entry userEntry = this.createEntry(a, b);
        HLog.Entry userEntryA = this.createEntry(new byte[][]{a});
        HLog.Entry userEntryB = this.createEntry(new byte[][]{b});
        HLog.Entry userEntryEmpty = this.createEntry(new byte[0][]);
        this.assertEquals(null, filter.filter(userEntry));
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        userEntry = this.createEntry(a, b);
        userEntry.getKey().setScopes(scopes);
        this.assertEquals(null, filter.filter(userEntry));
        scopes = new TreeMap(Bytes.BYTES_COMPARATOR);
        scopes.put(c, 1);
        userEntry = this.createEntry(a, b);
        userEntry.getKey().setScopes(scopes);
        this.assertEquals(userEntryEmpty, filter.filter(userEntry));
        scopes = new TreeMap(Bytes.BYTES_COMPARATOR);
        scopes.put(a, 0);
        userEntry = this.createEntry(a, b);
        userEntry.getKey().setScopes(scopes);
        this.assertEquals(userEntryEmpty, filter.filter(userEntry));
        scopes.put(b, 0);
        this.assertEquals(userEntryEmpty, filter.filter(userEntry));
        scopes = new TreeMap(Bytes.BYTES_COMPARATOR);
        scopes.put(a, 1);
        userEntry = this.createEntry(a, b);
        userEntry.getKey().setScopes(scopes);
        this.assertEquals(userEntryA, filter.filter(userEntry));
        scopes.put(b, 0);
        this.assertEquals(userEntryA, filter.filter(userEntry));
        scopes = new TreeMap(Bytes.BYTES_COMPARATOR);
        scopes.put(b, 1);
        userEntry = this.createEntry(a, b);
        userEntry.getKey().setScopes(scopes);
        this.assertEquals(userEntryB, filter.filter(userEntry));
        scopes.put(a, 0);
        this.assertEquals(userEntryB, filter.filter(userEntry));
        scopes = new TreeMap(Bytes.BYTES_COMPARATOR);
        scopes.put(b, 1);
        userEntry = this.createEntry(a, b);
        userEntry.getKey().setScopes(scopes);
        this.assertEquals(userEntryB, filter.filter(userEntry));
        scopes.put(a, 0);
        this.assertEquals(userEntryB, filter.filter(userEntry));
    }

    @Test
    public void testChainWALEntryFilter() {
        HLog.Entry userEntry = this.createEntry(a, b, c);
        ChainWALEntryFilter filter = new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter});
        this.assertEquals(this.createEntry(a, b, c), filter.filter(userEntry));
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter, this.passFilter});
        this.assertEquals(this.createEntry(a, b, c), filter.filter(userEntry));
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter, this.passFilter, this.passFilter});
        this.assertEquals(this.createEntry(a, b, c), filter.filter(userEntry));
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{this.nullFilter});
        this.assertEquals(null, filter.filter(userEntry));
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{this.nullFilter, this.passFilter});
        this.assertEquals(null, filter.filter(userEntry));
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter, this.nullFilter});
        this.assertEquals(null, filter.filter(userEntry));
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{this.nullFilter, this.passFilter, this.nullFilter});
        this.assertEquals(null, filter.filter(userEntry));
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{this.nullFilter, this.nullFilter});
        this.assertEquals(null, filter.filter(userEntry));
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter, new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter, this.passFilter}), new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter}), new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter})}), new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter})});
        this.assertEquals(this.createEntry(a, b, c), filter.filter(userEntry));
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter, new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter, new ChainWALEntryFilter(new WALEntryFilter[]{this.nullFilter})})}), new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter})});
        this.assertEquals(null, filter.filter(userEntry));
    }

    @Test
    public void testTableCfWALEntryFilter() {
        ReplicationPeer peer = (ReplicationPeer)Mockito.mock(ReplicationPeer.class);
        Mockito.when((Object)peer.getTableCFs()).thenReturn(null);
        HLog.Entry userEntry = this.createEntry(a, b, c);
        TableCfWALEntryFilter filter = new TableCfWALEntryFilter(peer);
        this.assertEquals(this.createEntry(a, b, c), filter.filter(userEntry));
        userEntry = this.createEntry(a, b, c);
        HashMap<String, ArrayList> tableCfs = new HashMap<String, ArrayList>();
        Mockito.when((Object)peer.getTableCFs()).thenReturn(tableCfs);
        filter = new TableCfWALEntryFilter(peer);
        this.assertEquals(null, filter.filter(userEntry));
        userEntry = this.createEntry(a, b, c);
        tableCfs = new HashMap();
        tableCfs.put("bar", null);
        Mockito.when((Object)peer.getTableCFs()).thenReturn(tableCfs);
        filter = new TableCfWALEntryFilter(peer);
        this.assertEquals(null, filter.filter(userEntry));
        userEntry = this.createEntry(a, b, c);
        tableCfs = new HashMap();
        tableCfs.put("foo", Lists.newArrayList((Object[])new String[]{"a"}));
        Mockito.when((Object)peer.getTableCFs()).thenReturn(tableCfs);
        filter = new TableCfWALEntryFilter(peer);
        this.assertEquals(this.createEntry(new byte[][]{a}), filter.filter(userEntry));
        userEntry = this.createEntry(a, b, c, d);
        tableCfs = new HashMap();
        tableCfs.put("foo", Lists.newArrayList((Object[])new String[]{"a", "c"}));
        Mockito.when((Object)peer.getTableCFs()).thenReturn(tableCfs);
        filter = new TableCfWALEntryFilter(peer);
        this.assertEquals(this.createEntry(a, c), filter.filter(userEntry));
    }

    private HLog.Entry createEntry(byte[] ... kvs) {
        HLogKey key1 = new HLogKey(new byte[0], TableName.valueOf((String)"foo"), 0L, 0L, null);
        WALEdit edit1 = new WALEdit();
        for (byte[] kv : kvs) {
            edit1.add(new KeyValue(kv, kv, kv));
        }
        return new HLog.Entry(key1, edit1);
    }

    private void assertEquals(HLog.Entry e1, HLog.Entry e2) {
        Assert.assertEquals((Object)(e1 == null ? 1 : 0), (Object)(e2 == null ? 1 : 0));
        if (e1 == null) {
            return;
        }
        Assert.assertEquals((Object)(e1.getEdit() == null ? 1 : 0), (Object)(e2.getEdit() == null ? 1 : 0));
        if (e1.getEdit() == null) {
            return;
        }
        ArrayList kvs1 = e1.getEdit().getKeyValues();
        ArrayList kvs2 = e2.getEdit().getKeyValues();
        Assert.assertEquals((long)kvs1.size(), (long)kvs2.size());
        for (int i = 0; i < kvs1.size(); ++i) {
            KeyValue.COMPARATOR.compare((Cell)kvs1.get(i), (Cell)kvs2.get(i));
        }
    }
}

