/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestGetLastFlushedSequenceId {
    private final HBaseTestingUtility testUtil = new HBaseTestingUtility();
    private final TableName tableName = TableName.valueOf((String)this.getClass().getSimpleName(), (String)"test");
    private final byte[] family = Bytes.toBytes((String)"f1");
    private final byte[][] families = new byte[][]{this.family};

    @Before
    public void setUp() throws Exception {
        this.testUtil.getConfiguration().setInt("hbase.regionserver.msginterval", 1000);
        this.testUtil.startMiniCluster(1, 1);
    }

    @After
    public void tearDown() throws Exception {
        this.testUtil.shutdownMiniCluster();
    }

    @Test
    public void test() throws IOException, InterruptedException {
        this.testUtil.getHBaseAdmin().createNamespace(NamespaceDescriptor.create((String)this.tableName.getNamespaceAsString()).build());
        HTable table = this.testUtil.createTable(this.tableName, this.families);
        table.put(new Put(Bytes.toBytes((String)"k")).add(this.family, Bytes.toBytes((String)"q"), Bytes.toBytes((String)"v")));
        table.flushCommits();
        MiniHBaseCluster cluster = this.testUtil.getMiniHBaseCluster();
        List<JVMClusterUtil.RegionServerThread> rsts = cluster.getRegionServerThreads();
        HRegion region = null;
        for (int i = 0; i < cluster.getRegionServerThreads().size(); ++i) {
            HRegion r;
            HRegionServer hrs = rsts.get(i).getRegionServer();
            Iterator i$ = hrs.getOnlineRegions(this.tableName).iterator();
            if (!i$.hasNext()) continue;
            region = r = (HRegion)i$.next();
        }
        Assert.assertNotNull(region);
        Thread.sleep(2000L);
        Assert.assertEquals((long)-1L, (long)this.testUtil.getHBaseCluster().getMaster().getServerManager().getLastFlushedSequenceId(region.getRegionInfo().getEncodedNameAsBytes()));
        this.testUtil.getHBaseAdmin().flush(this.tableName.getName());
        Thread.sleep(2000L);
        Assert.assertTrue((this.testUtil.getHBaseCluster().getMaster().getServerManager().getLastFlushedSequenceId(region.getRegionInfo().getEncodedNameAsBytes()) > 0L ? 1 : 0) != 0);
        table.close();
    }
}

