/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mortbay.log.Log;

@Category(value={SmallTests.class})
public class TestHBaseAdminNoCluster {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterMonitorCollableRetries() throws MasterNotRunningException, ZooKeeperConnectionException, IOException, ServiceException {
        Configuration configuration = HBaseConfiguration.create();
        configuration.setLong("hbase.client.pause", 1L);
        int count = 10;
        configuration.setInt("hbase.client.retries.number", 10);
        HConnection connection = HConnectionTestingUtility.getMockedConnection(configuration);
        MasterKeepAliveConnection masterAdmin = (MasterKeepAliveConnection)Mockito.mock(MasterKeepAliveConnection.class);
        Mockito.when((Object)masterAdmin.createTable((RpcController)Mockito.any(), (MasterProtos.CreateTableRequest)Mockito.any())).thenThrow(new Throwable[]{new ServiceException("Test fail").initCause((Throwable)new PleaseHoldException("test"))});
        Mockito.when((Object)connection.getKeepAliveMasterService()).thenReturn((Object)masterAdmin);
        HBaseAdmin admin = new HBaseAdmin(configuration);
        try {
            HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"testMasterMonitorCollableRetries"));
            try {
                admin.createTable(htd, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
                Assert.fail();
            }
            catch (RetriesExhaustedException e) {
                Log.info((String)"Expected fail", (Object)((Object)e));
            }
            ((MasterKeepAliveConnection)Mockito.verify((Object)masterAdmin, (VerificationMode)Mockito.atLeast((int)10))).createTable((RpcController)Mockito.any(), (MasterProtos.CreateTableRequest)Mockito.any());
        }
        finally {
            admin.close();
            if (connection != null) {
                HConnectionManager.deleteConnection((Configuration)configuration);
            }
        }
    }
}

