/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.authentication;

import org.apache.directory.server.kerberos.kdc.KdcConfiguration;
import org.apache.directory.server.kerberos.kdc.authentication.AuthenticationContext;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.ErrorMessage;
import org.apache.directory.server.kerberos.shared.messages.KerberosMessage;
import org.apache.directory.server.kerberos.shared.service.ErrorMessageHandler;
import org.apache.directory.server.protocol.shared.chain.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationExceptionHandler
extends ErrorMessageHandler {
    private static final Logger log = LoggerFactory.getLogger((Class)AuthenticationExceptionHandler.class);

    public boolean execute(Context context) throws Exception {
        return false;
    }

    public boolean postprocess(Context context, Exception exception) {
        if (exception == null) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug(exception.getMessage(), (Throwable)exception);
        } else {
            log.info(exception.getMessage());
        }
        AuthenticationContext authContext = (AuthenticationContext)context;
        KdcConfiguration config = authContext.getConfig();
        KerberosException ke = (KerberosException)exception;
        ErrorMessage errorMessage = this.getErrorMessage(config.getKdcPrincipal(), ke);
        authContext.setReply((KerberosMessage)errorMessage);
        return true;
    }
}

