/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.changepw.service;

import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.changepw.exceptions.ChangePasswordException;
import org.apache.directory.server.changepw.exceptions.ErrorType;
import org.apache.directory.server.changepw.service.ChangePasswordContext;
import org.apache.directory.server.kerberos.shared.messages.components.Authenticator;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessPasswordChange
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger((Class)ProcessPasswordChange.class);
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        ChangePasswordContext changepwContext = (ChangePasswordContext)((Object)session.getAttribute(this.getContextKey()));
        PrincipalStore store = changepwContext.getStore();
        Authenticator authenticator = changepwContext.getAuthenticator();
        String password = changepwContext.getPassword();
        KerberosPrincipal clientPrincipal = authenticator.getClientPrincipal();
        KerberosKey newKey = new KerberosKey(clientPrincipal, password.toCharArray(), "DES");
        try {
            String principalName = store.changePassword(clientPrincipal, newKey);
            log.debug("Successfully modified principal {}", (Object)principalName);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ChangePasswordException(ErrorType.KRB5_KPASSWD_HARDERROR);
        }
        next.execute(session, message);
    }

    public String getContextKey() {
        return this.contextKey;
    }
}

